/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.builds;

import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CredentialsParameterBinding {
    private final String userId;
    private final String parameterName;
    private final String credentialsId;
    private final boolean isDefaultValue;

    static CredentialsParameterBinding fromParameter(@CheckForNull String userId, @NonNull CredentialsParameterValue parameterValue) {
        return new CredentialsParameterBinding(userId, parameterValue.getName(), parameterValue.getValue(), parameterValue.isDefaultValue());
    }

    private CredentialsParameterBinding(String userId, String parameterName, String credentialsId, boolean isDefaultValue) {
        this.userId = userId;
        this.parameterName = parameterName;
        this.credentialsId = credentialsId;
        this.isDefaultValue = isDefaultValue;
    }

    @CheckForNull
    public String getUserId() {
        return this.userId;
    }

    @NonNull
    public String getParameterName() {
        return this.parameterName;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public boolean isDefaultValue() {
        return this.isDefaultValue;
    }
}

