/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.XmlFile;
import hudson.cli.declarative.CLIResolver;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.LoadBalancer;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ResourceActivity;
import hudson.model.ResourceController;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.listeners.SaveableListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.Executables;
import hudson.model.queue.FoldableAction;
import hudson.model.queue.FutureImpl;
import hudson.model.queue.MappingWorksheet;
import hudson.model.queue.QueueListener;
import hudson.model.queue.QueueSorter;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.ScheduleResult;
import hudson.model.queue.SubTask;
import hudson.model.queue.WorkUnit;
import hudson.model.queue.WorkUnitContext;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.triggers.SafeTimerTask;
import hudson.util.ConsistentHash;
import hudson.util.Futures;
import hudson.util.Iterators;
import hudson.util.XStream2;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.console.WithConsoleUrl;
import jenkins.model.Jenkins;
import jenkins.model.queue.AsynchronousExecution;
import jenkins.model.queue.CompositeCauseOfBlockage;
import jenkins.model.queue.QueueIdStrategy;
import jenkins.model.queue.QueueItem;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorProvider;
import jenkins.security.stapler.StaplerAccessibleType;
import jenkins.util.AtmostOneTaskExecutor;
import jenkins.util.Listeners;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import net.jcip.annotations.GuardedBy;
import org.acegisecurity.Authentication;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.access.AccessDeniedException;

@ExportedBean
@BridgeMethodsAdded
public class Queue
extends ResourceController
implements Saveable {
    private final Set<WaitingItem> waitingList = new TreeSet<WaitingItem>();
    private final ItemList<BlockedItem> blockedProjects = new ItemList();
    private final ItemList<BuildableItem> buildables = new ItemList();
    private final ItemList<BuildableItem> pendings = new ItemList();
    private volatile transient Snapshot snapshot = new Snapshot(this.waitingList, this.blockedProjects, this.buildables, this.pendings);
    private final Cache<Long, LeftItem> leftItems = CacheBuilder.newBuilder().expireAfterWrite(300L, TimeUnit.SECONDS).build();
    private volatile transient LoadBalancer loadBalancer;
    private volatile transient QueueSorter sorter;
    private final transient AtmostOneTaskExecutor<Void> maintainerThread = new AtmostOneTaskExecutor<Void>(new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            Queue.this.maintain();
            return null;
        }

        public String toString() {
            return "Periodic Jenkins queue maintenance";
        }
    });
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition condition = this.lock.newCondition();
    private static final ConsistentHash.Hash<Node> NODE_HASH = Node::getNodeName;
    private static final Logger LOGGER = Logger.getLogger(Queue.class.getName());
    public static final XStream XSTREAM = new XStream2();

    public Queue(@NonNull LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer.sanitize();
        new MaintainTask(this).periodic();
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(@NonNull LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer.sanitize();
    }

    public QueueSorter getSorter() {
        return this.sorter;
    }

    public void setSorter(QueueSorter sorter) {
        this.sorter = sorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.lock.lock();
        try {
            try {
                this.waitingList.clear();
                this.blockedProjects.clear();
                this.buildables.clear();
                this.pendings.clear();
                File queueFile = this.getXMLQueueFile();
                if (Files.exists(queueFile.toPath(), new LinkOption[0])) {
                    List<Item> items;
                    State state;
                    Object unmarshaledObj = new XmlFile(XSTREAM, queueFile).read();
                    if (unmarshaledObj instanceof State) {
                        state = (State)unmarshaledObj;
                        items = state.items;
                    } else {
                        items = (List<Item>)unmarshaledObj;
                        state = new State();
                        state.items.addAll(items);
                    }
                    QueueIdStrategy.get().load(state);
                    for (Item o : items) {
                        if (o instanceof Task) {
                            this.schedule((Task)((Object)o), 0);
                            continue;
                        }
                        if (!(o instanceof Item)) continue;
                        Item item = o;
                        if (item.task == null) continue;
                        if (item instanceof WaitingItem) {
                            item.enter(this);
                            continue;
                        }
                        if (item instanceof BlockedItem) {
                            item.enter(this);
                            continue;
                        }
                        if (item instanceof BuildableItem) {
                            item.enter(this);
                            continue;
                        }
                        throw new IllegalStateException("Unknown item type! " + item);
                    }
                    File bk = new File(queueFile.getPath() + ".bak");
                    Files.move(queueFile.toPath(), bk.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException | InvalidPathException e) {
                LOGGER.log(Level.WARNING, "Failed to load the queue file " + this.getXMLQueueFile(), e);
            }
            finally {
                this.updateSnapshot();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (BulkChange.contains(this)) {
            return;
        }
        if (Jenkins.getInstanceOrNull() == null) {
            return;
        }
        XmlFile queueFile = new XmlFile(XSTREAM, this.getXMLQueueFile());
        this.lock.lock();
        try {
            State state = new State();
            QueueIdStrategy.get().persist(state);
            for (Item item : this.getItems()) {
                if (item.task instanceof TransientTask) continue;
                state.items.add(item);
            }
            try {
                queueFile.write(state);
            }
            catch (IOException e) {
                LOGGER.log(e instanceof ClosedByInterruptException ? Level.FINE : Level.WARNING, "Failed to write out the queue file " + this.getXMLQueueFile(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
        SaveableListener.fireOnChange(this, queueFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.lock.lock();
        try {
            try {
                for (WaitingItem i : new ArrayList<WaitingItem>(this.waitingList)) {
                    i.cancel(this);
                }
                this.blockedProjects.cancelAll();
                this.pendings.cancelAll();
                this.buildables.cancelAll();
            }
            finally {
                this.updateSnapshot();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.scheduleMaintenance();
    }

    File getXMLQueueFile() {
        String id = SystemProperties.getString(Queue.class.getName() + ".id");
        if (id != null) {
            return new File(Jenkins.get().getRootDir(), "queue/" + id + ".xml");
        }
        return new File(Jenkins.get().getRootDir(), "queue.xml");
    }

    @Deprecated
    public boolean add(AbstractProject p) {
        return this.schedule(p) != null;
    }

    @CheckForNull
    public WaitingItem schedule(AbstractProject p) {
        return this.schedule(p, p.getQuietPeriod());
    }

    @Deprecated
    public boolean add(AbstractProject p, int quietPeriod) {
        return this.schedule(p, quietPeriod) != null;
    }

    @Deprecated
    public WaitingItem schedule(Task p, int quietPeriod, List<Action> actions) {
        return this.schedule2(p, quietPeriod, actions).getCreateItem();
    }

    /*
     * Exception decompiling
     */
    @NonNull
    public ScheduleResult schedule2(Task p, int quietPeriod, List<Action> actions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ScheduleResult scheduleInternal(Task p, int quietPeriod, List<Action> actions) {
        this.lock.lock();
        try {
            ArrayList<Item> duplicatesInQueue;
            GregorianCalendar due;
            block15: {
                due = new GregorianCalendar();
                ((Calendar)due).add(13, quietPeriod);
                duplicatesInQueue = new ArrayList<Item>();
                for (Item existing : this.liveGetItems(p)) {
                    boolean shouldScheduleItem = false;
                    for (QueueAction action : existing.getActions(QueueAction.class)) {
                        shouldScheduleItem |= action.shouldSchedule(actions);
                    }
                    for (QueueAction action : Util.filter(actions, QueueAction.class)) {
                        shouldScheduleItem |= action.shouldSchedule(new ArrayList<Action>(existing.getAllActions()));
                    }
                    if (shouldScheduleItem) continue;
                    duplicatesInQueue.add(existing);
                }
                if (!duplicatesInQueue.isEmpty()) break block15;
                LOGGER.log(Level.FINE, "{0} added to queue", p);
                WaitingItem added = new WaitingItem(due, p, actions);
                added.enter(this);
                this.scheduleMaintenance();
                ScheduleResult.Created created = ScheduleResult.created(added);
                this.updateSnapshot();
                return created;
            }
            try {
                LOGGER.log(Level.FINE, "{0} is already in the queue", p);
                for (Item item : duplicatesInQueue) {
                    for (FoldableAction a : Util.filter(actions, FoldableAction.class)) {
                        a.foldIntoExisting(item, p, actions);
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, "after folding {0}, {1} includes {2}", new Object[]{a, item, item.getAllActions()});
                    }
                }
                boolean queueUpdated = false;
                for (WaitingItem wi : Util.filter(duplicatesInQueue, WaitingItem.class)) {
                    if (wi.timestamp.before(due)) continue;
                    wi.leave(this);
                    wi.timestamp = due;
                    wi.enter(this);
                    queueUpdated = true;
                }
                if (queueUpdated) {
                    this.scheduleMaintenance();
                }
                ScheduleResult.Existing existing = ScheduleResult.existing((Item)duplicatesInQueue.get(0));
                this.updateSnapshot();
                return existing;
            }
            catch (Throwable throwable) {
                this.updateSnapshot();
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public boolean add(Task p, int quietPeriod) {
        return this.schedule(p, quietPeriod) != null;
    }

    @CheckForNull
    public WaitingItem schedule(Task p, int quietPeriod) {
        return this.schedule(p, quietPeriod, new Action[0]);
    }

    @Deprecated
    public boolean add(Task p, int quietPeriod, Action ... actions) {
        return this.schedule(p, quietPeriod, actions) != null;
    }

    @CheckForNull
    public WaitingItem schedule(Task p, int quietPeriod, Action ... actions) {
        return this.schedule2(p, quietPeriod, actions).getCreateItem();
    }

    @NonNull
    public ScheduleResult schedule2(Task p, int quietPeriod, Action ... actions) {
        return this.schedule2(p, quietPeriod, Arrays.asList(actions));
    }

    /*
     * Exception decompiling
     */
    public boolean cancel(Task p) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateSnapshot() {
        Snapshot revised = new Snapshot(this.waitingList, this.blockedProjects, this.buildables, this.pendings);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} \u2192 {1}; leftItems={2}", new Object[]{this.snapshot, revised, this.leftItems.asMap()});
        }
        this.snapshot = revised;
    }

    public boolean cancel(Item item) {
        LOGGER.log(Level.FINE, "Cancelling {0} item#{1}", new Object[]{item.task, item.id});
        this.lock.lock();
        try {
            try {
                boolean bl = item.cancel(this);
                this.updateSnapshot();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateSnapshot();
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @RequirePOST
    public HttpResponse doCancelItem(@QueryParameter long id) throws IOException, ServletException {
        Item item = this.getItem(id);
        if (item != null && !Queue.hasReadPermission(item, true)) {
            item = null;
        }
        if (item != null) {
            if (item.hasCancelPermission()) {
                if (this.cancel(item)) {
                    return HttpResponses.status((int)204);
                }
                return HttpResponses.error((int)500, (String)("Could not cancel run for id " + id));
            }
            return HttpResponses.error((int)422, (String)("Item for id (" + id + ") is not cancellable"));
        }
        return HttpResponses.error((int)404, (String)("Provided id (" + id + ") not found"));
    }

    public boolean isEmpty() {
        Snapshot snapshot = this.snapshot;
        return snapshot.waitingList.isEmpty() && snapshot.blockedProjects.isEmpty() && snapshot.buildables.isEmpty() && snapshot.pendings.isEmpty();
    }

    private WaitingItem peek() {
        return this.waitingList.iterator().next();
    }

    @Exported(inline=true)
    public Item[] getItems() {
        Snapshot s = this.snapshot;
        List<Item> r = new ArrayList<Item>();
        for (WaitingItem waitingItem : s.waitingList) {
            r = this.checkPermissionsAndAddToList(r, waitingItem);
        }
        for (BlockedItem blockedItem : s.blockedProjects) {
            r = this.checkPermissionsAndAddToList(r, blockedItem);
        }
        for (BuildableItem buildableItem : Iterators.reverse(s.buildables)) {
            r = this.checkPermissionsAndAddToList(r, buildableItem);
        }
        for (BuildableItem buildableItem : Iterators.reverse(s.pendings)) {
            r = this.checkPermissionsAndAddToList(r, buildableItem);
        }
        Item[] items = new Item[r.size()];
        r.toArray(items);
        return items;
    }

    private List<Item> checkPermissionsAndAddToList(List<Item> r, Item t) {
        if (Queue.hasReadPermission(t.task, false)) {
            r.add(t);
        }
        return r;
    }

    private static boolean hasReadPermission(Item t, boolean valueIfNotAccessControlled) {
        return Queue.hasReadPermission(t.task, valueIfNotAccessControlled);
    }

    private static boolean hasReadPermission(Task t, boolean valueIfNotAccessControlled) {
        if (t instanceof AccessControlled) {
            AccessControlled taskAC = (AccessControlled)((Object)t);
            return taskAC.hasPermission(hudson.model.Item.READ) || taskAC.hasPermission(Permission.READ);
        }
        return valueIfNotAccessControlled;
    }

    @Restricted(value={NoExternalUse.class})
    @Exported(inline=true)
    public StubItem[] getDiscoverableItems() {
        Snapshot s = this.snapshot;
        List<StubItem> r = new ArrayList<StubItem>();
        for (WaitingItem waitingItem : s.waitingList) {
            r = this.filterDiscoverableItemListBasedOnPermissions(r, waitingItem);
        }
        for (BlockedItem blockedItem : s.blockedProjects) {
            r = this.filterDiscoverableItemListBasedOnPermissions(r, blockedItem);
        }
        for (BuildableItem buildableItem : Iterators.reverse(s.buildables)) {
            r = this.filterDiscoverableItemListBasedOnPermissions(r, buildableItem);
        }
        for (BuildableItem buildableItem : Iterators.reverse(s.pendings)) {
            r = this.filterDiscoverableItemListBasedOnPermissions(r, buildableItem);
        }
        StubItem[] items = new StubItem[r.size()];
        r.toArray(items);
        return items;
    }

    private List<StubItem> filterDiscoverableItemListBasedOnPermissions(List<StubItem> r, Item t) {
        hudson.model.Item taskAsItem;
        if (t.task instanceof hudson.model.Item && !(taskAsItem = (hudson.model.Item)((Object)t.task)).hasPermission(hudson.model.Item.READ) && taskAsItem.hasPermission(hudson.model.Item.DISCOVER)) {
            r.add(new StubItem(new StubTask(t.task)));
        }
        return r;
    }

    @Deprecated
    public List<Item> getApproximateItemsQuickly() {
        return Arrays.asList(this.getItems());
    }

    public Item getItem(long id) {
        Snapshot snapshot = this.snapshot;
        for (Item item : snapshot.blockedProjects) {
            if (item.id != id) continue;
            return item;
        }
        for (Item item : snapshot.buildables) {
            if (item.id != id) continue;
            return item;
        }
        for (Item item : snapshot.pendings) {
            if (item.id != id) continue;
            return item;
        }
        for (Item item : snapshot.waitingList) {
            if (item.id != id) continue;
            return item;
        }
        return (Item)this.leftItems.getIfPresent((Object)id);
    }

    public List<BuildableItem> getBuildableItems(Computer c) {
        Snapshot snapshot = this.snapshot;
        ArrayList<BuildableItem> result = new ArrayList<BuildableItem>();
        this._getBuildableItems(c, snapshot.buildables, result);
        this._getBuildableItems(c, snapshot.pendings, result);
        return result;
    }

    private void _getBuildableItems(Computer c, List<BuildableItem> col, List<BuildableItem> result) {
        Node node = c.getNode();
        if (node == null) {
            return;
        }
        for (BuildableItem p : col) {
            if (node.canTake(p) != null) continue;
            result.add(p);
        }
    }

    public List<BuildableItem> getBuildableItems() {
        Snapshot snapshot = this.snapshot;
        ArrayList<BuildableItem> r = new ArrayList<BuildableItem>(snapshot.buildables);
        r.addAll(snapshot.pendings);
        return r;
    }

    public List<BuildableItem> getPendingItems() {
        return new ArrayList<BuildableItem>(this.snapshot.pendings);
    }

    protected List<BlockedItem> getBlockedItems() {
        return new ArrayList<BlockedItem>(this.snapshot.blockedProjects);
    }

    public Collection<LeftItem> getLeftItems() {
        return Collections.unmodifiableCollection(this.leftItems.asMap().values());
    }

    public void clearLeftItems() {
        this.leftItems.invalidateAll();
    }

    public List<Item> getUnblockedItems() {
        Snapshot snapshot = this.snapshot;
        ArrayList<Item> queuedNotBlocked = new ArrayList<Item>();
        queuedNotBlocked.addAll(snapshot.waitingList);
        queuedNotBlocked.addAll(snapshot.buildables);
        queuedNotBlocked.addAll(snapshot.pendings);
        return queuedNotBlocked;
    }

    public Set<Task> getUnblockedTasks() {
        List<Item> items = this.getUnblockedItems();
        HashSet<Task> unblockedTasks = new HashSet<Task>(items.size());
        for (Item t : items) {
            unblockedTasks.add(t.task);
        }
        return unblockedTasks;
    }

    public boolean isPending(Task t) {
        Snapshot snapshot = this.snapshot;
        for (BuildableItem i : snapshot.pendings) {
            if (!i.task.equals(t)) continue;
            return true;
        }
        return false;
    }

    public int countBuildableItemsFor(@CheckForNull Label l) {
        Snapshot snapshot = this.snapshot;
        int r = 0;
        for (BuildableItem bi : snapshot.buildables) {
            for (SubTask subTask : bi.task.getSubTasks()) {
                if (null != l && bi.getAssignedLabelFor(subTask) != l) continue;
                ++r;
            }
        }
        for (BuildableItem bi : snapshot.pendings) {
            for (SubTask subTask : bi.task.getSubTasks()) {
                if (null != l && bi.getAssignedLabelFor(subTask) != l) continue;
                ++r;
            }
        }
        return r;
    }

    public int strictCountBuildableItemsFor(@CheckForNull Label l) {
        Snapshot _snapshot = this.snapshot;
        int r = 0;
        for (BuildableItem bi : _snapshot.buildables) {
            for (SubTask subTask : bi.task.getSubTasks()) {
                if (bi.getAssignedLabelFor(subTask) != l) continue;
                ++r;
            }
        }
        for (BuildableItem bi : _snapshot.pendings) {
            for (SubTask subTask : bi.task.getSubTasks()) {
                if (bi.getAssignedLabelFor(subTask) != l) continue;
                ++r;
            }
        }
        return r;
    }

    public int countBuildableItems() {
        return this.countBuildableItemsFor(null);
    }

    public Item getItem(Task t) {
        Snapshot snapshot = this.snapshot;
        for (Item item : snapshot.blockedProjects) {
            if (!item.task.equals(t)) continue;
            return item;
        }
        for (Item item : snapshot.buildables) {
            if (!item.task.equals(t)) continue;
            return item;
        }
        for (Item item : snapshot.pendings) {
            if (!item.task.equals(t)) continue;
            return item;
        }
        for (Item item : snapshot.waitingList) {
            if (!item.task.equals(t)) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Item> liveGetItems(Task t) {
        this.lock.lock();
        try {
            List<BuildableItem> thePendings;
            ArrayList<Item> result = new ArrayList<Item>();
            result.addAll(this.blockedProjects.getAll(t));
            result.addAll(this.buildables.getAll(t));
            if (LOGGER.isLoggable(Level.FINE) && !(thePendings = this.pendings.getAll(t)).isEmpty()) {
                LOGGER.log(Level.FINE, "ignoring {0} during scheduleInternal", thePendings);
            }
            for (Item item : this.waitingList) {
                if (!item.task.equals(t)) continue;
                result.add(item);
            }
            ArrayList<Item> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Item> getItems(Task t) {
        Snapshot snapshot = this.snapshot;
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item item : snapshot.blockedProjects) {
            if (!item.task.equals(t)) continue;
            result.add(item);
        }
        for (Item item : snapshot.buildables) {
            if (!item.task.equals(t)) continue;
            result.add(item);
        }
        for (Item item : snapshot.pendings) {
            if (!item.task.equals(t)) continue;
            result.add(item);
        }
        for (Item item : snapshot.waitingList) {
            if (!item.task.equals(t)) continue;
            result.add(item);
        }
        return result;
    }

    public boolean contains(Task t) {
        return this.getItem(t) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStartExecuting(Executor exec) throws InterruptedException {
        this.lock.lock();
        try {
            try {
                WorkUnit wu = exec.getCurrentWorkUnit();
                this.pendings.remove(wu.context.item);
                LeftItem li = new LeftItem(wu.context);
                li.enter(this);
            }
            finally {
                this.updateSnapshot();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @WithBridgeMethods(value={void.class})
    public Future<?> scheduleMaintenance() {
        return this.maintainerThread.submit();
    }

    @CheckForNull
    private CauseOfBlockage getCauseOfBlockageForItem(Item i) {
        CauseOfBlockage causeOfBlockage = this.getCauseOfBlockageForTask(i.task);
        if (causeOfBlockage != null) {
            return causeOfBlockage;
        }
        for (QueueTaskDispatcher d : QueueTaskDispatcher.all()) {
            try {
                causeOfBlockage = d.canRun(i);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, t, () -> String.format("Exception evaluating if the queue can run the task '%s'", i.task.getName()));
                causeOfBlockage = CauseOfBlockage.fromMessage(Messages._Queue_ExceptionCanRun());
            }
            if (causeOfBlockage == null) continue;
            return causeOfBlockage;
        }
        if (!(i instanceof BuildableItem) && !i.task.isConcurrentBuild() && (this.buildables.containsKey(i.task) || this.pendings.containsKey(i.task))) {
            return CauseOfBlockage.fromMessage(Messages._Queue_InProgress());
        }
        return null;
    }

    @CheckForNull
    private CauseOfBlockage getCauseOfBlockageForTask(Task task) {
        ResourceActivity r;
        CauseOfBlockage causeOfBlockage = task.getCauseOfBlockage();
        if (causeOfBlockage != null) {
            return causeOfBlockage;
        }
        if (!this.canRun(task.getResourceList()) && (r = this.getBlockingActivity(task)) != null) {
            if (r == task) {
                return CauseOfBlockage.fromMessage(Messages._Queue_InProgress());
            }
            return CauseOfBlockage.fromMessage(Messages._Queue_BlockedBy(r.getDisplayName()));
        }
        return null;
    }

    public static void withLock(Runnable runnable) {
        Queue queue;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue2 = queue = jenkins == null ? null : jenkins.getQueue();
        if (queue == null) {
            runnable.run();
        } else {
            queue._withLock(runnable);
        }
    }

    public static <V, T extends Throwable> V withLock(hudson.remoting.Callable<V, T> callable) throws T {
        Queue queue;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue2 = queue = jenkins == null ? null : jenkins.getQueue();
        if (queue == null) {
            return (V)callable.call();
        }
        return queue._withLock(callable);
    }

    public static <V> V withLock(Callable<V> callable) throws Exception {
        Queue queue;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue2 = queue = jenkins == null ? null : jenkins.getQueue();
        if (queue == null) {
            return callable.call();
        }
        return queue._withLock(callable);
    }

    public static boolean tryWithLock(Runnable runnable) {
        Queue queue;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue2 = queue = jenkins == null ? null : jenkins.getQueue();
        if (queue == null) {
            runnable.run();
            return true;
        }
        return queue._tryWithLock(runnable);
    }

    public static Runnable wrapWithLock(Runnable runnable) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue = jenkins == null ? null : jenkins.getQueue();
        return queue == null ? runnable : new LockedRunnable(runnable);
    }

    public static <V, T extends Throwable> hudson.remoting.Callable<V, T> wrapWithLock(hudson.remoting.Callable<V, T> callable) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue = jenkins == null ? null : jenkins.getQueue();
        return queue == null ? callable : new LockedHRCallable(callable);
    }

    public static <V> Callable<V> wrapWithLock(Callable<V> callable) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue = jenkins == null ? null : jenkins.getQueue();
        return queue == null ? callable : new LockedJUCCallable(callable);
    }

    @Override
    @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="the caller does indeed call this method in a loop")
    protected void _await() throws InterruptedException {
        this.condition.await();
    }

    @Override
    protected void _signalAll() {
        this.condition.signalAll();
    }

    @Override
    protected void _withLock(Runnable runnable) {
        this.lock.lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean _tryWithLock(Runnable runnable) {
        if (this.lock.tryLock()) {
            try {
                runnable.run();
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    @Override
    protected <V, T extends Throwable> V _withLock(hudson.remoting.Callable<V, T> callable) throws T {
        this.lock.lock();
        try {
            Object object = callable.call();
            return (V)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected <V> V _withLock(Callable<V> callable) throws Exception {
        this.lock.lock();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintain() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return;
        }
        this.lock.lock();
        try {
            try {
                String taskDisplayName;
                LOGGER.log(Level.FINE, "Queue maintenance started on {0} with {1}", new Object[]{this, this.snapshot});
                HashMap<Executor, JobOffer> parked = new HashMap<Executor, JobOffer>();
                ArrayList<BuildableItem> lostPendings = new ArrayList<BuildableItem>(this.pendings);
                for (Computer c : jenkins.getComputers()) {
                    for (Executor e : c.getAllExecutors()) {
                        Object workUnit;
                        if (e.isInterrupted()) {
                            lostPendings.clear();
                            LOGGER.log(Level.FINEST, "Interrupt thread for executor {0} is set and we do not know what work unit was on the executor.", e.getDisplayName());
                            continue;
                        }
                        if (e.isParking()) {
                            LOGGER.log(Level.FINEST, "{0} is parking and is waiting for a job to execute.", e.getDisplayName());
                            parked.put(e, new JobOffer(e));
                        }
                        if ((workUnit = e.getCurrentWorkUnit()) == null) continue;
                        lostPendings.remove(((WorkUnit)workUnit).context.item);
                    }
                }
                for (BuildableItem buildableItem : lostPendings) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "BuildableItem {0}: pending -> buildable as the assigned executor disappeared", buildableItem.task.getFullDisplayName());
                    }
                    buildableItem.isPending = false;
                    this.pendings.remove(buildableItem);
                    this.makeBuildable(buildableItem);
                }
                QueueSorter s = this.sorter;
                ArrayList<BlockedItem> blockedItems = new ArrayList<BlockedItem>(this.blockedProjects.values());
                if (s != null) {
                    s.sortBlockedItems(blockedItems);
                } else {
                    blockedItems.sort(QueueSorter.DEFAULT_BLOCKED_ITEM_COMPARATOR);
                }
                for (BlockedItem p : blockedItems) {
                    taskDisplayName = LOGGER.isLoggable(Level.FINEST) ? p.task.getFullDisplayName() : null;
                    LOGGER.log(Level.FINEST, "Current blocked item: {0}", taskDisplayName);
                    CauseOfBlockage causeOfBlockage = this.getCauseOfBlockageForItem(p);
                    if (causeOfBlockage == null) {
                        LOGGER.log(Level.FINEST, "BlockedItem {0}: blocked -> buildable as the build is not blocked and new tasks are allowed", taskDisplayName);
                        Runnable r = this.makeBuildable(new BuildableItem(p));
                        if (r == null) continue;
                        p.leave(this);
                        r.run();
                        this.updateSnapshot();
                        continue;
                    }
                    p.setCauseOfBlockage(causeOfBlockage);
                }
                while (!this.waitingList.isEmpty()) {
                    WaitingItem top = this.peek();
                    if (top.timestamp.compareTo(new GregorianCalendar()) > 0) {
                        LOGGER.log(Level.FINEST, "Finished moving all ready items from queue.");
                        break;
                    }
                    top.leave(this);
                    CauseOfBlockage causeOfBlockage = this.getCauseOfBlockageForItem(top);
                    if (causeOfBlockage == null) {
                        String topTaskDisplayName;
                        Runnable r = this.makeBuildable(new BuildableItem(top));
                        String string = topTaskDisplayName = LOGGER.isLoggable(Level.FINEST) ? top.task.getFullDisplayName() : null;
                        if (r != null) {
                            LOGGER.log(Level.FINEST, "Executing runnable {0}", topTaskDisplayName);
                            r.run();
                            continue;
                        }
                        LOGGER.log(Level.FINEST, "Item {0} was unable to be made a buildable and is now a blocked item.", topTaskDisplayName);
                        new BlockedItem(top, CauseOfBlockage.fromMessage(Messages._Queue_HudsonIsAboutToShutDown())).enter(this);
                        continue;
                    }
                    new BlockedItem(top, causeOfBlockage).enter(this);
                }
                if (s != null) {
                    try {
                        s.sortBuildableItems(this.buildables);
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "s.sortBuildableItems() threw Throwable: {0}", e);
                    }
                }
                this.updateSnapshot();
                for (BuildableItem buildableItem : new ArrayList<BuildableItem>(this.buildables)) {
                    CauseOfBlockage causeOfBlockage = this.getCauseOfBlockageForItem(buildableItem);
                    if (causeOfBlockage != null) {
                        buildableItem.leave(this);
                        new BlockedItem(buildableItem, causeOfBlockage).enter(this);
                        LOGGER.log(Level.FINE, "Catching that {0} is blocked in the last minute", buildableItem);
                        this.updateSnapshot();
                        continue;
                    }
                    String string = taskDisplayName = LOGGER.isLoggable(Level.FINEST) ? buildableItem.task.getFullDisplayName() : null;
                    if (buildableItem.task instanceof FlyweightTask) {
                        Runnable r = this.makeFlyWeightTaskBuildable(new BuildableItem(buildableItem));
                        if (r == null) continue;
                        buildableItem.leave(this);
                        LOGGER.log(Level.FINEST, "Executing flyweight task {0}", taskDisplayName);
                        r.run();
                        this.updateSnapshot();
                        continue;
                    }
                    ArrayList<JobOffer> candidates = new ArrayList<JobOffer>(parked.size());
                    HashMap<Node, CauseOfBlockage> reasonMap = new HashMap<Node, CauseOfBlockage>();
                    for (JobOffer j : parked.values()) {
                        CauseOfBlockage reason;
                        Node offerNode = j.getNode();
                        if (reasonMap.containsKey(offerNode)) {
                            reason = (CauseOfBlockage)reasonMap.get(offerNode);
                        } else {
                            reason = j.getCauseOfBlockage(buildableItem);
                            reasonMap.put(offerNode, reason);
                        }
                        if (reason == null) {
                            LOGGER.log(Level.FINEST, "{0} is a potential candidate for task {1}", new Object[]{j, taskDisplayName});
                            candidates.add(j);
                            continue;
                        }
                        LOGGER.log(Level.FINEST, "{0} rejected {1}: {2}", new Object[]{j, taskDisplayName, reason});
                    }
                    MappingWorksheet ws = new MappingWorksheet(buildableItem, candidates);
                    MappingWorksheet.Mapping m = this.loadBalancer.map(buildableItem.task, ws);
                    if (m == null) {
                        LOGGER.log(Level.FINER, "Failed to map {0} to executors. candidates={1} parked={2}", new Object[]{buildableItem, candidates, parked.values()});
                        List reasons = reasonMap.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
                        buildableItem.transientCausesOfBlockage = reasons.isEmpty() ? null : reasons;
                        continue;
                    }
                    WorkUnitContext wuc = new WorkUnitContext(buildableItem);
                    LOGGER.log(Level.FINEST, "Found a matching executor for {0}. Using it.", taskDisplayName);
                    m.execute(wuc);
                    buildableItem.leave(this);
                    if (!wuc.getWorkUnits().isEmpty()) {
                        LOGGER.log(Level.FINEST, "BuildableItem {0} marked as pending.", taskDisplayName);
                        this.makePending(buildableItem);
                    } else {
                        LOGGER.log(Level.FINEST, "BuildableItem {0} with empty work units!?", buildableItem);
                    }
                    this.updateSnapshot();
                }
            }
            finally {
                this.updateSnapshot();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @CheckForNull
    private Runnable makeBuildable(BuildableItem p) {
        if (p.task instanceof FlyweightTask) {
            String taskDisplayName;
            String string = taskDisplayName = LOGGER.isLoggable(Level.FINEST) ? p.task.getFullDisplayName() : null;
            if (!Queue.isBlockedByShutdown(p.task)) {
                Runnable runnable = this.makeFlyWeightTaskBuildable(p);
                LOGGER.log(Level.FINEST, "Converting flyweight task: {0} into a BuildableRunnable", taskDisplayName);
                if (runnable != null) {
                    return runnable;
                }
                LOGGER.log(Level.FINEST, "Flyweight task {0} is entering as buildable to provision a node.", taskDisplayName);
                return new BuildableRunnable(p);
            }
            LOGGER.log(Level.FINEST, "Task {0} is blocked by shutdown.", taskDisplayName);
            return null;
        }
        return new BuildableRunnable(p);
    }

    @CheckForNull
    private Runnable makeFlyWeightTaskBuildable(BuildableItem p) {
        if (p.task instanceof FlyweightTask) {
            Jenkins h = Jenkins.get();
            Label lbl = p.getAssignedLabel();
            Computer masterComputer = h.toComputer();
            if (lbl != null && lbl.equals(h.getSelfLabel()) && masterComputer != null) {
                if (h.canTake(p) == null) {
                    return this.createFlyWeightTaskRunnable(p, masterComputer);
                }
                return null;
            }
            if (lbl == null && h.canTake(p) == null && masterComputer != null && masterComputer.isOnline() && masterComputer.isAcceptingTasks()) {
                return this.createFlyWeightTaskRunnable(p, masterComputer);
            }
            HashMap<Node, Integer> hashSource = new HashMap<Node, Integer>(h.getNodes().size());
            for (Node n : h.getNodes()) {
                hashSource.put(n, n.getNumExecutors() * 100);
            }
            ConsistentHash<Node> hash = new ConsistentHash<Node>(NODE_HASH);
            hash.addAll((Map<Node, Integer>)hashSource);
            String fullDisplayName = p.task.getFullDisplayName();
            for (Node n : hash.list(fullDisplayName)) {
                Computer c = n.toComputer();
                if (c == null || c.isOffline() || lbl != null && !lbl.contains(n) || n.canTake(p) != null) continue;
                return this.createFlyWeightTaskRunnable(p, c);
            }
        }
        return null;
    }

    private Runnable createFlyWeightTaskRunnable(BuildableItem p, @NonNull Computer c) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Creating flyweight task {0} for computer {1}", new Object[]{p.task.getFullDisplayName(), c.getName()});
        }
        return () -> {
            c.startFlyWeightTask(new WorkUnitContext(p).createWorkUnit(p.task));
            this.makePending(p);
        };
    }

    private boolean makePending(BuildableItem p) {
        p.isPending = true;
        return this.pendings.add(p);
    }

    @Deprecated
    public static boolean ifBlockedByHudsonShutdown(Task task) {
        return Queue.isBlockedByShutdown(task);
    }

    public static boolean isBlockedByShutdown(Task task) {
        return Jenkins.get().isQuietingDown() && !(task instanceof NonBlockingTask);
    }

    public Api getApi() {
        return new Api(this);
    }

    @CLIResolver
    public static Queue getInstance() {
        return Jenkins.get().getQueue();
    }

    @Initializer(after=InitMilestone.JOB_CONFIG_ADAPTED)
    public static void init(Jenkins h) {
        Queue queue = h.getQueue();
        Item[] items = queue.getItems();
        if (items.length > 0) {
            LOGGER.warning(() -> "Loading queue will discard previously scheduled items: " + Arrays.toString(items));
        }
        queue.load();
    }

    static {
        XSTREAM.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class klazz) {
                return hudson.model.Item.class.isAssignableFrom(klazz);
            }

            public Object fromString(String string) {
                hudson.model.Item item = Jenkins.get().getItemByFullName(string);
                if (item == null) {
                    throw new NoSuchElementException("No such job exists: " + string);
                }
                return item;
            }

            public String toString(Object item) {
                return ((hudson.model.Item)item).getFullName();
            }
        });
        XSTREAM.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class klazz) {
                return Run.class.isAssignableFrom(klazz);
            }

            public Object fromString(String string) {
                String[] split = string.split("#");
                String projectName = split[0];
                int buildNumber = Integer.parseInt(split[1]);
                Job job = (Job)Jenkins.get().getItemByFullName(projectName);
                if (job == null) {
                    throw new NoSuchElementException("No such job exists: " + projectName);
                }
                Object run = job.getBuildByNumber(buildNumber);
                if (run == null) {
                    throw new NoSuchElementException("No such build: " + string);
                }
                return run;
            }

            public String toString(Object object) {
                Run run = (Run)object;
                return ((AbstractItem)run.getParent()).getFullName() + "#" + run.getNumber();
            }
        });
        XSTREAM.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class klazz) {
                return Queue.class.isAssignableFrom(klazz);
            }

            public Object fromString(String string) {
                return Jenkins.get().getQueue();
            }

            public String toString(Object item) {
                return "queue";
            }
        });
    }

    private class ItemList<T extends Item>
    extends ArrayList<T> {
        private ItemList() {
        }

        public T get(Task task) {
            for (Item item : this) {
                if (!item.task.equals(task)) continue;
                return (T)item;
            }
            return null;
        }

        public List<T> getAll(Task task) {
            ArrayList<Item> result = new ArrayList<Item>();
            for (Item item : this) {
                if (!item.task.equals(task)) continue;
                result.add(item);
            }
            return result;
        }

        public boolean containsKey(Task task) {
            return this.get(task) != null;
        }

        public T remove(Task task) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Item t = (Item)it.next();
                if (!t.task.equals(task)) continue;
                it.remove();
                return (T)t;
            }
            return null;
        }

        public void put(Task task, T item) {
            assert (((Item)item).task.equals(task));
            this.add(item);
        }

        public ItemList<T> values() {
            return this;
        }

        public T cancel(Task p) {
            T x = this.get(p);
            if (x != null) {
                ((Item)x).cancel(Queue.this);
            }
            return x;
        }

        @SuppressFBWarnings(value={"IA_AMBIGUOUS_INVOCATION_OF_INHERITED_OR_OUTER_METHOD"}, justification="It will invoke the inherited clear() method according to Java semantics. FindBugs recommends suppressing warnings in such case")
        public void cancelAll() {
            for (Item t : new ArrayList(this)) {
                t.cancel(Queue.this);
            }
            this.clear();
        }
    }

    private static class Snapshot {
        private final Set<WaitingItem> waitingList;
        private final List<BlockedItem> blockedProjects;
        private final List<BuildableItem> buildables;
        private final List<BuildableItem> pendings;

        Snapshot(Set<WaitingItem> waitingList, List<BlockedItem> blockedProjects, List<BuildableItem> buildables, List<BuildableItem> pendings) {
            this.waitingList = new LinkedHashSet<WaitingItem>(waitingList);
            this.blockedProjects = new ArrayList<BlockedItem>(blockedProjects);
            this.buildables = new ArrayList<BuildableItem>(buildables);
            this.pendings = new ArrayList<BuildableItem>(pendings);
        }

        public String toString() {
            return "Queue.Snapshot{waitingList=" + this.waitingList + ";blockedProjects=" + this.blockedProjects + ";buildables=" + this.buildables + ";pendings=" + this.pendings + "}";
        }
    }

    private static class MaintainTask
    extends SafeTimerTask {
        private final WeakReference<Queue> queue;

        MaintainTask(Queue queue) {
            this.queue = new WeakReference<Queue>(queue);
        }

        private void periodic() {
            long interval = 5000L;
            Timer.get().scheduleWithFixedDelay(this, interval, interval, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void doRun() {
            Queue q = (Queue)this.queue.get();
            if (q != null) {
                q.maintain();
            } else {
                this.cancel();
            }
        }
    }

    @Restricted(value={Beta.class})
    public static final class State {
        public List<Item> items = new ArrayList<Item>();
        public Map<String, Object> properties = new HashMap<String, Object>();

        private Object readResolve() {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            return this;
        }
    }

    public static interface Task
    extends ModelObject,
    SubTask {
        @Deprecated
        default public boolean isBuildBlocked() {
            return this.getCauseOfBlockage() != null;
        }

        @Deprecated
        default public String getWhyBlocked() {
            CauseOfBlockage cause = this.getCauseOfBlockage();
            return cause != null ? cause.getShortDescription() : null;
        }

        @CheckForNull
        default public CauseOfBlockage getCauseOfBlockage() {
            return null;
        }

        public String getName();

        public String getFullDisplayName();

        default public String getAffinityKey() {
            return this.getFullDisplayName();
        }

        default public void checkAbortPermission() {
            if (this instanceof AccessControlled) {
                ((AccessControlled)((Object)this)).checkPermission(hudson.model.Item.CANCEL);
            }
        }

        default public boolean hasAbortPermission() {
            if (this instanceof AccessControlled) {
                return ((AccessControlled)((Object)this)).hasPermission(hudson.model.Item.CANCEL);
            }
            return true;
        }

        public String getUrl();

        default public boolean isConcurrentBuild() {
            return false;
        }

        default public Collection<? extends SubTask> getSubTasks() {
            return Set.of(this);
        }

        @NonNull
        default public org.springframework.security.core.Authentication getDefaultAuthentication2() {
            if (Util.isOverridden(Task.class, this.getClass(), "getDefaultAuthentication", new Class[0])) {
                return this.getDefaultAuthentication().toSpring();
            }
            return ACL.SYSTEM2;
        }

        @Deprecated
        @NonNull
        default public Authentication getDefaultAuthentication() {
            return Authentication.fromSpring(this.getDefaultAuthentication2());
        }

        @NonNull
        default public org.springframework.security.core.Authentication getDefaultAuthentication2(Item item) {
            if (Util.isOverridden(Task.class, this.getClass(), "getDefaultAuthentication", Item.class)) {
                return this.getDefaultAuthentication(item).toSpring();
            }
            return this.getDefaultAuthentication2();
        }

        @Deprecated
        @NonNull
        default public Authentication getDefaultAuthentication(Item item) {
            return Authentication.fromSpring(this.getDefaultAuthentication2(item));
        }
    }

    public static final class WaitingItem
    extends Item
    implements Comparable<WaitingItem> {
        @Exported
        public Calendar timestamp;

        public WaitingItem(Calendar timestamp, Task project, List<Action> actions) {
            super(project, actions, QueueIdStrategy.get().generateIdFor(project, actions), new FutureImpl(project));
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(WaitingItem that) {
            int r = this.timestamp.getTime().compareTo(that.timestamp.getTime());
            if (r != 0) {
                return r;
            }
            return Long.compare(this.getId(), that.getId());
        }

        @Override
        public CauseOfBlockage getCauseOfBlockage() {
            long diff = this.timestamp.getTimeInMillis() - System.currentTimeMillis();
            if (diff >= 0L) {
                return CauseOfBlockage.fromMessage(Messages._Queue_InQuietPeriod(Util.getTimeSpanString(diff)));
            }
            return CauseOfBlockage.fromMessage(Messages._Queue_FinishedWaiting());
        }

        @Override
        void enter(Queue q) {
            if (q.waitingList.add(this)) {
                Listeners.notify(QueueListener.class, true, l -> l.onEnterWaiting(this));
            }
        }

        @Override
        boolean leave(Queue q) {
            boolean r = q.waitingList.remove(this);
            if (r) {
                Listeners.notify(QueueListener.class, true, l -> l.onLeaveWaiting(this));
            }
            return r;
        }
    }

    @ExportedBean(defaultVisibility=999)
    @BridgeMethodsAdded
    public static abstract class Item
    extends Actionable
    implements QueueItem {
        private final long id;
        @Exported
        @NonNull
        public final Task task;
        private transient FutureImpl future;
        private final long inQueueSince;

        @Override
        @Exported
        public long getId() {
            return this.id;
        }

        @Deprecated
        public int getIdLegacy() {
            if (this.id > Integer.MAX_VALUE) {
                throw new IllegalStateException("Sorry, you need to update any Plugins attempting to assign 'Queue.Item.id' to an int value. 'Queue.Item.id' is now a long value and has incremented to a value greater than Integer.MAX_VALUE (2^31 - 1).");
            }
            return (int)this.id;
        }

        @Override
        @NonNull
        public Task getTask() {
            return this.task;
        }

        @Exported
        public boolean isBlocked() {
            return this instanceof BlockedItem;
        }

        @Exported
        public boolean isBuildable() {
            return this instanceof BuildableItem;
        }

        @Override
        @Exported
        public boolean isStuck() {
            return false;
        }

        @Exported
        public long getInQueueSince() {
            return this.inQueueSince;
        }

        @Override
        public String getInQueueForString() {
            long duration = System.currentTimeMillis() - this.inQueueSince;
            return Util.getTimeSpanString(duration);
        }

        @WithBridgeMethods(value={Future.class})
        public QueueTaskFuture<Executable> getFuture() {
            return this.future;
        }

        @CheckForNull
        public Label getAssignedLabel() {
            for (LabelAssignmentAction laa : this.getActions(LabelAssignmentAction.class)) {
                Label l = laa.getAssignedLabel(this.task);
                if (l == null) continue;
                return l;
            }
            return this.task.getAssignedLabel();
        }

        @CheckForNull
        public Label getAssignedLabelFor(@NonNull SubTask st) {
            for (LabelAssignmentAction laa : this.getActions(LabelAssignmentAction.class)) {
                Label l = laa.getAssignedLabel(st);
                if (l == null) continue;
                return l;
            }
            return st.getAssignedLabel();
        }

        public final List<Cause> getCauses() {
            CauseAction ca = this.getAction(CauseAction.class);
            if (ca != null) {
                return Collections.unmodifiableList(ca.getCauses());
            }
            return Collections.emptyList();
        }

        @Override
        @Restricted(value={DoNotUse.class})
        public String getCausesDescription() {
            List<Cause> causes = this.getCauses();
            StringBuilder s = new StringBuilder();
            for (Cause c : causes) {
                s.append(c.getShortDescription()).append('\n');
            }
            return s.toString();
        }

        protected Item(@NonNull Task task, @NonNull List<Action> actions, long id, FutureImpl future) {
            this(task, actions, id, future, System.currentTimeMillis());
        }

        protected Item(@NonNull Task task, @NonNull List<Action> actions, long id, FutureImpl future, long inQueueSince) {
            this.task = task;
            this.id = id;
            this.future = future;
            this.inQueueSince = inQueueSince;
            for (Action action : actions) {
                this.addAction(action);
            }
        }

        protected Item(Item item) {
            this(item.task, new ArrayList<Action>(item.getActions()), item.id, item.future, item.inQueueSince);
        }

        @Exported
        public String getUrl() {
            return "queue/item/" + this.id + "/";
        }

        @Override
        @Exported
        public final String getWhy() {
            CauseOfBlockage cob = this.getCauseOfBlockage();
            return cob != null ? cob.getShortDescription() : null;
        }

        public abstract CauseOfBlockage getCauseOfBlockage();

        @Override
        @Exported
        public String getParams() {
            StringBuilder s = new StringBuilder();
            for (ParametersAction pa : this.getActions(ParametersAction.class)) {
                for (ParameterValue p : pa.getParameters()) {
                    s.append('\n').append(p.getShortDescription());
                }
            }
            return s.toString();
        }

        @Override
        public String getSearchUrl() {
            return null;
        }

        @Deprecated
        @RequirePOST
        public HttpResponse doCancelQueue() {
            if (this.hasCancelPermission()) {
                Jenkins.get().getQueue().cancel(this);
            }
            return HttpResponses.status((int)204);
        }

        @NonNull
        public org.springframework.security.core.Authentication authenticate2() {
            for (QueueItemAuthenticator auth : QueueItemAuthenticatorProvider.authenticators()) {
                org.springframework.security.core.Authentication a = auth.authenticate2(this);
                if (a == null) continue;
                return a;
            }
            return this.task.getDefaultAuthentication2(this);
        }

        @Deprecated
        public Authentication authenticate() {
            return Authentication.fromSpring(this.authenticate2());
        }

        @Restricted(value={DoNotUse.class})
        public Api getApi() throws AccessDeniedException {
            if (this.task instanceof AccessControlled) {
                AccessControlled ac = (AccessControlled)((Object)this.task);
                if (!ac.hasPermission(hudson.model.Item.DISCOVER)) {
                    return null;
                }
                if (!ac.hasPermission(hudson.model.Item.READ)) {
                    throw new AccessDeniedException("Please log in to access " + this.task.getUrl());
                }
                return new Api(this);
            }
            return null;
        }

        public HttpResponse doIndex(StaplerRequest2 req) {
            return HttpResponses.text((String)("Queue item exists. For details check, for example, " + req.getRequestURI() + "api/json?tree=cancelled,executable[url]"));
        }

        protected Object readResolve() {
            this.future = new FutureImpl(this.task);
            return this;
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.task + ":" + this.id;
        }

        abstract void enter(Queue var1);

        abstract boolean leave(Queue var1);

        boolean cancel(Queue q) {
            boolean r = this.leave(q);
            if (r) {
                this.future.setAsCancelled();
                LeftItem li = new LeftItem(this);
                li.enter(q);
            }
            return r;
        }
    }

    public final class BlockedItem
    extends NotWaitingItem {
        private transient CauseOfBlockage causeOfBlockage;

        public BlockedItem(WaitingItem wi) {
            this(wi, null);
        }

        public BlockedItem(NotWaitingItem ni) {
            this(ni, null);
        }

        BlockedItem(WaitingItem wi, CauseOfBlockage causeOfBlockage) {
            super(wi);
            this.causeOfBlockage = null;
            this.causeOfBlockage = causeOfBlockage;
        }

        BlockedItem(NotWaitingItem ni, CauseOfBlockage causeOfBlockage) {
            super(ni);
            this.causeOfBlockage = null;
            this.causeOfBlockage = causeOfBlockage;
        }

        void setCauseOfBlockage(CauseOfBlockage causeOfBlockage) {
            this.causeOfBlockage = causeOfBlockage;
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isCauseOfBlockageNull() {
            return this.causeOfBlockage == null;
        }

        @Override
        public CauseOfBlockage getCauseOfBlockage() {
            if (this.causeOfBlockage != null) {
                return this.causeOfBlockage;
            }
            return Queue.this.getCauseOfBlockageForItem(this);
        }

        @Override
        void enter(Queue q) {
            LOGGER.log(Level.FINE, "{0} is blocked", this);
            Queue.this.blockedProjects.add(this);
            Listeners.notify(QueueListener.class, true, l -> l.onEnterBlocked(this));
        }

        @Override
        boolean leave(Queue q) {
            boolean r = Queue.this.blockedProjects.remove(this);
            if (r) {
                LOGGER.log(Level.FINE, "{0} no longer blocked", this);
                Listeners.notify(QueueListener.class, true, l -> l.onLeaveBlocked(this));
            }
            return r;
        }
    }

    public static final class BuildableItem
    extends NotWaitingItem {
        private boolean isPending;
        @CheckForNull
        private volatile transient List<CauseOfBlockage> transientCausesOfBlockage;

        public BuildableItem(WaitingItem wi) {
            super(wi);
        }

        public BuildableItem(NotWaitingItem ni) {
            super(ni);
        }

        @Override
        public CauseOfBlockage getCauseOfBlockage() {
            Jenkins jenkins = Jenkins.get();
            if (Queue.isBlockedByShutdown(this.task)) {
                return CauseOfBlockage.fromMessage(Messages._Queue_HudsonIsAboutToShutDown());
            }
            List<CauseOfBlockage> causesOfBlockage = this.transientCausesOfBlockage;
            Label label = this.getAssignedLabel();
            List<Node> allNodes = jenkins.getNodes();
            if (allNodes.isEmpty()) {
                label = null;
            }
            if (label != null) {
                Set<Node> nodes = label.getNodes();
                if (label.isOffline()) {
                    if (nodes.size() != 1) {
                        return new CauseOfBlockage.BecauseLabelIsOffline(label);
                    }
                    return new CauseOfBlockage.BecauseNodeIsOffline(nodes.iterator().next());
                }
                if (causesOfBlockage != null && label.getIdleExecutors() > 0) {
                    return new CompositeCauseOfBlockage(causesOfBlockage);
                }
                if (nodes.size() != 1) {
                    return new CauseOfBlockage.BecauseLabelIsBusy(label);
                }
                return new CauseOfBlockage.BecauseNodeIsBusy(nodes.iterator().next());
            }
            if (causesOfBlockage != null && new ComputerSet().getIdleExecutors() > 0) {
                return new CompositeCauseOfBlockage(causesOfBlockage);
            }
            return CauseOfBlockage.createNeedsMoreExecutor(Messages._Queue_WaitingForNextAvailableExecutor());
        }

        @Override
        public boolean isStuck() {
            Label label = this.getAssignedLabel();
            if (label != null && label.isOffline()) {
                return true;
            }
            long d = this.task.getEstimatedDuration();
            long elapsed = System.currentTimeMillis() - this.buildableStartMilliseconds;
            if (d >= 0L) {
                return elapsed > Math.max(d, 60000L) * 10L;
            }
            return TimeUnit.MILLISECONDS.toHours(elapsed) > 24L;
        }

        @Exported
        public boolean isPending() {
            return this.isPending;
        }

        @Override
        void enter(Queue q) {
            q.buildables.add(this);
            Listeners.notify(QueueListener.class, true, l -> l.onEnterBuildable(this));
        }

        @Override
        boolean leave(Queue q) {
            boolean r = q.buildables.remove(this);
            if (r) {
                LOGGER.log(Level.FINE, "{0} no longer blocked", this);
                Listeners.notify(QueueListener.class, true, l -> l.onLeaveBuildable(this));
            }
            return r;
        }
    }

    public static interface TransientTask
    extends Task {
    }

    public static abstract class QueueDecisionHandler
    implements ExtensionPoint {
        public abstract boolean shouldSchedule(Task var1, List<Action> var2);

        public static ExtensionList<QueueDecisionHandler> all() {
            return ExtensionList.lookup(QueueDecisionHandler.class);
        }
    }

    public static interface QueueAction
    extends Action {
        public boolean shouldSchedule(List<Action> var1);
    }

    @Restricted(value={NoExternalUse.class})
    @ExportedBean(defaultVisibility=999)
    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
    public static class StubItem {
        @Exported
        public StubTask task;

        public StubItem(StubTask task) {
            this.task = task;
        }
    }

    @Restricted(value={NoExternalUse.class})
    @ExportedBean(defaultVisibility=999)
    public static class StubTask {
        private final String name;

        public StubTask(@NonNull Task base) {
            this.name = base.getName();
        }

        @Exported
        public String getName() {
            return this.name;
        }
    }

    public static final class LeftItem
    extends Item {
        public final WorkUnitContext outcome;

        public LeftItem(WorkUnitContext wuc) {
            super(wuc.item);
            this.outcome = wuc;
        }

        public LeftItem(Item cancelled) {
            super(cancelled);
            this.outcome = null;
        }

        @Override
        public CauseOfBlockage getCauseOfBlockage() {
            return null;
        }

        @Exported
        @CheckForNull
        public Executable getExecutable() {
            return this.outcome != null ? this.outcome.getPrimaryWorkUnit().getExecutable() : null;
        }

        @Exported
        public boolean isCancelled() {
            return this.outcome == null;
        }

        @Override
        void enter(Queue q) {
            q.leftItems.put((Object)this.getId(), (Object)this);
            Listeners.notify(QueueListener.class, true, l -> l.onLeft(this));
        }

        @Override
        boolean leave(Queue q) {
            return false;
        }
    }

    private static class LockedRunnable
    implements Runnable {
        private final Runnable delegate;

        private LockedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            Queue.withLock(this.delegate);
        }
    }

    private static class LockedHRCallable<V, T extends Throwable>
    implements hudson.remoting.Callable<V, T> {
        private static final long serialVersionUID = 1L;
        private final hudson.remoting.Callable<V, T> delegate;

        private LockedHRCallable(hudson.remoting.Callable<V, T> delegate) {
            this.delegate = delegate;
        }

        public V call() throws T {
            return Queue.withLock(this.delegate);
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
            this.delegate.checkRoles(checker);
        }
    }

    private static class LockedJUCCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;

        private LockedJUCCallable(Callable<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public V call() throws Exception {
            return Queue.withLock(this.delegate);
        }
    }

    public static class JobOffer
    extends MappingWorksheet.ExecutorSlot {
        public final Executor executor;
        private WorkUnit workUnit;

        private JobOffer(Executor executor) {
            this.executor = executor;
        }

        @Override
        protected void set(WorkUnit p) {
            assert (this.workUnit == null);
            this.workUnit = p;
            assert (this.executor.isParking());
            this.executor.start(this.workUnit);
        }

        @Override
        public Executor getExecutor() {
            return this.executor;
        }

        @Deprecated
        public boolean canTake(BuildableItem item) {
            return this.getCauseOfBlockage(item) == null;
        }

        @CheckForNull
        public CauseOfBlockage getCauseOfBlockage(BuildableItem item) {
            Node node = this.getNode();
            if (node == null) {
                return CauseOfBlockage.fromMessage(Messages._Queue_node_has_been_removed_from_configuration(this.executor.getOwner().getDisplayName()));
            }
            CauseOfBlockage reason = node.canTake(item);
            if (reason != null) {
                return reason;
            }
            for (QueueTaskDispatcher d : QueueTaskDispatcher.all()) {
                try {
                    reason = d.canTake(node, item);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, t, () -> String.format("Exception evaluating if the node '%s' can take the task '%s'", node.getNodeName(), item.task.getName()));
                    reason = CauseOfBlockage.fromMessage(Messages._Queue_ExceptionCanTake());
                }
                if (reason == null) continue;
                return reason;
            }
            if (this.workUnit != null) {
                return CauseOfBlockage.fromMessage(Messages._Queue_executor_slot_already_in_use());
            }
            if (this.executor.getOwner().isOffline()) {
                return new CauseOfBlockage.BecauseNodeIsOffline(node);
            }
            if (!this.executor.getOwner().isAcceptingTasks()) {
                return new CauseOfBlockage.BecauseNodeIsNotAcceptingTasks(node);
            }
            return null;
        }

        @Override
        public boolean isAvailable() {
            return this.workUnit == null && !this.executor.getOwner().isOffline() && this.executor.getOwner().isAcceptingTasks();
        }

        @CheckForNull
        public Node getNode() {
            return this.executor.getOwner().getNode();
        }

        public boolean isNotExclusive() {
            return this.getNode().getMode() == Node.Mode.NORMAL;
        }

        public String toString() {
            return String.format("JobOffer[%s #%d]", this.executor.getOwner().getName(), this.executor.getNumber());
        }
    }

    public static abstract class NotWaitingItem
    extends Item {
        @Exported
        public final long buildableStartMilliseconds;

        protected NotWaitingItem(WaitingItem wi) {
            super(wi);
            this.buildableStartMilliseconds = System.currentTimeMillis();
        }

        protected NotWaitingItem(NotWaitingItem ni) {
            super(ni);
            this.buildableStartMilliseconds = ni.buildableStartMilliseconds;
        }
    }

    public static interface FlyweightTask
    extends Task {
    }

    private class BuildableRunnable
    implements Runnable {
        private final BuildableItem buildableItem;

        private BuildableRunnable(BuildableItem p) {
            this.buildableItem = p;
        }

        @Override
        public void run() {
            this.buildableItem.enter(Queue.this);
        }
    }

    public static interface NonBlockingTask
    extends Task {
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final class Saver
    extends QueueListener
    implements Runnable {
        @VisibleForTesting
        static int DELAY_SECONDS = SystemProperties.getInteger("hudson.model.Queue.Saver.DELAY_SECONDS", 60);
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private Future<?> nextSave;

        @Override
        public void onEnterWaiting(WaitingItem wi) {
            this.push();
        }

        @Override
        public void onLeft(LeftItem li) {
            this.push();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void push() {
            if (DELAY_SECONDS < 0) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.nextSave != null && !this.nextSave.isDone() && !this.nextSave.isCancelled()) {
                    return;
                }
                this.nextSave = Timer.get().schedule(this, (long)DELAY_SECONDS, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Jenkins j = Jenkins.getInstanceOrNull();
                if (j != null) {
                    j.getQueue().save();
                }
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.nextSave = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Restricted(value={NoExternalUse.class})
        @VisibleForTesting
        @NonNull
        Future<?> getNextSave() {
            Object object = this.lock;
            synchronized (object) {
                return this.nextSave == null ? Futures.precomputed(null) : this.nextSave;
            }
        }
    }

    @StaplerAccessibleType
    public static interface Executable
    extends Runnable,
    WithConsoleUrl {
        @NonNull
        public SubTask getParent();

        @CheckForNull
        default public Executable getParentExecutable() {
            return null;
        }

        @Override
        public void run() throws AsynchronousExecution;

        default public long getEstimatedDuration() {
            return Executables.getParentOf(this).getEstimatedDuration();
        }

        @Override
        default public String getConsoleUrl() {
            Executable parent = this.getParentExecutable();
            return parent != null ? parent.getConsoleUrl() : null;
        }

        public String toString();
    }
}

