/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.StreamException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.Indenter;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.BuildTimelineWidget;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.RSS;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.TransientViewActionFactory;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.model.ViewProperty;
import hudson.model.ViewPropertyDescriptor;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.DescribableList;
import hudson.util.DescriptorList;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.RunList;
import hudson.util.XStream2;
import hudson.views.ListViewColumn;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.item_category.Categories;
import jenkins.model.item_category.Category;
import jenkins.model.item_category.ItemCategory;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.xml.XMLUtils;
import jenkins.widgets.HasWidgets;
import net.sf.json.JSONObject;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.symbol.Symbol;
import org.jenkins.ui.symbol.SymbolRequest;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import org.xml.sax.SAXException;

@ExportedBean
public abstract class View
extends AbstractModelObject
implements AccessControlled,
Describable<View>,
ExtensionPoint,
Saveable,
ModelObjectWithChildren,
DescriptorByNameOwner,
HasWidgets {
    protected ViewGroup owner;
    protected String name;
    protected String description;
    protected boolean filterExecutors;
    protected boolean filterQueue;
    private volatile DescribableList<ViewProperty, ViewPropertyDescriptor> properties = new PropertyList(this);
    private static final int FILTER_LOOP_MAX_COUNT = 10;
    @Deprecated
    public static final DescriptorList<View> LIST = new DescriptorList<View>(View.class);
    public static final Comparator<View> SORTER = Comparator.comparing(View::getViewName);
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(View.class, Messages._View_Permissions_Title());
    public static final Permission CREATE = new Permission(PERMISSIONS, "Create", Messages._View_CreatePermission_Description(), Permission.CREATE, PermissionScope.ITEM_GROUP);
    public static final Permission DELETE = new Permission(PERMISSIONS, "Delete", Messages._View_DeletePermission_Description(), Permission.DELETE, PermissionScope.ITEM_GROUP);
    public static final Permission CONFIGURE = new Permission(PERMISSIONS, "Configure", Messages._View_ConfigurePermission_Description(), Permission.CONFIGURE, PermissionScope.ITEM_GROUP);
    public static final Permission READ = new Permission(PERMISSIONS, "Read", Messages._View_ReadPermission_Description(), Permission.READ, PermissionScope.ITEM_GROUP);
    public static final AlternativeUiTextProvider.Message<View> NEW_PRONOUN = new AlternativeUiTextProvider.Message();
    private static final Logger LOGGER = Logger.getLogger(View.class.getName());

    protected View(String name) {
        this.name = name;
    }

    protected View(String name, ViewGroup owner) {
        this.name = name;
        this.owner = owner;
    }

    @Exported(name="jobs")
    @NonNull
    public abstract Collection<TopLevelItem> getItems();

    public Collection<TopLevelItem> getAllItems() {
        if (this instanceof ViewGroup) {
            LinkedHashSet<TopLevelItem> items = new LinkedHashSet<TopLevelItem>(this.getItems());
            for (View view : ((ViewGroup)((Object)this)).getViews()) {
                items.addAll(view.getAllItems());
            }
            return Collections.unmodifiableCollection(items);
        }
        return this.getItems();
    }

    public TopLevelItem getItem(String name) {
        return this.getOwner().getItemGroup().getItem(name);
    }

    public final TopLevelItem getJob(String name) {
        return this.getItem(name);
    }

    public abstract boolean contains(TopLevelItem var1);

    @Exported(visibility=2, name="name")
    @NonNull
    public String getViewName() {
        return this.name;
    }

    public void rename(String newName) throws Failure, Descriptor.FormException {
        if (this.name.equals(newName)) {
            return;
        }
        Jenkins.checkGoodName(newName);
        if (this.owner.getView(newName) != null) {
            throw new Descriptor.FormException(Messages.Hudson_ViewAlreadyExists(newName), "name");
        }
        String oldName = this.name;
        this.name = newName;
        this.owner.onViewRenamed(this, oldName, newName);
    }

    public ViewGroup getOwner() {
        return this.owner;
    }

    @Deprecated
    public ItemGroup<? extends TopLevelItem> getOwnerItemGroup() {
        return this.owner.getItemGroup();
    }

    @Deprecated
    public View getOwnerPrimaryView() {
        return this.owner.getPrimaryView();
    }

    @Deprecated
    public List<Action> getOwnerViewActions() {
        return this.owner.getViewActions();
    }

    @Exported
    public synchronized String getDescription() {
        return this.description;
    }

    @DataBoundSetter
    public synchronized void setDescription(String description) {
        this.description = Util.nullify(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescribableList<ViewProperty, ViewPropertyDescriptor> getProperties() {
        Class<PropertyList> clazz = PropertyList.class;
        synchronized (PropertyList.class) {
            if (this.properties == null) {
                this.properties = new PropertyList(this);
            } else {
                this.properties.setOwner(this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.properties;
        }
    }

    public List<ViewPropertyDescriptor> getApplicablePropertyDescriptors() {
        ArrayList<ViewPropertyDescriptor> r = new ArrayList<ViewPropertyDescriptor>();
        for (ViewPropertyDescriptor pd : ViewProperty.all()) {
            if (!pd.isEnabledFor(this)) continue;
            r.add(pd);
        }
        return r;
    }

    public List<ViewPropertyDescriptor> getVisiblePropertyDescriptors() {
        return DescriptorVisibilityFilter.apply(this, this.getApplicablePropertyDescriptors());
    }

    @Override
    public void save() throws IOException {
        if (this.owner != null) {
            this.owner.save();
        }
    }

    @Exported(name="property", inline=true)
    public List<ViewProperty> getAllProperties() {
        return this.getProperties().toList();
    }

    public ViewDescriptor getDescriptor() {
        return (ViewDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    @Override
    public String getDisplayName() {
        return this.getViewName();
    }

    public String getNewPronoun() {
        return AlternativeUiTextProvider.get(NEW_PRONOUN, this, Messages.AbstractItem_Pronoun());
    }

    public boolean isEditable() {
        return true;
    }

    @Deprecated
    public boolean isAutomaticRefreshEnabled() {
        return false;
    }

    public boolean isFilterExecutors() {
        return this.filterExecutors;
    }

    @DataBoundSetter
    public void setFilterExecutors(boolean filterExecutors) {
        this.filterExecutors = filterExecutors;
    }

    public boolean isFilterQueue() {
        return this.filterQueue;
    }

    @DataBoundSetter
    public void setFilterQueue(boolean filterQueue) {
        this.filterQueue = filterQueue;
    }

    public Iterable<? extends ListViewColumn> getColumns() {
        return ListViewColumn.createDefaultInitialColumnList(this);
    }

    public Indenter getIndenter() {
        return null;
    }

    public boolean isDefault() {
        return this.getOwner().getPrimaryView() == this;
    }

    public List<Computer> getComputers() {
        Computer[] computers = Jenkins.get().getComputers();
        if (!this.isFilterExecutors()) {
            return Arrays.asList(computers);
        }
        ArrayList<Computer> result = new ArrayList<Computer>();
        HashSet<Label> labels = new HashSet<Label>();
        for (Item item : this.getItems()) {
            if (!(item instanceof AbstractProject)) continue;
            labels.addAll(((AbstractProject)item).getRelevantLabels());
        }
        for (Computer c : computers) {
            if (!this.isRelevant(labels, c)) continue;
            result.add(c);
        }
        return result;
    }

    private boolean isRelevant(Collection<Label> labels, Computer computer) {
        Node node = computer.getNode();
        if (node == null) {
            return false;
        }
        if (labels.contains(null) && node.getMode() == Node.Mode.NORMAL) {
            return true;
        }
        for (Label l : labels) {
            if (l == null || !l.contains(node)) continue;
            return true;
        }
        return false;
    }

    private List<Queue.Item> filterQueue(List<Queue.Item> base) {
        if (!this.isFilterQueue()) {
            return base;
        }
        Collection<TopLevelItem> items = this.getItems();
        return base.stream().filter(qi -> this.filterQueueItemTest((Queue.Item)qi, items)).collect(Collectors.toList());
    }

    private boolean filterQueueItemTest(Queue.Item item, Collection<TopLevelItem> viewItems) {
        Queue.Task currentTask = item.task;
        int count = 1;
        while (true) {
            if (viewItems.contains(currentTask)) {
                return true;
            }
            Queue.Task next = currentTask.getOwnerTask();
            if (next == currentTask) break;
            currentTask = next;
            if (count == 10) {
                LOGGER.warning(String.format("Failed to find root task for queue item '%s' for view '%s' in under %d iterations, aborting!", item.getDisplayName(), this.getDisplayName(), 10));
                break;
            }
            ++count;
        }
        Queue.Task task = item.task;
        if (task instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)task;
            return viewItems.contains(project.getRootProject());
        }
        return false;
    }

    public List<Queue.Item> getQueueItems() {
        return this.filterQueue(Arrays.asList(Jenkins.get().getQueue().getItems()));
    }

    @Deprecated
    public List<Queue.Item> getApproximateQueueItemsQuickly() {
        return this.filterQueue(Jenkins.get().getQueue().getApproximateItemsQuickly());
    }

    public String getUrl() {
        return this.isDefault() ? (this.owner != null ? this.owner.getUrl() : "") : this.getViewUrl();
    }

    public String getViewUrl() {
        return (this.owner != null ? this.owner.getUrl() : "") + "view/" + Util.rawEncode(this.getViewName()) + "/";
    }

    public String toString() {
        return super.toString() + "[" + this.getViewUrl() + "]";
    }

    @Override
    public String getSearchUrl() {
        return this.getUrl();
    }

    public List<Action> getActions() {
        ArrayList<Action> result = new ArrayList<Action>();
        result.addAll(this.getOwner().getViewActions());
        result.addAll(TransientViewActionFactory.createAllFor(this));
        return result;
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    public void updateTransientActions() {
    }

    public Object getDynamic(String token) {
        for (Action a : this.getActions()) {
            String url = a.getUrlName();
            if (url == null || !url.equals(token)) continue;
            return a;
        }
        return null;
    }

    @Exported(visibility=2, name="url")
    public String getAbsoluteUrl() {
        return Jenkins.get().getRootUrl() + this.getUrl();
    }

    public Api getApi() {
        return new Api(this);
    }

    public String getPostConstructLandingPage() {
        return "configure";
    }

    @Override
    @NonNull
    public ACL getACL() {
        return Jenkins.get().getAuthorizationStrategy().getACL(this);
    }

    @Deprecated
    public void onJobRenamed(Item item, String oldName, String newName) {
    }

    void addDisplayNamesToSearchIndex(SearchIndexBuilder sib, Collection<TopLevelItem> items) {
        for (TopLevelItem item : items) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Adding url=%s,displayName=%s", item.getSearchUrl(), item.getDisplayName()));
            }
            sib.add(item.getSearchUrl(), item.getDisplayName());
        }
    }

    protected void makeSearchIndex(SearchIndexBuilder sib) {
        sib.add(new CollectionSearchIndex<TopLevelItem>(){

            @Override
            protected TopLevelItem get(String key) {
                return View.this.getItem(key);
            }

            @Override
            protected Collection<TopLevelItem> all() {
                return View.this.getItems();
            }

            @Override
            protected String getName(TopLevelItem o) {
                return o.getName();
            }
        });
    }

    @Override
    public SearchIndexBuilder makeSearchIndex() {
        SearchIndexBuilder sib = super.makeSearchIndex();
        this.makeSearchIndex(sib);
        this.addDisplayNamesToSearchIndex(sib, this.getItems());
        return sib;
    }

    @RequirePOST
    public synchronized void doSubmitDescription(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        if (Util.isOverridden(View.class, this.getClass(), "doSubmitDescription", StaplerRequest.class, StaplerResponse.class)) {
            try {
                this.doSubmitDescription(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (javax.servlet.ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((javax.servlet.ServletException)e);
            }
        } else {
            this.doSubmitDescriptionImpl(req, rsp);
        }
    }

    @Deprecated
    @StaplerNotDispatchable
    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, javax.servlet.ServletException {
        this.doSubmitDescriptionImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
    }

    private void doSubmitDescriptionImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        this.checkPermission(CONFIGURE);
        this.description = req.getParameter("description");
        this.save();
        rsp.sendRedirect(".");
    }

    @POST
    public final synchronized void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(CONFIGURE);
        this.submit(req);
        JSONObject json = req.getSubmittedForm();
        this.setDescription(json.optString("description"));
        this.setFilterExecutors(json.optBoolean("filterExecutors"));
        this.setFilterQueue(json.optBoolean("filterQueue"));
        this.rename(req.getParameter("name"));
        this.getProperties().rebuild(req, json, this.getApplicablePropertyDescriptors());
        this.save();
        FormApply.success("../" + Util.rawEncode(this.name)).generateResponse(req, rsp, (Object)this);
    }

    protected void submit(StaplerRequest2 req) throws IOException, ServletException, Descriptor.FormException {
        if (Util.isOverridden(View.class, this.getClass(), "submit", StaplerRequest.class)) {
            try {
                this.submit(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req));
            }
            catch (javax.servlet.ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((javax.servlet.ServletException)e);
            }
        } else {
            throw new AbstractMethodError("The class " + this.getClass().getName() + " must override at least one of the " + View.class.getSimpleName() + ".submit methods");
        }
    }

    @Deprecated
    protected void submit(StaplerRequest req) throws IOException, javax.servlet.ServletException, Descriptor.FormException {
        if (Util.isOverridden(View.class, this.getClass(), "submit", StaplerRequest2.class)) {
            try {
                this.submit(StaplerRequest.toStaplerRequest2((StaplerRequest)req));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
            }
        } else {
            throw new AbstractMethodError("The class " + this.getClass().getName() + " must override at least one of the " + View.class.getSimpleName() + ".submit methods");
        }
    }

    @RequirePOST
    public synchronized void doDoDelete(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.checkPermission(DELETE);
        this.owner.deleteView(this);
        rsp.sendRedirect2(req.getContextPath() + "/" + this.owner.getUrl());
    }

    @RequirePOST
    public Item doCreateItem(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        if (Util.isOverridden(View.class, this.getClass(), "doCreateItem", StaplerRequest.class, StaplerResponse.class)) {
            try {
                return this.doCreateItem(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (javax.servlet.ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((javax.servlet.ServletException)e);
            }
        }
        throw new AbstractMethodError("The class " + this.getClass().getName() + " must override at least one of the " + View.class.getSimpleName() + ".doCreateItem methods");
    }

    @Deprecated
    @StaplerNotDispatchable
    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, javax.servlet.ServletException {
        if (Util.isOverridden(View.class, this.getClass(), "doCreateItem", StaplerRequest2.class, StaplerResponse2.class)) {
            try {
                return this.doCreateItem(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
            }
        }
        throw new AbstractMethodError("The class " + this.getClass().getName() + " must override at least one of the " + View.class.getSimpleName() + ".doCreateItem methods");
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckJobName(@QueryParameter String value) {
        this.getOwner().checkPermission(Item.CREATE);
        if (Util.fixEmpty(value) == null) {
            return FormValidation.ok();
        }
        try {
            Jenkins.checkGoodName(value);
            value = value.trim();
            ItemGroup<? extends TopLevelItem> parent = this.getOwner().getItemGroup();
            Jenkins.get().getProjectNamingStrategy().checkName(parent.getFullName(), value);
        }
        catch (Failure e) {
            return FormValidation.error(e.getMessage());
        }
        if (this.getOwner().getItemGroup().getItem(value) != null) {
            return FormValidation.error(Messages.Hudson_JobAlreadyExists(value));
        }
        return FormValidation.ok();
    }

    @Restricted(value={DoNotUse.class})
    public Categories doItemCategories(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String iconStyle) throws IOException, ServletException {
        this.getOwner().checkPermission(Item.CREATE);
        rsp.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        rsp.addHeader("Pragma", "no-cache");
        rsp.addHeader("Expires", "0");
        Categories categories = new Categories();
        int order = 0;
        String resUrl = iconStyle != null && !iconStyle.isBlank() ? req.getContextPath() + Jenkins.RESOURCE_PATH : null;
        for (TopLevelItemDescriptor descriptor : DescriptorVisibilityFilter.apply(this.getOwner().getItemGroup(), Items.all2(Jenkins.getAuthentication2(), this.getOwner().getItemGroup()))) {
            Category category;
            ItemCategory ic = ItemCategory.getCategory(descriptor);
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("class", descriptor.getId());
            metadata.put("order", ++order);
            metadata.put("displayName", descriptor.getDisplayName());
            metadata.put("description", descriptor.getDescription());
            metadata.put("iconFilePathPattern", descriptor.getIconFilePathPattern());
            String iconClassName = descriptor.getIconClassName();
            if (iconClassName != null && !iconClassName.isBlank()) {
                Icon icon;
                metadata.put("iconClassName", iconClassName);
                if (iconClassName.startsWith("symbol-")) {
                    String iconXml = Symbol.get(new SymbolRequest.Builder().withName(iconClassName.split(" ")[0].substring(7)).withPluginName(Functions.extractPluginNameFromIconSrc(iconClassName)).withClasses("icon-xlg").build());
                    metadata.put("iconXml", iconXml);
                } else if (resUrl != null && (icon = IconSet.icons.getIconByClassSpec((Object)String.join((CharSequence)" ", iconClassName, iconStyle))) != null) {
                    metadata.put("iconQualifiedUrl", icon.getQualifiedUrl(resUrl));
                }
            }
            if ((category = categories.getItem(ic.getId())) != null) {
                category.getItems().add(metadata);
                continue;
            }
            ArrayList<Map<String, Serializable>> temp = new ArrayList<Map<String, Serializable>>();
            temp.add(metadata);
            category = new Category(ic.getId(), ic.getDisplayName(), ic.getDescription(), ic.getOrder(), ic.getMinToShow(), temp);
            categories.getItems().add(category);
        }
        return categories;
    }

    public void doRssAll(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (all builds)", this.getUrl(), this.getBuilds().newBuilds());
    }

    public void doRssFailed(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (failed builds)", this.getUrl(), this.getBuilds().failureOnly().newBuilds());
    }

    public RunList getBuilds() {
        return new RunList(this);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public BuildTimelineWidget getTimeline() {
        return new BuildTimelineWidget(this.getBuilds());
    }

    public void doRssLatest(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        ArrayList lastBuilds = new ArrayList();
        for (TopLevelItem item : this.getItems()) {
            Job job;
            Object lb;
            if (!(item instanceof Job) || (lb = (job = (Job)((Object)item)).getLastBuild()) == null) continue;
            lastBuilds.add(lb);
        }
        RSS.rss(req, rsp, "Jenkins:" + this.getDisplayName() + " (latest builds)", this.getUrl(), RunList.fromRuns(lastBuilds), Run.FEED_ADAPTER_LATEST);
    }

    @WebMethod(name={"config.xml"})
    public HttpResponse doConfigDotXml(StaplerRequest2 req) throws IOException {
        if (Util.isOverridden(View.class, this.getClass(), "doConfigDotXml", StaplerRequest.class)) {
            return this.doConfigDotXml(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req));
        }
        return this.doConfigDotXmlImpl(req);
    }

    @Deprecated
    @StaplerNotDispatchable
    public HttpResponse doConfigDotXml(StaplerRequest req) throws IOException {
        return this.doConfigDotXmlImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req));
    }

    private HttpResponse doConfigDotXmlImpl(StaplerRequest2 req) throws IOException {
        if (req.getMethod().equals("GET")) {
            this.checkPermission(READ);
            return new HttpResponse(){

                public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
                    rsp.setContentType("application/xml");
                    View.this.writeXml((OutputStream)rsp.getOutputStream());
                }
            };
        }
        if (req.getMethod().equals("POST")) {
            this.updateByXml(new StreamSource(req.getReader()));
            return HttpResponses.ok();
        }
        return HttpResponses.error((int)400, (String)("Unexpected request method " + req.getMethod()));
    }

    public void writeXml(OutputStream out) throws IOException {
        XStream2 xStream2 = new XStream2();
        xStream2.omitField(View.class, "owner");
        xStream2.toXMLUTF8(this, out);
    }

    public void updateByXml(Source source) throws IOException {
        this.checkPermission(CONFIGURE);
        StringWriter out = new StringWriter();
        try {
            XMLUtils.safeTransform(source, new StreamResult(out));
            out.close();
        }
        catch (TransformerException | SAXException e) {
            throw new IOException("Failed to persist configuration.xml", e);
        }
        try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(out.toString().getBytes(StandardCharsets.UTF_8)));){
            String oldname = this.name;
            ViewGroup oldOwner = this.owner;
            Object o = Jenkins.XSTREAM2.unmarshal(XStream2.getDefaultDriver().createReader((InputStream)in), this, null, true);
            if (!o.getClass().equals(this.getClass())) {
                throw new IOException("Expecting view type: " + this.getClass() + " but got: " + o.getClass() + " instead.\nShould you needed to change to a new view type, you must first delete and then re-create the view with the new view type.");
            }
            this.name = oldname;
            this.owner = oldOwner;
        }
        catch (ConversionException | StreamException | Error e) {
            throw new IOException("Unable to read", e);
        }
        this.save();
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest2 request, StaplerResponse2 response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu m = new ModelObjectWithContextMenu.ContextMenu();
        for (TopLevelItem i : this.getItems()) {
            m.add(Functions.getRelativeLinkTo(i), Functions.getRelativeDisplayNameFrom(i, this.getOwner().getItemGroup()));
        }
        return m;
    }

    public static DescriptorExtensionList<View, ViewDescriptor> all() {
        return Jenkins.get().getDescriptorList(View.class);
    }

    @NonNull
    public static List<ViewDescriptor> allInstantiable() {
        ArrayList<ViewDescriptor> r = new ArrayList<ViewDescriptor>();
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        if (request == null) {
            throw new IllegalStateException("This method can only be invoked from a stapler request");
        }
        ViewGroup owner = (ViewGroup)request.findAncestorObject(ViewGroup.class);
        if (owner == null) {
            throw new IllegalStateException("This method can only be invoked from a request with a ViewGroup ancestor");
        }
        for (ViewDescriptor d : DescriptorVisibilityFilter.apply(owner, View.all())) {
            if (!d.isApplicableIn(owner) || !d.isInstantiable() || !owner.getACL().hasCreatePermission2(Jenkins.getAuthentication2(), owner, d)) continue;
            r.add(d);
        }
        return r;
    }

    @Initializer(before=InitMilestone.SYSTEM_CONFIG_LOADED)
    @Restricted(value={DoNotUse.class})
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="to guard against potential future compiler optimizations")
    public static void registerPermissions() {
        Objects.hash(PERMISSIONS, CREATE, DELETE, CONFIGURE, READ);
    }

    public static Permission getItemCreatePermission() {
        return Item.CREATE;
    }

    public static View create(StaplerRequest2 req, StaplerResponse2 rsp, ViewGroup owner) throws Descriptor.FormException, IOException, ServletException {
        View v;
        String mode = req.getParameter("mode");
        String requestContentType = req.getContentType();
        if (!(requestContentType != null || mode != null && mode.equals("copy"))) {
            throw new Failure("No Content-Type header set");
        }
        boolean isXmlSubmission = requestContentType != null && (requestContentType.startsWith("application/xml") || requestContentType.startsWith("text/xml"));
        String name = req.getParameter("name");
        Jenkins.checkGoodName(name);
        if (owner.getView(name) != null) {
            throw new Failure(Messages.Hudson_ViewAlreadyExists(name));
        }
        if (mode == null || mode.isEmpty()) {
            if (isXmlSubmission) {
                View v2 = View.createViewFromXML(name, (InputStream)req.getInputStream());
                owner.getACL().checkCreatePermission(owner, v2.getDescriptor());
                v2.owner = owner;
                rsp.setStatus(200);
                return v2;
            }
            throw new Failure(Messages.View_MissingMode());
        }
        if ("copy".equals(mode)) {
            v = View.copy(req, owner, name);
        } else {
            ViewDescriptor descriptor = View.all().findByName(mode);
            if (descriptor == null) {
                throw new Failure("No view type \u2018" + mode + "\u2019 is known");
            }
            JSONObject submittedForm = req.getSubmittedForm();
            submittedForm.put("name", (Object)name);
            v = (View)descriptor.newInstance(req, submittedForm);
        }
        owner.getACL().checkCreatePermission(owner, v.getDescriptor());
        v.owner = owner;
        rsp.sendRedirect2(req.getContextPath() + "/" + v.getUrl() + v.getPostConstructLandingPage());
        return v;
    }

    @Deprecated
    public static View create(StaplerRequest req, StaplerResponse rsp, ViewGroup owner) throws Descriptor.FormException, IOException, javax.servlet.ServletException {
        try {
            return View.create(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp), owner);
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
        }
    }

    private static View copy(StaplerRequest2 req, ViewGroup owner, String name) throws IOException {
        String from = req.getParameter("from");
        View src = owner.getView(from);
        if (src == null) {
            if (Util.fixEmpty(from) == null) {
                throw new Failure("Specify which view to copy");
            }
            throw new Failure("No such view: " + from);
        }
        String xml = Jenkins.XSTREAM.toXML((Object)src);
        View v = View.createViewFromXML(name, new ByteArrayInputStream(xml.getBytes(Charset.defaultCharset())));
        return v;
    }

    public static View createViewFromXML(String name, InputStream xml) throws IOException {
        View view;
        BufferedInputStream in = new BufferedInputStream(xml);
        try {
            View v = (View)Jenkins.XSTREAM.fromXML((InputStream)in);
            if (name != null) {
                v.name = name;
            }
            Jenkins.checkGoodName(v.name);
            view = v;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ConversionException | StreamException | Error e) {
                throw new IOException("Unable to read", e);
            }
        }
        ((InputStream)in).close();
        return view;
    }

    public static class PropertyList
    extends DescribableList<ViewProperty, ViewPropertyDescriptor> {
        private PropertyList(View owner) {
            super(owner);
        }

        public PropertyList() {
        }

        public View getOwner() {
            return (View)this.owner;
        }

        @Override
        protected void onModified() throws IOException {
            for (ViewProperty p : this) {
                p.setView(this.getOwner());
            }
        }
    }
}

