/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Computer;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.NodeMonitor;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.jvnet.hudson.MemoryMonitor;
import org.jvnet.hudson.MemoryUsage;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public class SwapSpaceMonitor
extends NodeMonitor {
    @Deprecated
    public static AbstractNodeMonitorDescriptor<MemoryUsage> DESCRIPTOR;

    @DataBoundConstructor
    public SwapSpaceMonitor() {
    }

    public String toHtml(MemoryUsage usage) {
        if (usage.availableSwapSpace == -1L) {
            return "N/A";
        }
        String humanReadableSpace = Functions.humanReadableByteSize(usage.availableSwapSpace);
        long free = usage.availableSwapSpace;
        free /= 1024L;
        if ((free /= 1024L) > 256L || usage.totalSwapSpace < usage.availableSwapSpace * 5L) {
            return humanReadableSpace;
        }
        return Util.wrapToErrorSpan(humanReadableSpace);
    }

    public long toMB(MemoryUsage usage) {
        if (usage.availableSwapSpace == -1L) {
            return -1L;
        }
        long free = usage.availableSwapSpace;
        free /= 1024L;
        return free /= 1024L;
    }

    @Override
    public String getColumnCaption() {
        return Jenkins.get().hasPermission(Jenkins.ADMINISTER) ? super.getColumnCaption() : null;
    }

    @ExportedBean
    public static class MemoryUsage2
    extends MemoryUsage {
        private static final long serialVersionUID = 2216994637932270352L;

        public MemoryUsage2(MemoryUsage mem) {
            super(mem.totalPhysicalMemory, mem.availablePhysicalMemory, mem.totalSwapSpace, mem.availableSwapSpace);
        }

        @Exported
        public long getTotalPhysicalMemory() {
            return this.totalPhysicalMemory;
        }

        @Exported
        public long getAvailablePhysicalMemory() {
            return this.availablePhysicalMemory;
        }

        @Exported
        public long getTotalSwapSpace() {
            return this.totalSwapSpace;
        }

        @Exported
        public long getAvailableSwapSpace() {
            return this.availableSwapSpace;
        }
    }

    private static class MonitorTask
    extends MasterToSlaveCallable<MemoryUsage, IOException> {
        private static final long serialVersionUID = 1L;
        private static boolean warned = false;

        private MonitorTask() {
        }

        public MemoryUsage call() throws IOException {
            MemoryMonitor mm;
            try {
                mm = MemoryMonitor.get();
            }
            catch (IOException e) {
                return this.report(e);
            }
            catch (LinkageError e) {
                return this.report(e);
            }
            return new MemoryUsage2(mm.monitor());
        }

        private <T extends Throwable> MemoryUsage report(T e) throws T {
            if (!warned) {
                warned = true;
                throw e;
            }
            return null;
        }
    }

    @Extension
    @Symbol(value={"swapSpace"})
    public static class DescriptorImpl
    extends AbstractAsyncNodeMonitorDescriptor<MemoryUsage> {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        public boolean canTakeOffline() {
            return false;
        }

        protected MonitorTask createCallable(Computer c) {
            return new MonitorTask();
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SwapSpaceMonitor_DisplayName();
        }
    }
}

