/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.ClassicPluginStrategy;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.LocalPluginManager;
import hudson.Main;
import hudson.Messages;
import hudson.Plugin;
import hudson.PluginManagerStaplerOverride;
import hudson.PluginStrategy;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.ProxyConfigurationManager;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.InitStrategy;
import hudson.init.InitializerFinder;
import hudson.lifecycle.Lifecycle;
import hudson.model.AbstractModelObject;
import hudson.model.AdministrativeMonitor;
import hudson.model.Api;
import hudson.model.Descriptor;
import hudson.model.DownloadService;
import hudson.model.Failure;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.util.CyclicGraphDetector;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.PersistedList;
import hudson.util.Retrier;
import hudson.util.Service;
import hudson.util.VersionNumber;
import io.jenkins.servlet.ServletContextWrapper;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.CodeSource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jenkins.ClassLoaderReflectionToolkit;
import jenkins.ExtensionRefreshException;
import jenkins.InitReactorRunner;
import jenkins.MissingDependencyException;
import jenkins.RestartRequiredException;
import jenkins.YesNoMaybe;
import jenkins.install.InstallState;
import jenkins.install.InstallUtil;
import jenkins.model.Jenkins;
import jenkins.plugins.DetachedPluginsUtil;
import jenkins.security.CustomClassFilter;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.SystemProperties;
import jenkins.util.io.OnMaster;
import jenkins.util.xml.RestrictiveEntityResolver;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletDiskFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.Symbol;
import org.jvnet.hudson.reactor.Executable;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.jvnet.hudson.reactor.TaskGraphBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ExportedBean
public abstract class PluginManager
extends AbstractModelObject
implements OnMaster,
StaplerOverridable,
StaplerProxy {
    public static final String CUSTOM_PLUGIN_MANAGER = PluginManager.class.getName() + ".className";
    private static final Logger LOGGER = Logger.getLogger(PluginManager.class.getName());
    static int CHECK_UPDATE_SLEEP_TIME_MILLIS;
    static int CHECK_UPDATE_ATTEMPTS;
    protected final List<PluginWrapper> plugins = new CopyOnWriteArrayList<PluginWrapper>();
    protected final List<PluginWrapper> activePlugins = new CopyOnWriteArrayList<PluginWrapper>();
    protected final List<FailedPlugin> failedPlugins = new ArrayList<FailedPlugin>();
    public final File rootDir;
    private String lastErrorCheckUpdateCenters = null;
    @CheckForNull
    private final File workDir;
    @Deprecated
    public final ServletContext context;
    public final ClassLoader uberClassLoader = new UberClassLoader(this.activePlugins);
    public volatile boolean pluginUploaded = false;
    private boolean pluginListed = false;
    private final PluginStrategy strategy;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean FAST_LOOKUP;
    @Deprecated
    public static final Permission UPLOAD_PLUGINS;
    @Deprecated
    public static final Permission CONFIGURE_UPDATECENTER;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK;

    @NonNull
    public static PluginManager createDefault(@NonNull Jenkins jenkins) {
        String pmClassName = SystemProperties.getString(CUSTOM_PLUGIN_MANAGER);
        if (pmClassName != null && !pmClassName.isBlank()) {
            LOGGER.log(Level.FINE, String.format("Use of custom plugin manager [%s] requested.", pmClassName));
            try {
                Class<PluginManager> klass = Class.forName(pmClassName).asSubclass(PluginManager.class);
                for (PMConstructor c : PMConstructor.values()) {
                    PluginManager pm = c.create(klass, jenkins);
                    if (pm == null) continue;
                    return pm;
                }
                LOGGER.log(Level.WARNING, String.format("Provided custom plugin manager [%s] does not provide any of the suitable constructors. Using default.", pmClassName));
            }
            catch (ClassCastException e) {
                LOGGER.log(Level.WARNING, String.format("Provided class [%s] does not extend PluginManager. Using default.", pmClassName));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Unable to instantiate custom plugin manager [%s]. Using default.", pmClassName), e);
            }
        }
        return new LocalPluginManager(jenkins);
    }

    protected PluginManager(ServletContext context, File rootDir) {
        this.context = context;
        this.rootDir = rootDir;
        try {
            Util.createDirectories(rootDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String workDir = SystemProperties.getString(PluginManager.class.getName() + ".workDir");
        this.workDir = workDir == null || workDir.isBlank() ? null : new File(workDir);
        this.strategy = this.createPluginStrategy();
    }

    @Deprecated
    protected PluginManager(javax.servlet.ServletContext context, File rootDir) {
        this(context != null ? ServletContextWrapper.toJakartaServletContext((javax.servlet.ServletContext)context) : null, rootDir);
    }

    public Api getApi() {
        Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
        return new Api(this);
    }

    @CheckForNull
    public File getWorkDir() {
        return this.workDir;
    }

    public Collection<PluginManagerStaplerOverride> getOverrides() {
        return PluginManagerStaplerOverride.all();
    }

    public TaskBuilder initTasks(final InitStrategy initStrategy) {
        Object builder = !this.pluginListed ? new TaskGraphBuilder(){
            List<File> archives;
            Collection<String> bundledPlugins;
            {
                TaskGraphBuilder.Handle loadBundledPlugins = this.add("Loading bundled plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        bundledPlugins = PluginManager.this.loadBundledPlugins();
                    }
                });
                TaskGraphBuilder.Handle listUpPlugins = this.requires(new Milestone[]{loadBundledPlugins}).add("Listing up plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        archives = initStrategy.listPluginArchives(PluginManager.this);
                    }
                });
                this.requires(new Milestone[]{listUpPlugins}).attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Preparing plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        TaskGraphBuilder g = new TaskGraphBuilder();
                        final HashMap inspectedShortNames = new HashMap();
                        for (final File arc : archives) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Inspecting plugin " + arc, new Executable(){

                                public void run(Reactor session1) throws Exception {
                                    try {
                                        PluginWrapper p = PluginManager.this.strategy.createPluginWrapper(arc);
                                        if (this.isDuplicate(p)) {
                                            return;
                                        }
                                        p.isBundled = PluginManager.this.containsHpiJpi(bundledPlugins, arc.getName());
                                        PluginManager.this.plugins.add(p);
                                    }
                                    catch (IOException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(arc.getName(), (Exception)e));
                                        throw e;
                                    }
                                }

                                private boolean isDuplicate(PluginWrapper p) {
                                    String shortName = p.getShortName();
                                    if (inspectedShortNames.containsKey(shortName)) {
                                        LOGGER.info("Ignoring " + arc + " because " + inspectedShortNames.get(shortName) + " is already loaded");
                                        return true;
                                    }
                                    inspectedShortNames.put(shortName, arc);
                                    return false;
                                }
                            });
                        }
                        g.followedBy().attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Checking cyclic dependencies", new Executable(){

                            public void run(Reactor reactor) throws Exception {
                                try {
                                    CyclicGraphDetector<PluginWrapper> cgd = new CyclicGraphDetector<PluginWrapper>(){

                                        @Override
                                        protected List<PluginWrapper> getEdges(PluginWrapper p) {
                                            ArrayList<PluginWrapper> next = new ArrayList<PluginWrapper>();
                                            this.addTo(p.getDependencies(), next);
                                            this.addTo(p.getOptionalDependencies(), next);
                                            return next;
                                        }

                                        private void addTo(List<PluginWrapper.Dependency> dependencies, List<PluginWrapper> r) {
                                            for (PluginWrapper.Dependency d : dependencies) {
                                                PluginWrapper p = PluginManager.this.getPlugin(d.shortName);
                                                if (p == null) continue;
                                                r.add(p);
                                            }
                                        }

                                        @Override
                                        protected void reactOnCycle(PluginWrapper q, List<PluginWrapper> cycle) {
                                            LOGGER.log(Level.SEVERE, "found cycle in plugin dependencies: (root=" + q + ", deactivating all involved) " + cycle.stream().map(Object::toString).collect(Collectors.joining(" -> ")));
                                            for (PluginWrapper pluginWrapper : cycle) {
                                                pluginWrapper.setHasCycleDependency(true);
                                                PluginManager.this.failedPlugins.add(new FailedPlugin(pluginWrapper, (Exception)new CyclicGraphDetector.CycleDetectedException(cycle)));
                                            }
                                        }
                                    };
                                    cgd.run(PluginManager.this.getPlugins());
                                    for (PluginWrapper p : cgd.getSorted()) {
                                        if (!p.isActive()) continue;
                                        PluginManager.this.activePlugins.add(p);
                                        ((UberClassLoader)PluginManager.this.uberClassLoader).clearCacheMisses();
                                    }
                                }
                                catch (CyclicGraphDetector.CycleDetectedException e) {
                                    PluginManager.this.stop();
                                    throw e;
                                }
                            }
                        });
                        session.addAll(g.discoverTasks(session));
                        PluginManager.this.pluginListed = true;
                    }
                });
            }
        } : TaskBuilder.EMPTY_BUILDER;
        final InitializerFinder initializerFinder = new InitializerFinder(this.uberClassLoader);
        return TaskBuilder.union((TaskBuilder[])new TaskBuilder[]{initializerFinder, builder, new TaskGraphBuilder(){
            {
                this.requires(new Milestone[]{InitMilestone.PLUGINS_LISTED}).attains(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).add("Loading plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        Jenkins.get().lookup.set(PluginInstanceStore.class, new PluginInstanceStore());
                        TaskGraphBuilder g = new TaskGraphBuilder();
                        for (final PluginWrapper p : PluginManager.this.activePlugins.toArray(new PluginWrapper[0])) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).add(String.format("Loading plugin %s v%s (%s)", p.getLongName(), p.getVersion(), p.getShortName()), new Executable(){

                                public void run(Reactor session) throws Exception {
                                    try {
                                        p.resolvePluginDependencies();
                                        PluginManager.this.strategy.load(p);
                                    }
                                    catch (MissingDependencyException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(p, (Exception)e));
                                        PluginManager.this.activePlugins.remove(p);
                                        PluginManager.this.plugins.remove(p);
                                        p.releaseClassLoader();
                                        LOGGER.log(Level.SEVERE, "Failed to install {0}: {1}", new Object[]{p.getShortName(), e.getMessage()});
                                    }
                                    catch (IOException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(p, (Exception)e));
                                        PluginManager.this.activePlugins.remove(p);
                                        PluginManager.this.plugins.remove(p);
                                        p.releaseClassLoader();
                                        throw e;
                                    }
                                }
                            });
                        }
                        for (final PluginWrapper p : PluginManager.this.activePlugins.toArray(new PluginWrapper[0])) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_STARTED}).add("Initializing plugin " + p.getShortName(), new Executable(){

                                public void run(Reactor session) throws Exception {
                                    if (!PluginManager.this.activePlugins.contains(p)) {
                                        return;
                                    }
                                    try {
                                        p.getPluginOrFail().postInitialize();
                                    }
                                    catch (Exception e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(p, e));
                                        PluginManager.this.activePlugins.remove(p);
                                        PluginManager.this.plugins.remove(p);
                                        p.releaseClassLoader();
                                        throw e;
                                    }
                                }
                            });
                        }
                        g.followedBy().attains(new Milestone[]{InitMilestone.PLUGINS_STARTED}).add("Discovering plugin initialization tasks", new Executable(){

                            public void run(Reactor reactor) throws Exception {
                                reactor.addAll((Iterable)initializerFinder.discoverTasks(reactor));
                            }
                        });
                        session.addAll(g.discoverTasks(session));
                    }
                });
                this.requires(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).attains(new Milestone[]{InitMilestone.COMPLETED}).add("Resolving Dependent Plugins Graph", new Executable(){

                    public void run(Reactor reactor) throws Exception {
                        PluginManager.this.resolveDependentPlugins();
                    }
                });
            }
        }});
    }

    void considerDetachedPlugin(String shortName, String source) {
        if (new File(this.rootDir, shortName + ".jpi").isFile() || new File(this.rootDir, shortName + ".hpi").isFile() || new File(this.rootDir, shortName + ".jpl").isFile() || new File(this.rootDir, shortName + ".hpl").isFile()) {
            LOGGER.fine(() -> "not considering loading a detached dependency " + shortName + " as it is already on disk");
            return;
        }
        LOGGER.fine(() -> "considering loading a detached dependency " + shortName);
        for (String loadedFile : this.loadPluginsFromWar(this.getDetachedLocation(), (dir, name) -> this.normalisePluginName(name).equals(shortName))) {
            String loaded = this.normalisePluginName(loadedFile);
            File arc = new File(this.rootDir, loaded + ".jpi");
            LOGGER.info(() -> "Loading a detached plugin " + arc + " as a dependency of " + source);
            try {
                this.plugins.add(this.strategy.createPluginWrapper(arc));
            }
            catch (IOException e) {
                this.failedPlugins.add(new FailedPlugin(arc.getName(), (Exception)e));
            }
        }
    }

    @NonNull
    protected String getDetachedLocation() {
        return "/WEB-INF/detached-plugins";
    }

    @NonNull
    protected Set<String> loadPluginsFromWar(@NonNull String fromPath) {
        return this.loadPluginsFromWar(fromPath, null);
    }

    @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Plugin loading happens only once on Jenkins startup")
    @NonNull
    protected Set<String> loadPluginsFromWar(@NonNull String fromPath, @CheckForNull FilenameFilter filter) {
        String fileName;
        HashSet<String> names = new HashSet<String>();
        ServletContext context = Jenkins.get().getServletContext();
        Set<String> plugins = Util.fixNull(context.getResourcePaths(fromPath));
        HashSet<URL> copiedPlugins = new HashSet<URL>();
        HashSet<URL> dependencies = new HashSet<URL>();
        for (String pluginPath : plugins) {
            fileName = pluginPath.substring(pluginPath.lastIndexOf(47) + 1);
            if (fileName.isEmpty()) continue;
            try {
                URL url = context.getResource(pluginPath);
                if (filter != null && url != null && !filter.accept(new File(url.getFile()).getParentFile(), fileName)) continue;
                names.add(fileName);
                this.copyBundledPlugin(Objects.requireNonNull(url), fileName);
                copiedPlugins.add(url);
                try {
                    PluginManager.addDependencies(url, fromPath, dependencies);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failed to resolve dependencies for the bundled plugin " + fileName, e);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to extract the bundled plugin " + fileName, e);
            }
        }
        for (URL dependency : dependencies) {
            if (copiedPlugins.contains(dependency)) continue;
            fileName = new File(dependency.getFile()).getName();
            try {
                names.add(fileName);
                this.copyBundledPlugin(dependency, fileName);
                copiedPlugins.add(dependency);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to extract the bundled dependency plugin " + fileName, e);
            }
        }
        return names;
    }

    @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Plugin loading happens only once on Jenkins startup")
    protected static void addDependencies(URL hpiResUrl, String fromPath, Set<URL> dependencySet) throws URISyntaxException, MalformedURLException {
        if (dependencySet.contains(hpiResUrl)) {
            return;
        }
        Manifest manifest = PluginManager.parsePluginManifest(hpiResUrl);
        if (manifest == null) {
            return;
        }
        String dependencySpec = manifest.getMainAttributes().getValue("Plugin-Dependencies");
        if (dependencySpec != null) {
            String[] dependencyTokens = dependencySpec.split(",");
            ServletContext context = Jenkins.get().getServletContext();
            for (String dependencyToken : dependencyTokens) {
                if (dependencyToken.endsWith(";resolution:=optional")) continue;
                String[] artifactIdVersionPair = dependencyToken.split(":");
                String artifactId = artifactIdVersionPair[0];
                VersionNumber dependencyVersion = new VersionNumber(artifactIdVersionPair[1]);
                PluginManager manager = Jenkins.get().getPluginManager();
                VersionNumber installedVersion = manager.getPluginVersion(manager.rootDir, artifactId);
                if (installedVersion != null && !installedVersion.isOlderThan(dependencyVersion)) continue;
                URL dependencyURL = context.getResource(fromPath + "/" + artifactId + ".hpi");
                if (dependencyURL == null) {
                    dependencyURL = context.getResource(fromPath + "/" + artifactId + ".jpi");
                }
                if (dependencyURL == null) continue;
                PluginManager.addDependencies(dependencyURL, fromPath, dependencySet);
                dependencySet.add(dependencyURL);
            }
        }
    }

    protected void loadDetachedPlugins() {
        VersionNumber lastExecVersion = new VersionNumber(InstallUtil.getLastExecVersion());
        if (lastExecVersion.isNewerThan(InstallUtil.NEW_INSTALL_VERSION) && lastExecVersion.isOlderThan(Jenkins.getVersion())) {
            LOGGER.log(Level.INFO, "Upgrading Jenkins. The last running version was {0}. This Jenkins is version {1}.", new Object[]{lastExecVersion, Jenkins.VERSION});
            final List<DetachedPluginsUtil.DetachedPlugin> detachedPlugins = DetachedPluginsUtil.getDetachedPlugins(lastExecVersion);
            Set<String> loadedDetached = this.loadPluginsFromWar(this.getDetachedLocation(), new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (DetachedPluginsUtil.isDetachedPlugin(name = PluginManager.this.normalisePluginName(name))) {
                        VersionNumber installedVersion = PluginManager.this.getPluginVersion(PluginManager.this.rootDir, name);
                        VersionNumber bundledVersion = PluginManager.this.getPluginVersion(dir, name);
                        if (installedVersion != null && bundledVersion != null) {
                            return installedVersion.isOlderThan(bundledVersion);
                        }
                    }
                    for (DetachedPluginsUtil.DetachedPlugin detachedPlugin : detachedPlugins) {
                        if (!detachedPlugin.getShortName().equals(name)) continue;
                        return true;
                    }
                    return false;
                }
            });
            LOGGER.log(Level.INFO, "Upgraded Jenkins from version {0} to version {1}. Loaded detached plugins (and dependencies): {2}", new Object[]{lastExecVersion, Jenkins.VERSION, loadedDetached});
        } else {
            final HashSet<DetachedPluginsUtil.DetachedPlugin> forceUpgrade = new HashSet<DetachedPluginsUtil.DetachedPlugin>();
            for (DetachedPluginsUtil.DetachedPlugin p : DetachedPluginsUtil.getDetachedPlugins()) {
                VersionNumber installedVersion = this.getPluginVersion(this.rootDir, p.getShortName());
                VersionNumber requiredVersion = p.getRequiredVersion();
                if (installedVersion == null || !installedVersion.isOlderThan(requiredVersion)) continue;
                LOGGER.log(Level.WARNING, "Detached plugin {0} found at version {1}, required minimum version is {2}", new Object[]{p.getShortName(), installedVersion, requiredVersion});
                forceUpgrade.add(p);
            }
            if (!forceUpgrade.isEmpty()) {
                Set<String> loadedDetached = this.loadPluginsFromWar(this.getDetachedLocation(), new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        name = PluginManager.this.normalisePluginName(name);
                        for (DetachedPluginsUtil.DetachedPlugin detachedPlugin : forceUpgrade) {
                            if (!detachedPlugin.getShortName().equals(name)) continue;
                            return true;
                        }
                        return false;
                    }
                });
                LOGGER.log(Level.INFO, "Upgraded detached plugins (and dependencies): {0}", new Object[]{loadedDetached});
            }
        }
    }

    private String normalisePluginName(@NonNull String name) {
        return name.replace(".jpi", "").replace(".hpi", "");
    }

    @CheckForNull
    private VersionNumber getPluginVersion(@NonNull File dir, @NonNull String pluginId) {
        VersionNumber version = this.getPluginVersion(new File(dir, pluginId + ".jpi"));
        if (version == null) {
            version = this.getPluginVersion(new File(dir, pluginId + ".hpi"));
        }
        return version;
    }

    @CheckForNull
    private VersionNumber getPluginVersion(@NonNull File pluginFile) {
        if (!pluginFile.exists()) {
            return null;
        }
        try {
            return this.getPluginVersion(pluginFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @CheckForNull
    private VersionNumber getPluginVersion(@NonNull URL pluginURL) {
        Manifest manifest = PluginManager.parsePluginManifest(pluginURL);
        if (manifest == null) {
            return null;
        }
        String versionSpec = manifest.getMainAttributes().getValue("Plugin-Version");
        return new VersionNumber(versionSpec);
    }

    private boolean containsHpiJpi(Collection<String> bundledPlugins, String name) {
        return bundledPlugins.contains(name.replaceAll("\\.hpi", ".jpi")) || bundledPlugins.contains(name.replaceAll("\\.jpi", ".hpi"));
    }

    @Deprecated
    @CheckForNull
    public Manifest getBundledPluginManifest(String shortName) {
        return null;
    }

    public void dynamicLoad(File arc) throws IOException, InterruptedException, RestartRequiredException {
        this.dynamicLoad(arc, false, null);
    }

    @Restricted(value={NoExternalUse.class})
    public void dynamicLoad(File arc, boolean removeExisting, @CheckForNull List<PluginWrapper> batch) throws IOException, InterruptedException, RestartRequiredException {
        try (ACLContext context = ACL.as2(ACL.SYSTEM2);){
            String sn;
            LOGGER.log(Level.FINE, "Attempting to dynamic load {0}", arc);
            PluginWrapper p = null;
            try {
                sn = this.strategy.getShortName(arc);
            }
            catch (AbstractMethodError x) {
                LOGGER.log(Level.WARNING, "JENKINS-12753 fix not active: {0}", x.getMessage());
                p = this.strategy.createPluginWrapper(arc);
                sn = p.getShortName();
            }
            PluginWrapper pw = this.getPlugin(sn);
            if (pw != null) {
                if (removeExisting) {
                    Iterator<PluginWrapper> i = this.plugins.iterator();
                    while (i.hasNext()) {
                        pw = i.next();
                        if (!sn.equals(pw.getShortName())) continue;
                        i.remove();
                        break;
                    }
                } else {
                    throw new RestartRequiredException(Messages._PluginManager_PluginIsAlreadyInstalled_RestartRequired(sn));
                }
            }
            if (!Lifecycle.get().supportsDynamicLoad()) {
                throw new RestartRequiredException(Messages._PluginManager_LifecycleDoesNotSupportDynamicLoad_RestartRequired());
            }
            if (p == null) {
                p = this.strategy.createPluginWrapper(arc);
            }
            if (p.supportsDynamicLoad() == YesNoMaybe.NO) {
                throw new RestartRequiredException(Messages._PluginManager_PluginDoesntSupportDynamicLoad_RestartRequired(sn));
            }
            this.plugins.add(p);
            if (p.isActive()) {
                this.activePlugins.add(p);
                ((UberClassLoader)this.uberClassLoader).clearCacheMisses();
            }
            CustomClassFilter.Contributed.load();
            try {
                p.resolvePluginDependencies();
                this.strategy.load(p);
                if (batch != null) {
                    batch.add(p);
                } else {
                    this.start(List.of(p));
                }
            }
            catch (Exception e) {
                this.failedPlugins.add(new FailedPlugin(p, e));
                this.activePlugins.remove(p);
                this.plugins.remove(p);
                p.releaseClassLoader();
                throw new IOException("Failed to install " + sn + " plugin", e);
            }
            LOGGER.log(Level.FINE, "Plugin {0}:{1} dynamically {2}", new Object[]{p.getShortName(), p.getVersion(), batch != null ? "loaded but not yet started" : "installed"});
        }
    }

    @Restricted(value={NoExternalUse.class})
    public void start(List<PluginWrapper> plugins) throws Exception {
        try (ACLContext context = ACL.as2(ACL.SYSTEM2);){
            Map<String, PluginWrapper> pluginsByName = plugins.stream().collect(Collectors.toMap(PluginWrapper::getShortName, p -> p));
            block7: for (PluginWrapper depender : this.plugins) {
                if (plugins.contains(depender)) continue;
                for (PluginWrapper.Dependency d : depender.getOptionalDependencies()) {
                    PluginWrapper dependee = pluginsByName.get(d.shortName);
                    if (dependee == null) continue;
                    this.getPluginStrategy().updateDependency(depender, dependee);
                    continue block7;
                }
            }
            this.resolveDependentPlugins();
            try {
                Jenkins.get().refreshExtensions();
            }
            catch (ExtensionRefreshException e) {
                throw new IOException("Failed to refresh extensions after installing some plugins", e);
            }
            for (PluginWrapper p2 : plugins) {
                p2.getPluginOrFail().postInitialize();
            }
            Reactor r = new Reactor(new TaskBuilder[]{InitMilestone.ordering()});
            final Set loaders = plugins.stream().map(p -> p.classLoader).collect(Collectors.toSet());
            r.addAll((Iterable)new InitializerFinder(this.uberClassLoader){

                @Override
                protected boolean filter(Method e) {
                    return !loaders.contains(e.getDeclaringClass().getClassLoader()) || super.filter(e);
                }
            }.discoverTasks(r));
            new InitReactorRunner().run(r);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized void resolveDependentPlugins() {
        for (PluginWrapper plugin : this.plugins) {
            HashSet<String> optionalDependents = new HashSet<String>();
            HashSet<String> dependents = new HashSet<String>();
            block1: for (PluginWrapper possibleDependent : this.plugins) {
                if (possibleDependent.getShortName().equals(plugin.getShortName()) || possibleDependent.isDeleted()) continue;
                List<PluginWrapper.Dependency> dependencies = possibleDependent.getDependencies();
                for (PluginWrapper.Dependency dependency : dependencies) {
                    if (!dependency.shortName.equals(plugin.getShortName())) continue;
                    dependents.add(possibleDependent.getShortName());
                    if (!dependency.optional) continue block1;
                    optionalDependents.add(possibleDependent.getShortName());
                    continue block1;
                }
            }
            plugin.setDependents(dependents);
            plugin.setOptionalDependents(optionalDependents);
        }
    }

    protected abstract Collection<String> loadBundledPlugins() throws Exception;

    protected void copyBundledPlugin(URL src, String fileName) throws IOException {
        LOGGER.log(Level.FINE, "Copying {0}", src);
        fileName = fileName.replace(".hpi", ".jpi");
        String legacyName = fileName.replace(".jpi", ".hpi");
        long lastModified = PluginManager.getModificationDate(src);
        File file = new File(this.rootDir, fileName);
        this.rename(new File(this.rootDir, legacyName), file);
        if (!file.exists() || file.lastModified() != lastModified) {
            FileUtils.copyURLToFile((URL)src, (File)file);
            Files.setLastModifiedTime(Util.fileToPath(file), FileTime.fromMillis(PluginManager.getModificationDate(src)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    static Manifest parsePluginManifest(URL bundledJpi) {
        try (URLClassLoader cl = new URLClassLoader("Temporary classloader for parsing " + bundledJpi.toString(), new URL[]{bundledJpi}, ClassLoader.getSystemClassLoader());){
            InputStream in;
            block10: {
                Manifest manifest;
                in = null;
                try {
                    URL res = cl.findResource("META-INF/MANIFEST.MF");
                    if (res == null) break block10;
                    in = PluginManager.getBundledJpiManifestStream(res);
                    manifest = new Manifest(in);
                }
                catch (Throwable throwable) {
                    Util.closeAndLogFailures(in, LOGGER, "META-INF/MANIFEST.MF", bundledJpi.toString());
                    throw throwable;
                }
                Util.closeAndLogFailures(in, LOGGER, "META-INF/MANIFEST.MF", bundledJpi.toString());
                return manifest;
            }
            Util.closeAndLogFailures(in, LOGGER, "META-INF/MANIFEST.MF", bundledJpi.toString());
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to parse manifest of " + bundledJpi, e);
        }
        return null;
    }

    @NonNull
    static InputStream getBundledJpiManifestStream(@NonNull URL url) throws IOException {
        InputStream in;
        block15: {
            URLConnection uc = url.openConnection();
            in = null;
            if (uc instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)uc;
                String entryName = jarURLConnection.getEntryName();
                try (JarFile jarFile = jarURLConnection.getJarFile();){
                    JarEntry entry;
                    JarEntry jarEntry = entry = entryName != null && jarFile != null ? jarFile.getJarEntry(entryName) : null;
                    if (entry != null) {
                        try (InputStream i = jarFile.getInputStream(entry);){
                            byte[] manifestBytes = i.readAllBytes();
                            in = new ByteArrayInputStream(manifestBytes);
                            break block15;
                        }
                    }
                    LOGGER.log(Level.WARNING, "Failed to locate the JAR file for {0}The default URLConnection stream access will be used, file descriptor may be leaked.", url);
                }
            }
        }
        if (in == null) {
            in = url.openStream();
        }
        return in;
    }

    @NonNull
    static long getModificationDate(@NonNull URL url) throws IOException {
        URLConnection uc = url.openConnection();
        if (uc instanceof JarURLConnection) {
            JarURLConnection connection = (JarURLConnection)uc;
            URL jarURL = connection.getJarFileURL();
            if (jarURL.getProtocol().equals("file")) {
                String file = jarURL.getFile();
                return new File(file).lastModified();
            }
            if (connection.getEntryName() != null) {
                LOGGER.log(Level.WARNING, "Accessing modification date of {0} file, which is an entry in JAR file. The access protocol is not file:, falling back to the default logic (risk of file descriptor leak).", url);
            }
        }
        return uc.getLastModified();
    }

    private void rename(File legacyFile, File newFile) throws IOException {
        if (!legacyFile.exists()) {
            return;
        }
        if (newFile.exists()) {
            Util.deleteFile(newFile);
        }
        if (!legacyFile.renameTo(newFile)) {
            LOGGER.warning("Failed to rename " + legacyFile + " to " + newFile);
        }
    }

    protected PluginStrategy createPluginStrategy() {
        String strategyName = SystemProperties.getString(PluginStrategy.class.getName());
        if (strategyName != null) {
            try {
                Class<?> klazz = this.getClass().getClassLoader().loadClass(strategyName);
                Object strategy = klazz.getConstructor(PluginManager.class).newInstance(this);
                if (strategy instanceof PluginStrategy) {
                    LOGGER.info("Plugin strategy: " + strategyName);
                    return (PluginStrategy)strategy;
                }
                LOGGER.warning("Plugin strategy (" + strategyName + ") is not an instance of hudson.PluginStrategy");
            }
            catch (ClassNotFoundException e) {
                LOGGER.warning("Plugin strategy class not found: " + strategyName);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not instantiate plugin strategy: " + strategyName + ". Falling back to ClassicPluginStrategy", e);
            }
            LOGGER.info("Falling back to ClassicPluginStrategy");
        }
        return new ClassicPluginStrategy(this);
    }

    public PluginStrategy getPluginStrategy() {
        return this.strategy;
    }

    public boolean isPluginUploaded() {
        return this.pluginUploaded;
    }

    @Exported
    public List<PluginWrapper> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    @Restricted(value={NoExternalUse.class})
    public List<PluginWrapper> getPluginsSortedByTitle() {
        return this.plugins.stream().sorted(Comparator.comparing(PluginWrapper::getDisplayName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toUnmodifiableList());
    }

    public List<FailedPlugin> getFailedPlugins() {
        return this.failedPlugins;
    }

    @CheckForNull
    public PluginWrapper getPlugin(String shortName) {
        for (PluginWrapper p : this.getPlugins()) {
            if (!p.getShortName().equals(shortName)) continue;
            return p;
        }
        return null;
    }

    @CheckForNull
    public PluginWrapper getPlugin(Class<? extends Plugin> pluginClazz) {
        for (PluginWrapper p : this.getPlugins()) {
            if (!pluginClazz.isInstance(p.getPlugin())) continue;
            return p;
        }
        return null;
    }

    public List<PluginWrapper> getPlugins(Class<? extends Plugin> pluginSuperclass) {
        ArrayList<PluginWrapper> result = new ArrayList<PluginWrapper>();
        for (PluginWrapper p : this.getPlugins()) {
            if (!pluginSuperclass.isInstance(p.getPlugin())) continue;
            result.add(p);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getDisplayName() {
        return Messages.PluginManager_DisplayName();
    }

    @Override
    public String getSearchUrl() {
        return "pluginManager";
    }

    @Deprecated
    public <T> Collection<Class<? extends T>> discover(Class<T> spi) {
        HashSet<Class<? extends T>> result = new HashSet<Class<? extends T>>();
        for (PluginWrapper p : this.activePlugins) {
            Service.load(spi, p.classLoader, result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginWrapper whichPlugin(Class c) {
        File file;
        PluginWrapper oneAndOnly = null;
        ClassLoader cl = c.getClassLoader();
        for (PluginWrapper p : this.activePlugins) {
            if (p.classLoader != cl) continue;
            if (oneAndOnly != null) {
                return null;
            }
            oneAndOnly = p;
        }
        if (oneAndOnly != null) return oneAndOnly;
        if (!Main.isUnitTest) return oneAndOnly;
        CodeSource cs = c.getProtectionDomain().getCodeSource();
        if (cs == null) return oneAndOnly;
        URL loc = cs.getLocation();
        if (loc == null) return oneAndOnly;
        if (!"file".equals(loc.getProtocol())) return oneAndOnly;
        try {
            file = Paths.get(loc.toURI()).toFile();
        }
        catch (URISyntaxException | InvalidPathException e) {
            LOGGER.log(Level.WARNING, "could not inspect " + loc, e);
            return null;
        }
        if (!file.isFile()) return oneAndOnly;
        try (JarFile jf = new JarFile(file);){
            Manifest mf = jf.getManifest();
            if (mf == null) return oneAndOnly;
            java.util.jar.Attributes attr = mf.getMainAttributes();
            if (attr.getValue("Plugin-Version") == null) return oneAndOnly;
            String shortName = attr.getValue("Short-Name");
            LOGGER.fine(() -> "found " + shortName + " for " + c);
            PluginWrapper pluginWrapper = this.getPlugin(shortName);
            return pluginWrapper;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "could not inspect " + loc, e);
        }
        return oneAndOnly;
    }

    public synchronized void stop() {
        for (PluginWrapper p : this.activePlugins) {
            p.stop();
        }
        ArrayList<PluginWrapper> pluginsCopy = new ArrayList<PluginWrapper>(this.plugins);
        for (PluginWrapper p : pluginsCopy) {
            this.activePlugins.remove(p);
            this.plugins.remove(p);
            p.releaseClassLoader();
        }
        LogFactory.release((ClassLoader)this.uberClassLoader);
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isNonMetaLabel(String label) {
        return !"adopt-this-plugin".equals(label) && !"deprecated".equals(label);
    }

    public UpdateCenterProxy getUpdates() {
        return new UpdateCenterProxy();
    }

    @Restricted(value={NoExternalUse.class})
    public org.kohsuke.stapler.HttpResponse doPluginsSearch(@QueryParameter String query, @QueryParameter Integer limit) {
        ArrayList plugins = new ArrayList();
        for (UpdateSite site : Jenkins.get().getUpdateCenter().getSiteList()) {
            List sitePlugins = site.getAvailables().stream().filter(plugin -> {
                if (query == null || query.isBlank()) {
                    return true;
                }
                return plugin.name != null && plugin.name.toLowerCase(Locale.ROOT).contains(query.toLowerCase(Locale.ROOT)) || plugin.title != null && plugin.title.toLowerCase(Locale.ROOT).contains(query.toLowerCase(Locale.ROOT)) || plugin.excerpt != null && plugin.excerpt.toLowerCase(Locale.ROOT).contains(query.toLowerCase(Locale.ROOT)) || plugin.hasCategory(query) || plugin.getCategoriesStream().map(UpdateCenter::getCategoryDisplayName).anyMatch(category -> category != null && category.toLowerCase(Locale.ROOT).contains(query.toLowerCase(Locale.ROOT))) || plugin.hasWarnings() && query.equalsIgnoreCase("warning:");
            }).limit(Math.max(limit - plugins.size(), 1)).sorted((o1, o2) -> {
                String o1DisplayName = o1.getDisplayName();
                if (o1.name.equalsIgnoreCase(query) || o1DisplayName.equalsIgnoreCase(query)) {
                    return -1;
                }
                String o2DisplayName = o2.getDisplayName();
                if (o2.name.equalsIgnoreCase(query) || o2DisplayName.equalsIgnoreCase(query)) {
                    return 1;
                }
                if (o1.name.equals(o2.name)) {
                    return 0;
                }
                int pop = Double.compare(o2.popularity, o1.popularity);
                if (pop != 0) {
                    return pop;
                }
                return o1DisplayName.compareTo(o2DisplayName);
            }).map(plugin -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)plugin.name);
                jsonObject.put("sourceId", (Object)plugin.sourceId);
                jsonObject.put("title", (Object)plugin.title);
                jsonObject.put("displayName", (Object)plugin.getDisplayName());
                if (plugin.wiki == null || !plugin.wiki.startsWith("https://") && !plugin.wiki.startsWith("http://")) {
                    jsonObject.put("wiki", (Object)"");
                } else {
                    jsonObject.put("wiki", (Object)plugin.wiki);
                }
                jsonObject.put("categories", plugin.getCategoriesStream().filter(PluginManager::isNonMetaLabel).map(UpdateCenter::getCategoryDisplayName).collect(Collectors.toList()));
                if (this.hasAdoptThisPluginLabel((UpdateSite.Plugin)plugin)) {
                    jsonObject.put("adoptMe", (Object)Messages.PluginManager_adoptThisPlugin());
                }
                if (plugin.isDeprecated()) {
                    jsonObject.put("deprecated", (Object)Messages.PluginManager_deprecationWarning(plugin.getDeprecation().url));
                }
                jsonObject.put("excerpt", (Object)plugin.excerpt);
                jsonObject.put("version", (Object)plugin.version);
                jsonObject.put("popularity", (Object)plugin.popularity);
                if (plugin.isForNewerHudson()) {
                    jsonObject.put("newerCoreRequired", (Object)Messages.PluginManager_coreWarning(Util.xmlEscape(plugin.requiredCore)));
                }
                if (plugin.hasWarnings()) {
                    JSONObject unresolvedSecurityWarnings = new JSONObject();
                    unresolvedSecurityWarnings.put("text", (Object)Messages.PluginManager_securityWarning());
                    Set<UpdateSite.Warning> pluginWarnings = plugin.getWarnings();
                    if (pluginWarnings == null) {
                        throw new IllegalStateException("warnings cannot be null here");
                    }
                    List warnings = pluginWarnings.stream().map(warning -> {
                        JSONObject jsonWarning = new JSONObject();
                        jsonWarning.put("url", (Object)warning.url);
                        jsonWarning.put("message", (Object)warning.message);
                        return jsonWarning;
                    }).collect(Collectors.toList());
                    unresolvedSecurityWarnings.put("warnings", warnings);
                    jsonObject.put("unresolvedSecurityWarnings", (Object)unresolvedSecurityWarnings);
                }
                if (plugin.releaseTimestamp != null) {
                    JSONObject releaseTimestamp = new JSONObject();
                    releaseTimestamp.put("iso8601", (Object)Functions.iso8601DateTime(plugin.releaseTimestamp));
                    releaseTimestamp.put("displayValue", (Object)Messages.PluginManager_ago(Functions.getTimeSpanString(plugin.releaseTimestamp)));
                    jsonObject.put("releaseTimestamp", (Object)releaseTimestamp);
                }
                return jsonObject;
            }).collect(Collectors.toList());
            plugins.addAll(sitePlugins);
            if (plugins.size() < limit) continue;
            break;
        }
        JSONArray mappedPlugins = new JSONArray();
        mappedPlugins.addAll(plugins);
        return HttpResponses.okJSON(mappedPlugins);
    }

    @Restricted(value={DoNotUse.class})
    public org.kohsuke.stapler.HttpResponse doPlugins() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JSONArray response = new JSONArray();
        HashMap allPlugins = new HashMap();
        for (PluginWrapper plugin : this.plugins) {
            JSONObject pluginInfo = new JSONObject();
            pluginInfo.put("installed", (Object)true);
            pluginInfo.put("name", (Object)plugin.getShortName());
            pluginInfo.put("title", (Object)plugin.getDisplayName());
            pluginInfo.put("active", (Object)plugin.isActive());
            pluginInfo.put("enabled", (Object)plugin.isEnabled());
            pluginInfo.put("bundled", (Object)plugin.isBundled);
            pluginInfo.put("deleted", (Object)plugin.isDeleted());
            pluginInfo.put("downgradable", (Object)plugin.isDowngradable());
            pluginInfo.put("website", (Object)plugin.getUrl());
            List<PluginWrapper.Dependency> dependencies = plugin.getDependencies();
            if (dependencies != null && !dependencies.isEmpty()) {
                HashMap<String, String> dependencyMap = new HashMap<String, String>();
                for (PluginWrapper.Dependency dependency : dependencies) {
                    dependencyMap.put(dependency.shortName, dependency.version);
                }
                pluginInfo.put("dependencies", dependencyMap);
            } else {
                pluginInfo.put("dependencies", Collections.emptyMap());
            }
            response.add((Object)pluginInfo);
        }
        for (UpdateSite site : Jenkins.get().getUpdateCenter().getSiteList()) {
            for (UpdateSite.Plugin plugin : site.getAvailables()) {
                JSONObject pluginInfo = (JSONObject)allPlugins.get(plugin.name);
                if (pluginInfo == null) {
                    pluginInfo = new JSONObject();
                    pluginInfo.put("installed", (Object)false);
                }
                pluginInfo.put("name", (Object)plugin.name);
                pluginInfo.put("title", (Object)plugin.getDisplayName());
                pluginInfo.put("excerpt", (Object)plugin.excerpt);
                pluginInfo.put("site", (Object)site.getId());
                pluginInfo.put("dependencies", plugin.dependencies);
                pluginInfo.put("website", (Object)plugin.wiki);
                response.add((Object)pluginInfo);
            }
        }
        return HttpResponses.okJSON(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public org.kohsuke.stapler.HttpResponse doUpdateSources(StaplerRequest2 req) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (req.hasParameter("remove")) {
            UpdateCenter uc = Jenkins.get().getUpdateCenter();
            BulkChange bc = new BulkChange(uc);
            try {
                for (String id : req.getParameterValues("sources")) {
                    uc.getSites().remove(uc.getById(id));
                }
            }
            finally {
                bc.commit();
            }
        } else if (req.hasParameter("add")) {
            return new HttpRedirect("addSite");
        }
        return new HttpRedirect("./sites");
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public void doInstallPluginsDone() {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        InstallUtil.proceedToNextStateFrom(InstallState.INITIAL_PLUGINS_INSTALLING);
    }

    @RequirePOST
    public void doInstall(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        LinkedHashSet<String> plugins = new LinkedHashSet<String>();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            if (!n.startsWith("plugin.")) continue;
            n = n.substring(7);
            plugins.add(n);
        }
        boolean dynamicLoad = req.getParameter("dynamicLoad") != null;
        this.install(plugins, dynamicLoad);
        rsp.sendRedirect("updates/");
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public org.kohsuke.stapler.HttpResponse doInstallPlugins(StaplerRequest2 req) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String payload = IOUtils.toString((InputStream)req.getInputStream(), (String)req.getCharacterEncoding());
        JSONObject request = JSONObject.fromObject((Object)payload);
        JSONArray pluginListJSON = request.getJSONArray("plugins");
        ArrayList<String> plugins = new ArrayList<String>();
        for (int i = 0; i < pluginListJSON.size(); ++i) {
            plugins.add(pluginListJSON.getString(i));
        }
        UUID correlationId = UUID.randomUUID();
        try {
            boolean dynamicLoad = request.getBoolean("dynamicLoad");
            this.install(plugins, dynamicLoad, correlationId);
            JSONObject responseData = new JSONObject();
            responseData.put("correlationId", (Object)correlationId.toString());
            return HttpResponses.okJSON(responseData);
        }
        catch (RuntimeException e) {
            return HttpResponses.errorJSON(e.getMessage());
        }
    }

    @Restricted(value={NoExternalUse.class})
    public List<Future<UpdateCenter.UpdateCenterJob>> install(@NonNull Collection<String> plugins, boolean dynamicLoad) {
        return this.install(plugins, dynamicLoad, null);
    }

    private List<Future<UpdateCenter.UpdateCenterJob>> install(@NonNull Collection<String> plugins, boolean dynamicLoad, @CheckForNull UUID correlationId) {
        final ArrayList<Future<UpdateCenter.UpdateCenterJob>> installJobs = new ArrayList<Future<UpdateCenter.UpdateCenterJob>>();
        LOGGER.log(Level.INFO, "Starting installation of a batch of {0} plugins plus their dependencies", plugins.size());
        long start = System.nanoTime();
        ArrayList<PluginWrapper> batch = new ArrayList<PluginWrapper>();
        for (String n : plugins) {
            int index = n.indexOf(46);
            UpdateSite.Plugin p = null;
            if (index == -1) {
                p = this.getPlugin(n, UpdateCenter.ID_DEFAULT);
            } else {
                while (index != -1 && index + 1 < n.length()) {
                    String siteName;
                    String pluginName = n.substring(0, index);
                    UpdateSite.Plugin plugin = this.getPlugin(pluginName, siteName = n.substring(index + 1));
                    if (plugin != null) {
                        if (p != null) {
                            throw new Failure("Ambiguous plugin: " + n);
                        }
                        p = plugin;
                    }
                    index = n.indexOf(46, index + 1);
                }
            }
            if (p == null) {
                throw new Failure("No such plugin: " + n);
            }
            Future<UpdateCenter.UpdateCenterJob> jobFuture = p.deploy(dynamicLoad, correlationId, batch, false);
            installJobs.add(jobFuture);
        }
        Jenkins jenkins = Jenkins.get();
        final UpdateCenter updateCenter = jenkins.getUpdateCenter();
        if (dynamicLoad) {
            UpdateCenter updateCenter2 = updateCenter;
            Objects.requireNonNull(updateCenter2);
            installJobs.add(updateCenter.addJob(new UpdateCenter.CompleteBatchJob(updateCenter2, batch, start, correlationId)));
        }
        final Authentication currentAuth = Jenkins.getAuthentication2();
        if (!jenkins.getInstallState().isSetupComplete()) {
            jenkins.setInstallState(InstallState.INITIAL_PLUGINS_INSTALLING);
            updateCenter.persistInstallStatus();
            new Thread(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 8[WHILELOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.start();
        }
        return installJobs;
    }

    @CheckForNull
    private UpdateSite.Plugin getPlugin(String pluginName, String siteName) {
        UpdateSite updateSite = Jenkins.get().getUpdateCenter().getById(siteName);
        if (updateSite == null) {
            throw new Failure("No such update center: " + siteName);
        }
        return updateSite.getPlugin(pluginName);
    }

    @RequirePOST
    public org.kohsuke.stapler.HttpResponse doSiteConfigure(@QueryParameter String site) throws IOException {
        Jenkins hudson = Jenkins.get();
        hudson.checkPermission(Jenkins.ADMINISTER);
        UpdateCenter uc = hudson.getUpdateCenter();
        PersistedList<UpdateSite> sites = uc.getSites();
        sites.removeIf(s -> s.getId().equals(UpdateCenter.ID_DEFAULT));
        sites.add(new UpdateSite(UpdateCenter.ID_DEFAULT, site));
        return new HttpRedirect("advanced");
    }

    @POST
    public org.kohsuke.stapler.HttpResponse doProxyConfigure(StaplerRequest2 req) throws IOException, ServletException {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        ProxyConfiguration pc = (ProxyConfiguration)req.bindJSON(ProxyConfiguration.class, req.getSubmittedForm());
        ProxyConfigurationManager.saveProxyConfiguration(pc);
        return new HttpRedirect("advanced");
    }

    @RequirePOST
    public org.kohsuke.stapler.HttpResponse doUploadPlugin(StaplerRequest2 req) throws IOException, ServletException {
        if (Util.isOverridden(PluginManager.class, this.getClass(), "doUploadPlugin", StaplerRequest.class)) {
            try {
                return this.doUploadPlugin(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req));
            }
            catch (javax.servlet.ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((javax.servlet.ServletException)e);
            }
        }
        return this.doUploadPluginImpl(req);
    }

    @Deprecated
    @StaplerNotDispatchable
    public org.kohsuke.stapler.HttpResponse doUploadPlugin(StaplerRequest req) throws IOException, javax.servlet.ServletException {
        try {
            return this.doUploadPluginImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req));
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
        }
    }

    private org.kohsuke.stapler.HttpResponse doUploadPluginImpl(StaplerRequest2 req) throws IOException, ServletException {
        try {
            PluginCopier copier;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String fileName = "";
            File tmpDir = Files.createTempDirectory("uploadDir", new FileAttribute[0]).toFile();
            JakartaServletDiskFileUpload upload = new JakartaServletDiskFileUpload(((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setFile(tmpDir)).get());
            List items = upload.parseRequest((HttpServletRequest)req);
            String string = ((DiskFileItem)items.get(1)).getString();
            if (string != null && !string.isBlank()) {
                fileName = string;
                copier = new UrlPluginCopier(fileName);
            } else {
                FileItem fileItem = (FileItem)items.get(0);
                fileName = Util.getFileName(fileItem.getName());
                copier = new FileUploadPluginCopier(fileItem);
            }
            if ("".equals(fileName)) {
                return new HttpRedirect("advanced");
            }
            if (!fileName.endsWith(".jpi") && !fileName.endsWith(".hpi")) {
                throw new Failure(hudson.model.Messages.Hudson_NotAPlugin(fileName));
            }
            File t = File.createTempFile("uploaded", ".jpi", tmpDir);
            tmpDir.deleteOnExit();
            t.deleteOnExit();
            Files.delete(Util.fileToPath(t));
            try {
                copier.copy(t);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            copier.cleanup();
            String baseName = this.identifyPluginShortName(t);
            this.pluginUploaded = true;
            JSONArray dependencies = new JSONArray();
            try {
                Manifest m;
                try (JarFile jarFile = new JarFile(t);){
                    m = jarFile.getManifest();
                }
                String deps = m.getMainAttributes().getValue("Plugin-Dependencies");
                if (deps != null && !deps.isBlank()) {
                    String[] plugins;
                    for (String p : plugins = deps.split(",")) {
                        String[] attrs = p.split("[:;]");
                        dependencies.add((Object)new JSONObject().element("name", (Object)attrs[0]).element("version", (Object)attrs[1]).element("optional", p.contains("resolution:=optional")));
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to setup dependency list for plugin upload", e);
            }
            JSONObject cfg = new JSONObject().element("name", (Object)baseName).element("version", (Object)"0").element("url", (Object)t.toURI().toString()).element("dependencies", (Collection)dependencies);
            new UpdateSite.Plugin(new UpdateSite("_upload", null), "_upload", cfg).deploy(true);
            return new HttpRedirect("updates/");
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public FormValidation doCheckPluginUrl(StaplerRequest2 request, @QueryParameter String value) throws IOException {
        if (value != null && !value.isBlank()) {
            try {
                URL url = new URL(value);
                if (!url.getProtocol().startsWith("http")) {
                    return FormValidation.error(Messages.PluginManager_invalidUrl());
                }
                if (!url.getProtocol().equals("https")) {
                    return FormValidation.warning(Messages.PluginManager_insecureUrl());
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error(e.getMessage());
            }
        }
        return FormValidation.ok();
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public FormValidation doCheckUpdateSiteUrl(StaplerRequest2 request, @QueryParameter String value) throws InterruptedException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this.checkUpdateSiteURL(value);
    }

    @Restricted(value={DoNotUse.class})
    FormValidation checkUpdateSiteURL(@CheckForNull String value) throws InterruptedException {
        URI baseUri;
        if ((value = Util.fixEmptyAndTrim(value)) == null) {
            return FormValidation.error(Messages.PluginManager_emptyUpdateSiteUrl());
        }
        try {
            baseUri = new URI(value);
        }
        catch (URISyntaxException ex) {
            return FormValidation.error(ex, Messages.PluginManager_invalidUrl());
        }
        if ("file".equalsIgnoreCase(baseUri.getScheme())) {
            File f = new File(baseUri);
            if (f.isFile()) {
                return FormValidation.ok();
            }
            return FormValidation.error(Messages.PluginManager_connectionFailed());
        }
        if ("https".equalsIgnoreCase(baseUri.getScheme()) || "http".equalsIgnoreCase(baseUri.getScheme())) {
            HttpRequest httpRequest;
            URI uriWithQuery;
            try {
                uriWithQuery = baseUri.getRawQuery() == null ? new URI(value + "?version=" + Jenkins.VERSION + "&uctest") : new URI(value + "&version=" + Jenkins.VERSION + "&uctest");
            }
            catch (URISyntaxException e) {
                return FormValidation.error(e, Messages.PluginManager_invalidUrl());
            }
            HttpClient httpClient = ProxyConfiguration.newHttpClientBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
            try {
                httpRequest = ProxyConfiguration.newHttpRequestBuilder(uriWithQuery).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error(e, Messages.PluginManager_invalidUrl());
            }
            try {
                HttpResponse<Void> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
                if (100 <= httpResponse.statusCode() && httpResponse.statusCode() <= 399) {
                    return FormValidation.ok();
                }
                LOGGER.log(Level.FINE, "Obtained a non OK ({0}) response from the update center", new Object[]{httpResponse.statusCode(), baseUri});
                return FormValidation.error(Messages.PluginManager_connectionFailed());
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to check update site", e);
                return FormValidation.error(e, Messages.PluginManager_connectionFailed());
            }
        }
        return FormValidation.error(Messages.PluginManager_invalidUrl());
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public org.kohsuke.stapler.HttpResponse doCheckUpdatesServer() throws IOException {
        Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
        Retrier<FormValidation> updateServerRetrier = new Retrier.Builder<FormValidation>(this::checkUpdatesServer, (currentAttempt, result) -> result.kind == FormValidation.Kind.OK, "check updates server").withAttempts(CHECK_UPDATE_ATTEMPTS).withDelay(CHECK_UPDATE_SLEEP_TIME_MILLIS).withDuringActionExceptions(new Class[]{Exception.class}).withDuringActionExceptionListener((attempt, e) -> FormValidation.errorWithMarkup(e.getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        try {
            FormValidation result2 = updateServerRetrier.start();
            if (!FormValidation.Kind.OK.equals((Object)result2.kind)) {
                LOGGER.log(Level.SEVERE, Messages.PluginManager_UpdateSiteError(CHECK_UPDATE_ATTEMPTS, result2.getMessage()));
                if (CHECK_UPDATE_ATTEMPTS > 1 && !Logger.getLogger(Retrier.class.getName()).isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.SEVERE, Messages.PluginManager_UpdateSiteChangeLogLevel(Retrier.class.getName()));
                }
                this.lastErrorCheckUpdateCenters = Messages.PluginManager_CheckUpdateServerError(result2.getMessage());
            } else {
                this.lastErrorCheckUpdateCenters = null;
            }
        }
        catch (Exception e2) {
            LOGGER.log(Level.WARNING, Messages.PluginManager_UnexpectedException(), e2);
            throw new IOException(e2);
        }
        return org.kohsuke.stapler.HttpResponses.forwardToPreviousPage();
    }

    private FormValidation checkUpdatesServer() throws Exception {
        FormValidation v;
        for (UpdateSite site : Jenkins.get().getUpdateCenter().getSites()) {
            v = site.updateDirectlyNow();
            if (v.kind == FormValidation.Kind.OK) continue;
            return v;
        }
        for (DownloadService.Downloadable d : DownloadService.Downloadable.all()) {
            v = d.updateNow();
            if (v.kind == FormValidation.Kind.OK) continue;
            return v;
        }
        return FormValidation.ok();
    }

    public String getLastErrorCheckUpdateCenters() {
        return this.lastErrorCheckUpdateCenters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String identifyPluginShortName(File t) {
        try (JarFile j = new JarFile(t);){
            String name = j.getManifest().getMainAttributes().getValue("Short-Name");
            if (name == null) return FilenameUtils.getBaseName((String)t.getName());
            String string = name;
            return string;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to identify the short name from " + t, e);
        }
        return FilenameUtils.getBaseName((String)t.getName());
    }

    public Descriptor<ProxyConfiguration> getProxyDescriptor() {
        return Jenkins.get().getDescriptor(ProxyConfiguration.class);
    }

    public List<Future<UpdateCenter.UpdateCenterJob>> prevalidateConfig(InputStream configXml) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ArrayList<Future<UpdateCenter.UpdateCenterJob>> jobs = new ArrayList<Future<UpdateCenter.UpdateCenterJob>>();
        UpdateCenter uc = Jenkins.get().getUpdateCenter();
        for (Map.Entry<String, VersionNumber> requestedPlugin : this.parseRequestedPlugins(configXml).entrySet()) {
            UpdateSite.Plugin toInstall;
            PluginWrapper pw = this.getPlugin(requestedPlugin.getKey());
            if (pw == null) {
                toInstall = uc.getPlugin(requestedPlugin.getKey(), requestedPlugin.getValue());
                if (toInstall == null) {
                    LOGGER.log(Level.WARNING, "No such plugin {0} to install", requestedPlugin.getKey());
                    continue;
                }
                this.logPluginWarnings(requestedPlugin, toInstall);
                jobs.add(toInstall.deploy(true));
                continue;
            }
            if (!pw.isOlderThan(requestedPlugin.getValue())) continue;
            toInstall = uc.getPlugin(requestedPlugin.getKey(), requestedPlugin.getValue());
            if (toInstall == null) {
                LOGGER.log(Level.WARNING, "No such plugin {0} to upgrade", requestedPlugin.getKey());
                continue;
            }
            if (!pw.isOlderThan(new VersionNumber(toInstall.version))) {
                LOGGER.log(Level.WARNING, "{0}@{1} is no newer than what we already have", new Object[]{toInstall.name, toInstall.version});
                continue;
            }
            this.logPluginWarnings(requestedPlugin, toInstall);
            if (!toInstall.isCompatibleWithInstalledVersion()) {
                LOGGER.log(Level.WARNING, "{0}@{1} is incompatible with the installed @{2}", new Object[]{toInstall.name, toInstall.version, pw.getVersion()});
            }
            jobs.add(toInstall.deploy(true));
        }
        return jobs;
    }

    private void logPluginWarnings(Map.Entry<String, VersionNumber> requestedPlugin, UpdateSite.Plugin toInstall) {
        if (new VersionNumber(toInstall.version).compareTo(requestedPlugin.getValue()) < 0) {
            LOGGER.log(Level.WARNING, "{0} can only be satisfied in @{1}", new Object[]{requestedPlugin, toInstall.version});
        }
        if (toInstall.isForNewerHudson()) {
            LOGGER.log(Level.WARNING, "{0}@{1} was built for a newer Jenkins", new Object[]{toInstall.name, toInstall.version});
        }
    }

    @RequirePOST
    public JSONArray doPrevalidateConfig(StaplerRequest2 req) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JSONArray response = new JSONArray();
        for (Map.Entry<String, VersionNumber> p : this.parseRequestedPlugins((InputStream)req.getInputStream()).entrySet()) {
            PluginWrapper pw = this.getPlugin(p.getKey());
            JSONObject j = new JSONObject().accumulate("name", (Object)p.getKey()).accumulate("version", (Object)p.getValue().toString());
            if (pw == null) {
                response.add((Object)j.accumulate("mode", (Object)"missing"));
                continue;
            }
            if (!pw.isOlderThan(p.getValue())) continue;
            response.add((Object)j.accumulate("mode", (Object)"old"));
        }
        return response;
    }

    @RequirePOST
    public org.kohsuke.stapler.HttpResponse doInstallNecessaryPlugins(StaplerRequest2 req) throws IOException {
        this.prevalidateConfig((InputStream)req.getInputStream());
        return org.kohsuke.stapler.HttpResponses.redirectViaContextPath((String)"pluginManager/updates/");
    }

    public Map<String, VersionNumber> parseRequestedPlugins(InputStream configXml) throws IOException {
        final TreeMap<String, VersionNumber> requestedPlugins = new TreeMap<String, VersionNumber>();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            spf.newSAXParser().parse(configXml, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String plugin = attributes.getValue("plugin");
                    if (plugin == null) {
                        return;
                    }
                    if (!plugin.matches("[^@]+@[^@]+")) {
                        throw new SAXException("Malformed plugin attribute: " + plugin);
                    }
                    int at = plugin.indexOf(64);
                    String shortName = plugin.substring(0, at);
                    VersionNumber existing = (VersionNumber)requestedPlugins.get(shortName);
                    VersionNumber requested = new VersionNumber(plugin.substring(at + 1));
                    if (existing == null || existing.compareTo(requested) < 0) {
                        requestedPlugins.put(shortName, requested);
                    }
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                    return RestrictiveEntityResolver.INSTANCE.resolveEntity(publicId, systemId);
                }
            });
        }
        catch (SAXException x) {
            throw new IOException("Failed to parse XML", x);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        return requestedPlugins;
    }

    @Restricted(value={DoNotUse.class})
    public MetadataCache createCache() {
        return new MetadataCache();
    }

    @NonNull
    public List<PluginWrapper.PluginDisableResult> disablePlugins(@NonNull PluginWrapper.PluginDisableStrategy strategy, @NonNull List<String> plugins) throws IOException {
        ArrayList<PluginWrapper.PluginDisableResult> results = new ArrayList<PluginWrapper.PluginDisableResult>(plugins.size());
        for (String pluginName : plugins) {
            PluginWrapper plugin = this.getPlugin(pluginName);
            if (plugin == null) {
                results.add(new PluginWrapper.PluginDisableResult(pluginName, PluginWrapper.PluginDisableStatus.NO_SUCH_PLUGIN, Messages.PluginWrapper_NoSuchPlugin(pluginName)));
                continue;
            }
            results.add(plugin.disable(strategy));
        }
        return results;
    }

    @Restricted(value={DoNotUse.class})
    public String unscientific(double d) {
        return String.format(Locale.US, "%15.4f", d);
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
        }
        return this;
    }

    @Restricted(value={DoNotUse.class})
    public boolean isMetaLabel(String label) {
        return "adopt-this-plugin".equals(label) || "deprecated".equals(label);
    }

    @Restricted(value={DoNotUse.class})
    public boolean hasAdoptThisPluginLabel(UpdateSite.Plugin plugin) {
        return plugin.hasCategory("adopt-this-plugin");
    }

    @Restricted(value={DoNotUse.class})
    public boolean hasAdoptThisPluginLabel(PluginWrapper plugin) {
        UpdateSite.Plugin pluginMeta = Jenkins.get().getUpdateCenter().getPlugin(plugin.getShortName());
        if (pluginMeta == null) {
            return false;
        }
        return pluginMeta.hasCategory("adopt-this-plugin");
    }

    static {
        try {
            CHECK_UPDATE_SLEEP_TIME_MILLIS = SystemProperties.getInteger(PluginManager.class.getName() + ".checkUpdateSleepTimeMillis", 1000);
            CHECK_UPDATE_ATTEMPTS = SystemProperties.getInteger(PluginManager.class.getName() + ".checkUpdateAttempts", 1);
            CHECK_UPDATE_ATTEMPTS = CHECK_UPDATE_ATTEMPTS > 0 ? CHECK_UPDATE_ATTEMPTS : 1;
        }
        catch (RuntimeException e) {
            try {
                LOGGER.warning(String.format("There was an error initializing the PluginManager. Exception: %s", e));
                CHECK_UPDATE_ATTEMPTS = CHECK_UPDATE_ATTEMPTS > 0 ? CHECK_UPDATE_ATTEMPTS : 1;
            }
            catch (Throwable throwable) {
                CHECK_UPDATE_ATTEMPTS = CHECK_UPDATE_ATTEMPTS > 0 ? CHECK_UPDATE_ATTEMPTS : 1;
                CHECK_UPDATE_SLEEP_TIME_MILLIS = CHECK_UPDATE_SLEEP_TIME_MILLIS > 0 ? CHECK_UPDATE_SLEEP_TIME_MILLIS : 1000;
                throw throwable;
            }
            CHECK_UPDATE_SLEEP_TIME_MILLIS = CHECK_UPDATE_SLEEP_TIME_MILLIS > 0 ? CHECK_UPDATE_SLEEP_TIME_MILLIS : 1000;
        }
        CHECK_UPDATE_SLEEP_TIME_MILLIS = CHECK_UPDATE_SLEEP_TIME_MILLIS > 0 ? CHECK_UPDATE_SLEEP_TIME_MILLIS : 1000;
        FAST_LOOKUP = !SystemProperties.getBoolean(PluginManager.class.getName() + ".noFastLookup");
        UPLOAD_PLUGINS = new Permission(Jenkins.PERMISSIONS, "UploadPlugins", Messages._PluginManager_UploadPluginsPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
        CONFIGURE_UPDATECENTER = new Permission(Jenkins.PERMISSIONS, "ConfigureUpdateCenter", Messages._PluginManager_ConfigureUpdateCenterPermission_Description(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
        SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(PluginManager.class.getName() + ".skipPermissionCheck");
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum PMConstructor {
        JENKINS{

            @Override
            @NonNull
            PluginManager doCreate(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
                return klass.getConstructor(Jenkins.class).newInstance(jenkins);
            }
        }
        ,
        SC_FILE2{

            @Override
            @NonNull
            PluginManager doCreate(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
                return klass.getConstructor(ServletContext.class, File.class).newInstance(jenkins.getServletContext(), jenkins.getRootDir());
            }
        }
        ,
        SC_FILE{

            @Override
            @NonNull
            PluginManager doCreate(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
                return klass.getConstructor(javax.servlet.ServletContext.class, File.class).newInstance(jenkins.servletContext, jenkins.getRootDir());
            }
        }
        ,
        FILE{

            @Override
            @NonNull
            PluginManager doCreate(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
                return klass.getConstructor(File.class).newInstance(jenkins.getRootDir());
            }
        };


        @CheckForNull
        final PluginManager create(@NonNull Class<? extends PluginManager> klass, @NonNull Jenkins jenkins) throws ReflectiveOperationException {
            try {
                return this.doCreate(klass, jenkins);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        @NonNull
        abstract PluginManager doCreate(@NonNull Class<? extends PluginManager> var1, @NonNull Jenkins var2) throws ReflectiveOperationException;
    }

    public static final class UberClassLoader
    extends ClassLoader {
        private final List<PluginWrapper> activePlugins;
        private final ConcurrentMap<String, Optional<Class<?>>> loaded = new ConcurrentHashMap();

        public UberClassLoader(List<PluginWrapper> activePlugins) {
            super("UberClassLoader", PluginManager.class.getClassLoader());
            this.activePlugins = activePlugins;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("SimpleTemplateScript")) {
                throw new ClassNotFoundException("ignoring " + name);
            }
            return (Class)this.loaded.computeIfAbsent(name, this::computeValue).orElseThrow(() -> new ClassNotFoundException(name));
        }

        private Optional<Class<?>> computeValue(String name) {
            for (PluginWrapper p : this.activePlugins) {
                try {
                    if (FAST_LOOKUP) {
                        return Optional.of(ClassLoaderReflectionToolkit.loadClass(p.classLoader, name));
                    }
                    return Optional.of(p.classLoader.loadClass(name));
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return Optional.empty();
        }

        @Override
        protected URL findResource(String name) {
            for (PluginWrapper p : this.activePlugins) {
                URL url = FAST_LOOKUP ? ClassLoaderReflectionToolkit._findResource(p.classLoader, name) : p.classLoader.getResource(name);
                if (url == null) continue;
                return url;
            }
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            ArrayList<URL> resources = new ArrayList<URL>();
            for (PluginWrapper p : this.activePlugins) {
                if (FAST_LOOKUP) {
                    resources.addAll(Collections.list(ClassLoaderReflectionToolkit._findResources(p.classLoader, name)));
                    continue;
                }
                resources.addAll(Collections.list(p.classLoader.getResources(name)));
            }
            return Collections.enumeration(resources);
        }

        void clearCacheMisses() {
            this.loaded.values().removeIf(Optional::isEmpty);
        }

        public String toString() {
            return "classLoader " + this.getClass().getName();
        }

        @Restricted(value={NoExternalUse.class})
        @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="All URLs point to local files, so no DNS lookup.")
        public boolean isPluginJar(URL jarUrl) {
            for (PluginWrapper plugin : this.activePlugins) {
                if (!(plugin.classLoader instanceof URLClassLoader) || !Set.of(((URLClassLoader)plugin.classLoader).getURLs()).contains(jarUrl)) continue;
                return true;
            }
            return false;
        }

        static {
            UberClassLoader.registerAsParallelCapable();
        }
    }

    public static final class FailedPlugin {
        public final String name;
        public final Exception cause;
        @Nullable
        public final PluginWrapper pluginWrapper;

        public FailedPlugin(String name, Exception cause) {
            this.name = name;
            this.cause = cause;
            this.pluginWrapper = null;
        }

        public FailedPlugin(PluginWrapper pluginWrapper, Exception cause) {
            this.name = pluginWrapper.getShortName();
            this.cause = cause;
            this.pluginWrapper = pluginWrapper;
        }

        public String getExceptionString() {
            return Functions.printThrowable(this.cause);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class UpdateCenterProxy
    implements StaplerFallback {
        public Object getStaplerFallback() {
            return Jenkins.get().getUpdateCenter();
        }
    }

    static class UrlPluginCopier
    implements PluginCopier {
        private String url;

        UrlPluginCopier(String url) {
            this.url = url;
        }

        @Override
        public void copy(File target) throws Exception {
            try (InputStream input = ProxyConfiguration.getInputStream(new URL(this.url));){
                Files.copy(input, target.toPath(), new CopyOption[0]);
            }
        }

        @Override
        public void cleanup() {
        }
    }

    static class FileUploadPluginCopier
    implements PluginCopier {
        private FileItem fileItem;

        FileUploadPluginCopier(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        @Override
        public void copy(File target) throws IOException {
            try {
                this.fileItem.write(Util.fileToPath(target));
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public void cleanup() {
            try {
                this.fileItem.delete();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static interface PluginCopier {
        public void copy(File var1) throws Exception;

        public void cleanup();
    }

    @Restricted(value={NoExternalUse.class})
    public static final class MetadataCache {
        private final Map<String, Object> data = new HashMap<String, Object>();

        public <T> T of(String key, Class<T> type, Supplier<T> func) {
            return type.cast(this.data.computeIfAbsent(key, _ignored -> func.get()));
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Symbol(value={"pluginDeprecation"})
    @Extension
    public static final class PluginDeprecationMonitor
    extends AdministrativeMonitor {
        @Override
        public String getDisplayName() {
            return Messages.PluginManager_PluginDeprecationMonitor_DisplayName();
        }

        @Override
        public boolean isActivated() {
            return !this.getDeprecatedPlugins().isEmpty();
        }

        public Map<PluginWrapper, String> getDeprecatedPlugins() {
            return Jenkins.get().getPluginManager().getPlugins().stream().filter(PluginWrapper::isDeprecated).collect(Collectors.toMap(Function.identity(), it -> it.getDeprecations().get((int)0).url));
        }
    }

    @Extension
    @Symbol(value={"pluginUpdate"})
    public static final class PluginUpdateMonitor
    extends AdministrativeMonitor {
        private Map<String, PluginUpdateInfo> pluginsToBeUpdated = new HashMap<String, PluginUpdateInfo>();

        public static PluginUpdateMonitor getInstance() {
            return ExtensionList.lookupSingleton(PluginUpdateMonitor.class);
        }

        public void ifPluginOlderThenReport(String pluginName, String requiredVersion, String message) {
            Plugin plugin = Jenkins.get().getPlugin(pluginName);
            if (plugin != null && plugin.getWrapper().getVersionNumber().isOlderThan(new VersionNumber(requiredVersion))) {
                this.pluginsToBeUpdated.put(pluginName, new PluginUpdateInfo(pluginName, message));
            }
        }

        @Override
        public boolean isActivated() {
            return !this.pluginsToBeUpdated.isEmpty();
        }

        @Override
        public String getDisplayName() {
            return Messages.PluginManager_PluginUpdateMonitor_DisplayName();
        }

        public void addPluginToUpdate(String pluginName, String message) {
            this.pluginsToBeUpdated.put(pluginName, new PluginUpdateInfo(pluginName, message));
        }

        public Collection<PluginUpdateInfo> getPluginsToBeUpdated() {
            return this.pluginsToBeUpdated.values();
        }

        public static class PluginUpdateInfo {
            public final String pluginName;
            public final String message;

            private PluginUpdateInfo(String pluginName, String message) {
                this.pluginName = pluginName;
                this.message = message;
            }
        }
    }

    @Extension
    @Symbol(value={"pluginCycleDependencies"})
    public static final class PluginCycleDependenciesMonitor
    extends AdministrativeMonitor {
        private volatile transient boolean isActive = false;
        private volatile transient List<PluginWrapper> pluginsWithCycle;

        @Override
        public String getDisplayName() {
            return Messages.PluginManager_PluginCycleDependenciesMonitor_DisplayName();
        }

        @Override
        public boolean isActivated() {
            if (this.pluginsWithCycle == null) {
                this.pluginsWithCycle = new ArrayList<PluginWrapper>();
                for (PluginWrapper p : Jenkins.get().getPluginManager().getPlugins()) {
                    if (!p.hasCycleDependency()) continue;
                    this.pluginsWithCycle.add(p);
                    this.isActive = true;
                }
            }
            return this.isActive;
        }

        public List<PluginWrapper> getPluginsWithCycle() {
            return this.pluginsWithCycle;
        }
    }

    static final class PluginInstanceStore {
        final Map<PluginWrapper, Plugin> store = new ConcurrentHashMap<PluginWrapper, Plugin>();

        PluginInstanceStore() {
        }
    }
}

