/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import com.sun.jna.Native;
import com.sun.jna.StringArray;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.Platform;
import hudson.lifecycle.Lifecycle;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.util.jna.GNUCLibrary;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.JavaVMArguments;

public class UnixLifecycle
extends Lifecycle {
    @NonNull
    private List<String> args = JavaVMArguments.current();
    private static final Logger LOGGER = Logger.getLogger(UnixLifecycle.class.getName());

    @Override
    public void restart() throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        try {
            if (jenkins != null) {
                jenkins.cleanUp();
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to clean up. Restart will continue.", e);
        }
        int sz = GNUCLibrary.LIBC.getdtablesize();
        for (int i = 3; i < sz; ++i) {
            int flags = GNUCLibrary.LIBC.fcntl(i, 1);
            if (flags < 0) continue;
            GNUCLibrary.LIBC.fcntl(i, 2, flags | 1);
        }
        String exe = this.args.get(0);
        GNUCLibrary.LIBC.execvp(exe, new StringArray(this.args.toArray(new String[0])));
        throw new IOException("Failed to exec '" + exe + "' " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
    }

    @Override
    public void verifyRestartable() throws RestartNotSupportedException {
        if (!Functions.isGlibcSupported()) {
            throw new RestartNotSupportedException("Restart is not supported on platforms without libc");
        }
        if (Platform.isDarwin() && !Platform.isSnowLeopardOrLater()) {
            throw new RestartNotSupportedException("Restart is not supported on Mac OS X");
        }
    }
}

