/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Executables;
import hudson.model.queue.SubTask;
import hudson.model.queue.WorkUnit;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AccessControlled;
import hudson.util.InterceptingProxy;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;
import jenkins.model.Jenkins;
import jenkins.model.queue.AsynchronousExecution;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;

@ExportedBean
public class Executor
extends Thread
implements ModelObject {
    @NonNull
    protected final Computer owner;
    private final Queue queue;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final int DEFAULT_ESTIMATED_DURATION = -1;
    @GuardedBy(value="lock")
    private long startTime;
    private final long creationTime = System.currentTimeMillis();
    private int number;
    @GuardedBy(value="lock")
    private Queue.Executable executable;
    private long executableEstimatedDuration = -1L;
    @GuardedBy(value="lock")
    private AsynchronousExecution asynchronousExecution;
    @GuardedBy(value="lock")
    private WorkUnit workUnit;
    @GuardedBy(value="lock")
    private boolean started;
    @GuardedBy(value="lock")
    private Result interruptStatus;
    @GuardedBy(value="lock")
    private final List<CauseOfInterruption> causes = new Vector<CauseOfInterruption>();
    private static final ThreadLocal<Executor> IMPERSONATION = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Executor.class.getName());

    public Executor(@NonNull Computer owner, int n) {
        super("Executor #" + n + " for " + owner.getDisplayName());
        this.owner = owner;
        this.queue = Jenkins.get().getQueue();
        this.number = n;
    }

    @Override
    public void interrupt() {
        if (Thread.currentThread() == this) {
            super.interrupt();
        } else {
            this.interrupt(Result.ABORTED);
        }
    }

    void interruptForShutdown() {
        this.interrupt(Result.ABORTED, true);
    }

    public void interrupt(Result result) {
        this.interrupt(result, false);
    }

    private void interrupt(Result result, boolean forShutdown) {
        Authentication a = Jenkins.getAuthentication2();
        if (a.equals(ACL.SYSTEM2)) {
            this.interrupt(result, forShutdown, new CauseOfInterruption[0]);
        } else {
            this.interrupt(result, forShutdown, new CauseOfInterruption.UserInterruption(a.getName()));
        }
    }

    public void interrupt(Result result, CauseOfInterruption ... causes) {
        this.interrupt(result, false, causes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrupt(Result result, boolean forShutdown, CauseOfInterruption ... causes) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("%s is interrupted(%s): %s", this.getDisplayName(), result, Arrays.stream(causes).map(Object::toString).collect(Collectors.joining(","))), new InterruptedException());
        }
        this.lock.writeLock().lock();
        try {
            if (!this.started) {
                this.owner.removeExecutor(this);
                return;
            }
            this.interruptStatus = result;
            for (CauseOfInterruption c : causes) {
                if (this.causes.contains(c)) continue;
                this.causes.add(c);
            }
            if (this.asynchronousExecution != null) {
                this.asynchronousExecution.interrupt(forShutdown);
            } else {
                super.interrupt();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Result abortResult() {
        Thread.interrupted();
        this.lock.writeLock().lock();
        try {
            Result r = this.interruptStatus;
            if (r == null) {
                r = Result.ABORTED;
            }
            Result result = r;
            return result;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCauseOfInterruption(Run<?, ?> build, TaskListener listener) {
        ArrayList<CauseOfInterruption> r;
        this.lock.writeLock().lock();
        try {
            if (this.causes.isEmpty()) {
                return;
            }
            r = new ArrayList<CauseOfInterruption>(this.causes);
            this.causes.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        build.addAction(new InterruptedBuildAction(r));
        for (CauseOfInterruption c : r) {
            c.print(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWorkUnit(String reason) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            pw.printf("%s grabbed %s from queue but %s %s. ", this.getName(), this.workUnit, this.owner.getDisplayName(), reason);
            if (this.owner.getTerminatedBy().isEmpty()) {
                pw.print("No termination trace available.");
            } else {
                pw.println("Termination trace follows:");
                for (Computer.TerminationRequest request : this.owner.getTerminatedBy()) {
                    Functions.printStackTrace((Throwable)request, pw);
                }
            }
        }
        LOGGER.log(Level.WARNING, writer.toString());
        this.lock.writeLock().lock();
        try {
            if (this.executable != null) {
                throw new IllegalStateException("Cannot reset the work unit after the executable has been created");
            }
            this.workUnit = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        WorkUnit workUnit;
        if (!(this.owner instanceof Jenkins.MasterComputer)) {
            if (!this.owner.isOnline()) {
                this.resetWorkUnit("went off-line before the task's worker thread started");
                this.owner.removeExecutor(this);
                this.queue.scheduleMaintenance();
                return;
            }
            if (this.owner.getNode() == null) {
                this.resetWorkUnit("was removed before the task's worker thread started");
                this.owner.removeExecutor(this);
                this.queue.scheduleMaintenance();
                return;
            }
        }
        this.lock.writeLock().lock();
        try {
            this.startTime = System.currentTimeMillis();
            workUnit = this.workUnit;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
            boolean needFinish1;
            Throwable problems;
            Queue.Executable executable;
            SubTask task;
            block71: {
                boolean needFinish122;
                task = Queue.withLock(new Callable<SubTask>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public SubTask call() throws Exception {
                        SubTask task;
                        Queue.Executable executable;
                        if (!(Executor.this.owner instanceof Jenkins.MasterComputer)) {
                            if (!Executor.this.owner.isOnline()) {
                                Executor.this.resetWorkUnit("went off-line before the task's worker thread was ready to execute");
                                return null;
                            }
                            if (Executor.this.owner.getNode() == null) {
                                Executor.this.resetWorkUnit("was removed before the task's worker thread was ready to execute");
                                return null;
                            }
                        }
                        workUnit.setExecutor(Executor.this);
                        Executor.this.queue.onStartExecuting(Executor.this);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, Executor.this.getName() + " grabbed " + workUnit + " from queue");
                        }
                        if ((executable = (task = workUnit.work).createExecutable()) == null) {
                            String displayName = task instanceof Queue.Task ? ((Queue.Task)task).getFullDisplayName() : task.getDisplayName();
                            LOGGER.log(Level.WARNING, "{0} cannot be run (for example because it is disabled)", displayName);
                        }
                        Executor.this.lock.writeLock().lock();
                        try {
                            Executor.this.executable = executable;
                        }
                        finally {
                            Executor.this.lock.writeLock().unlock();
                        }
                        workUnit.setExecutable(executable);
                        return task;
                    }
                });
                this.lock.readLock().lock();
                try {
                    if (this.workUnit == null) {
                        return;
                    }
                    executable = this.executable;
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, this.getName() + " is going to execute " + executable);
                }
                problems = null;
                workUnit.context.synchronizeStart();
                if (executable != null) break block71;
                this.lock.readLock().lock();
                try {
                    needFinish122 = this.asynchronousExecution == null;
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (!needFinish122) return;
                this.finish1(problems);
                return;
            }
            this.executableEstimatedDuration = executable.getEstimatedDuration();
            if (executable instanceof Actionable) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "when running {0} from {1} we are copying {2} actions whereas the item currently has {3}", new Object[]{executable, workUnit.context.item, workUnit.context.actions, workUnit.context.item.getAllActions()});
                }
                for (Action action : workUnit.context.actions) {
                    ((Actionable)((Object)executable)).addAction(action);
                }
            }
            this.setName(this.getName() + " : executing " + executable);
            Authentication auth = workUnit.context.item.authenticate2();
            LOGGER.log(Level.FINE, "{0} is now executing {1} as {2}", new Object[]{this.getName(), executable, auth});
            if (LOGGER.isLoggable(Level.FINE) && auth.equals(ACL.SYSTEM2)) {
                if (QueueItemAuthenticatorDescriptor.all().isEmpty()) {
                    LOGGER.fine("no QueueItemAuthenticator implementations installed");
                } else if (QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty()) {
                    LOGGER.fine("no QueueItemAuthenticator implementations configured");
                } else {
                    LOGGER.log(Level.FINE, "some QueueItemAuthenticator implementations configured but neglected to authenticate {0}", executable);
                }
            }
            try (ACLContext context = ACL.as2(auth);){
                this.queue.execute(executable, task);
            }
            this.lock.readLock().lock();
            try {
                needFinish1 = this.asynchronousExecution == null;
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (!needFinish1) return;
            this.finish1(problems);
            return;
            catch (AsynchronousExecution x) {
                boolean needFinish132;
                this.lock.writeLock().lock();
                try {
                    x.setExecutorWithoutCompleting(this);
                    this.asynchronousExecution = x;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                x.maybeComplete();
                this.lock.readLock().lock();
                {
                    catch (Throwable throwable) {
                        boolean needFinish142;
                        this.lock.readLock().lock();
                        try {
                            needFinish142 = this.asynchronousExecution == null;
                        }
                        finally {
                            this.lock.readLock().unlock();
                        }
                        if (!needFinish142) throw throwable;
                        this.finish1(problems);
                        throw throwable;
                    }
                }
                try {
                    needFinish132 = this.asynchronousExecution == null;
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (!needFinish132) return;
                this.finish1(problems);
                return;
                catch (Throwable e) {
                    boolean needFinish152;
                    problems = e;
                    this.lock.readLock().lock();
                    try {
                        needFinish152 = this.asynchronousExecution == null;
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                    if (!needFinish152) return;
                    this.finish1(problems);
                    return;
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, this.getName() + " interrupted", e);
            return;
        }
        catch (Error | Exception e) {
            LOGGER.log(Level.SEVERE, this.getName() + ": Unexpected executor death", e);
            return;
        }
        finally {
            if (this.asynchronousExecution == null) {
                this.finish2();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish1(@CheckForNull Throwable problems) {
        if (problems != null) {
            LOGGER.log(Level.SEVERE, "Executor threw an exception", problems);
            this.workUnit.context.abort(problems);
        }
        long time = System.currentTimeMillis() - this.startTime;
        LOGGER.log(Level.FINE, "{0} completed {1} in {2}ms", new Object[]{this.getName(), this.executable, time});
        try {
            this.workUnit.context.synchronizeEnd(this, this.executable, problems, time);
        }
        catch (InterruptedException e) {
            this.workUnit.context.abort(e);
        }
        finally {
            this.workUnit.setExecutor(null);
        }
    }

    private void finish2() {
        for (RuntimeException runtimeException : this.owner.getTerminatedBy()) {
            LOGGER.log(Level.FINE, String.format("%s termination trace", this.getName()), runtimeException);
        }
        this.owner.removeExecutor(this);
        if (this instanceof OneOffExecutor) {
            this.owner.remove((OneOffExecutor)this);
        }
        this.executableEstimatedDuration = -1L;
        this.queue.scheduleMaintenance();
    }

    @Restricted(value={NoExternalUse.class})
    public void completedAsynchronous(@CheckForNull Throwable error) {
        try {
            this.finish1(error);
        }
        finally {
            this.finish2();
        }
        this.asynchronousExecution = null;
    }

    @CheckForNull
    public Queue.Executable getCurrentExecutable() {
        this.lock.readLock().lock();
        try {
            Queue.Executable executable = this.executable;
            return executable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Exported(name="currentExecutable")
    @Restricted(value={DoNotUse.class})
    public Queue.Executable getCurrentExecutableForApi() {
        Queue.Executable candidate = this.getCurrentExecutable();
        return candidate instanceof AccessControlled && ((AccessControlled)((Object)candidate)).hasPermission(Item.READ) ? candidate : null;
    }

    @NonNull
    public Collection<CauseOfInterruption> getCausesOfInterruption() {
        return Collections.unmodifiableCollection(this.causes);
    }

    @CheckForNull
    public WorkUnit getCurrentWorkUnit() {
        this.lock.readLock().lock();
        try {
            WorkUnit workUnit = this.workUnit;
            return workUnit;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public FilePath getCurrentWorkspace() {
        this.lock.readLock().lock();
        try {
            if (this.executable == null) {
                FilePath filePath = null;
                return filePath;
            }
            if (this.executable instanceof AbstractBuild) {
                AbstractBuild ab = (AbstractBuild)this.executable;
                FilePath filePath = ab.getWorkspace();
                return filePath;
            }
            FilePath filePath = null;
            return filePath;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public String getDisplayName() {
        return "Executor #" + this.getNumber();
    }

    @Exported
    public int getNumber() {
        return this.number;
    }

    @Exported
    public boolean isIdle() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.workUnit == null && this.executable == null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isBusy() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.workUnit != null || this.executable != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isActive() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.started || this.asynchronousExecution != null || this.isAlive();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @CheckForNull
    public AsynchronousExecution getAsynchronousExecution() {
        this.lock.readLock().lock();
        try {
            AsynchronousExecution asynchronousExecution = this.asynchronousExecution;
            return asynchronousExecution;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isDisplayCell() {
        AsynchronousExecution asynchronousExecution = this.getAsynchronousExecution();
        return asynchronousExecution == null || asynchronousExecution.displayCell();
    }

    public boolean isParking() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.started;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    @CheckForNull
    public Throwable getCauseOfDeath() {
        return null;
    }

    @Exported
    public int getProgress() {
        long d = this.executableEstimatedDuration;
        if (d <= 0L) {
            return -1;
        }
        int num = (int)(this.getElapsedTime() * 100L / d);
        if (num >= 100) {
            num = 99;
        }
        return num;
    }

    @Exported
    public boolean isLikelyStuck() {
        this.lock.readLock().lock();
        try {
            if (this.executable == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        long elapsed = this.getElapsedTime();
        long d = this.executableEstimatedDuration;
        if (d >= 0L) {
            return d * 10L < elapsed;
        }
        return TimeUnit.MILLISECONDS.toHours(elapsed) > 24L;
    }

    public long getElapsedTime() {
        this.lock.readLock().lock();
        try {
            long l = System.currentTimeMillis() - this.startTime;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getTimeSpentInQueue() {
        this.lock.readLock().lock();
        try {
            long l = this.startTime - this.workUnit.context.item.buildableStartMilliseconds;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getTimestampString() {
        return Util.getTimeSpanString(this.getElapsedTime());
    }

    public String getEstimatedRemainingTime() {
        long d = this.executableEstimatedDuration;
        if (d < 0L) {
            return Messages.Executor_NotAvailable();
        }
        long eta = d - this.getElapsedTime();
        if (eta <= 0L) {
            return Messages.Executor_NotAvailable();
        }
        return Util.getTimeSpanString(eta);
    }

    public long getEstimatedRemainingTimeMillis() {
        long d = this.executableEstimatedDuration;
        if (d < 0L) {
            return -1L;
        }
        long eta = d - this.getElapsedTime();
        if (eta <= 0L) {
            return -1L;
        }
        return eta;
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException();
    }

    void start(WorkUnit task) {
        this.lock.writeLock().lock();
        try {
            this.workUnit = task;
            super.start();
            this.started = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @RequirePOST
    @Deprecated
    public void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.doStop().generateResponse(req, rsp, (Object)this);
    }

    @RequirePOST
    public HttpResponse doStop() {
        return this.doStopBuild(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doStopBuild(@QueryParameter(fixEmpty=true) @CheckForNull String runExtId) {
        this.lock.writeLock().lock();
        try {
            if (this.executable != null && (runExtId == null || runExtId.isEmpty() || !(this.executable instanceof Run) || runExtId.equals(((Run)((Object)this.executable)).getExternalizableId()))) {
                Queue.Task ownerTask = Executables.getParentOf(this.executable).getOwnerTask();
                boolean canAbort = ownerTask.hasAbortPermission();
                if (canAbort && ownerTask instanceof AccessControlled && !((AccessControlled)((Object)ownerTask)).hasPermission(Item.READ)) {
                    HttpResponses.HttpResponseException httpResponseException = HttpResponses.forwardToPreviousPage();
                    return httpResponseException;
                }
                ownerTask.checkAbortPermission();
                this.interrupt();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return HttpResponses.forwardToPreviousPage();
    }

    @Deprecated
    public HttpResponse doYank() {
        return HttpResponses.redirectViaContextPath((String)"/");
    }

    public boolean hasStopPermission() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.executable != null && Executables.getParentOf(this.executable).getOwnerTask().hasAbortPermission();
            return bl;
        }
        catch (RuntimeException ex) {
            if (!(ex instanceof AccessDeniedException)) {
                LOGGER.log(Level.WARNING, "Unhandled exception", ex);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @NonNull
    public Computer getOwner() {
        return this.owner;
    }

    public long getIdleStartMilliseconds() {
        if (this.isIdle()) {
            return Math.max(this.creationTime, this.owner.getConnectTime());
        }
        return Math.max(this.startTime + Math.max(0L, this.executableEstimatedDuration), System.currentTimeMillis() + 15000L);
    }

    public Api getApi() {
        return new Api(this);
    }

    public <T> T newImpersonatingProxy(Class<T> type, T core) {
        return new InterceptingProxy(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object call(Object o, Method m, Object[] args) throws Throwable {
                Executor old = IMPERSONATION.get();
                IMPERSONATION.set(Executor.this);
                try {
                    Object object = m.invoke(o, args);
                    return object;
                }
                finally {
                    IMPERSONATION.set(old);
                }
            }
        }.wrap(type, core);
    }

    @CheckForNull
    public static Executor currentExecutor() {
        Thread t = Thread.currentThread();
        if (t instanceof Executor) {
            return (Executor)t;
        }
        return IMPERSONATION.get();
    }

    @CheckForNull
    public static Executor of(Queue.Executable executable) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return null;
        }
        for (Computer computer : jenkins.getComputers()) {
            for (Executor executor : computer.getAllExecutors()) {
                if (executor.getCurrentExecutable() != executable) continue;
                return executor;
            }
        }
        return null;
    }

    @Deprecated
    public static long getEstimatedDurationFor(Queue.Executable e) {
        return e == null ? -1L : e.getEstimatedDuration();
    }
}

