/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Functions;
import hudson.RestrictedSince;
import hudson.markup.MarkupFormatter;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.security.AuthorizationStrategy;
import hudson.security.Messages;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.util.FormApply;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.util.ServerTcpPort;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Extension(ordinal=2.147483437E9)
@Symbol(value={"securityConfig"})
public class GlobalSecurityConfiguration
extends ManagementLink
implements Describable<GlobalSecurityConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(GlobalSecurityConfiguration.class.getName());
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.222")
    public static final Predicate<Descriptor> FILTER = input -> input.getCategory() instanceof GlobalConfigurationCategory.Security;

    public SecurityRealm getSecurityRealm() {
        return Jenkins.get().getSecurityRealm();
    }

    public AuthorizationStrategy getAuthorizationStrategy() {
        return Jenkins.get().getAuthorizationStrategy();
    }

    public MarkupFormatter getMarkupFormatter() {
        return Jenkins.get().getMarkupFormatter();
    }

    public int getSlaveAgentPort() {
        return Jenkins.get().getSlaveAgentPort();
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isSlaveAgentPortEnforced() {
        return Jenkins.get().isSlaveAgentPortEnforced();
    }

    @NonNull
    public Set<String> getAgentProtocols() {
        return Jenkins.get().getAgentProtocols();
    }

    public boolean isDisableRememberMe() {
        return Jenkins.get().isDisableRememberMe();
    }

    @Override
    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.SECURITY;
    }

    @POST
    public synchronized void doConfigure(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        JSONObject json = req.getSubmittedForm();
        BulkChange bc = new BulkChange(Jenkins.get());
        try {
            boolean result = this.configure(req, json);
            LOGGER.log(Level.FINE, "security saved: " + result);
            Jenkins.get().save();
            FormApply.success(req.getContextPath() + "/manage").generateResponse(req, rsp, null);
        }
        catch (JSONException x) {
            LOGGER.warning(() -> "Bad JSON:\n" + json.toString(2));
            throw x;
        }
        finally {
            bc.commit();
        }
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        j.setDisableRememberMe(json.optBoolean("disableRememberMe", false));
        j.setSecurityRealm(Descriptor.bindJSON(req, SecurityRealm.class, json.getJSONObject("securityRealm")));
        j.setAuthorizationStrategy(Descriptor.bindJSON(req, AuthorizationStrategy.class, json.getJSONObject("authorizationStrategy")));
        if (json.has("markupFormatter")) {
            j.setMarkupFormatter((MarkupFormatter)req.bindJSON(MarkupFormatter.class, json.getJSONObject("markupFormatter")));
        } else {
            j.setMarkupFormatter(null);
        }
        if (!this.isSlaveAgentPortEnforced()) {
            try {
                j.setSlaveAgentPort(new ServerTcpPort(json.getJSONObject("slaveAgentPort")).getPort());
            }
            catch (IOException e) {
                throw new Descriptor.FormException(e, "slaveAgentPortType");
            }
        }
        TreeSet<String> agentProtocols = new TreeSet<String>();
        if (json.has("agentProtocol")) {
            Object protocols = json.get("agentProtocol");
            if (protocols instanceof JSONArray) {
                for (int i = 0; i < ((JSONArray)protocols).size(); ++i) {
                    agentProtocols.add(((JSONArray)protocols).getString(i));
                }
            } else {
                agentProtocols.add(protocols.toString());
            }
        }
        j.setAgentProtocols(agentProtocols);
        boolean result = true;
        for (Descriptor d : Functions.getSortedDescriptorsForGlobalConfigByDescriptor(FILTER)) {
            result &= this.configureDescriptor(req, json, d);
        }
        return result;
    }

    private boolean configureDescriptor(StaplerRequest2 req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        String name = d.getJsonSafeClassName();
        JSONObject js = json.has(name) ? json.getJSONObject(name) : new JSONObject();
        json.putAll((Map)js);
        return d.configure(req, js);
    }

    @Override
    public String getDisplayName() {
        return this.getDescriptor().getDisplayName();
    }

    @Override
    public String getDescription() {
        return Messages.GlobalSecurityConfiguration_Description();
    }

    @Override
    public String getIconFileName() {
        return "symbol-lock-closed";
    }

    @Override
    public String getUrlName() {
        return "configureSecurity";
    }

    @Override
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    @Override
    public Descriptor<GlobalSecurityConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    @Extension
    @Symbol(value={"security"})
    public static final class DescriptorImpl
    extends Descriptor<GlobalSecurityConfiguration> {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.GlobalSecurityConfiguration_DisplayName();
        }
    }
}

