/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.security.InputManipulationException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class XStream2SecurityUtils {
    public static void checkForCollectionDoSAttack(UnmarshallingContext context, long startNano) {
        Integer secondsUsed;
        int diff = (int)((System.nanoTime() - startNano) / 1000000000L);
        if (diff > 0 && (secondsUsed = (Integer)context.get((Object)"XStreamCollectionUpdateSeconds")) != null) {
            Integer limit = (Integer)context.get((Object)"XStreamCollectionUpdateLimit");
            if (limit == null) {
                throw new ConversionException("Missing limit for updating collections.");
            }
            int seconds = secondsUsed + diff;
            if (seconds > limit) {
                throw new InputManipulationException("Denial of Service attack assumed. Adding elements to collections or maps exceeds " + limit + " seconds.");
            }
            context.put((Object)"XStreamCollectionUpdateSeconds", (Object)seconds);
        }
    }
}

