/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.model.GlobalBuildDiscarderConfiguration;
import jenkins.model.GlobalBuildDiscarderStrategy;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class BackgroundGlobalBuildDiscarder
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(BackgroundGlobalBuildDiscarder.class.getName());

    public BackgroundGlobalBuildDiscarder() {
        super("Periodic background build discarder");
    }

    @Override
    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        for (Job job : Jenkins.get().allItems(Job.class)) {
            BackgroundGlobalBuildDiscarder.processJob(listener, job);
        }
    }

    public static void processJob(TaskListener listener, Job job) {
        BackgroundGlobalBuildDiscarder.processJob(listener, job, GlobalBuildDiscarderConfiguration.get().getConfiguredBuildDiscarders().stream());
    }

    public static void processJob(TaskListener listener, Job job, Stream<GlobalBuildDiscarderStrategy> strategies) {
        strategies.forEach(strategy -> {
            String displayName = strategy.getDescriptor().getDisplayName();
            if (strategy.isApplicable(job)) {
                try {
                    strategy.apply(job);
                }
                catch (Exception ex) {
                    listener.error("An exception occurred when executing " + displayName + ": " + ex.getMessage());
                    LOGGER.log(Level.WARNING, "An exception occurred when executing " + displayName, ex);
                }
            }
        });
    }

    @Override
    public long getRecurrencePeriod() {
        return 3600000L;
    }
}

