/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.PermalinkProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.util.AtomicFileWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class PeepholePermalink
extends PermalinkProjectAction.Permalink
implements Predicate<Run<?, ?>> {
    private static final Map<File, Map<String, Integer>> caches = new HashMap<File, Map<String, Integer>>();
    public static final PermalinkProjectAction.Permalink LAST_STABLE_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastStableBuild();
        }

        @Override
        public String getId() {
            return "lastStableBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult() == Result.SUCCESS;
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_SUCCESSFUL_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastSuccessfulBuild();
        }

        @Override
        public String getId() {
            return "lastSuccessfulBuild";
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult().isBetterOrEqualTo(Result.UNSTABLE);
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_FAILED_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastFailedBuild();
        }

        @Override
        public String getId() {
            return "lastFailedBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult() == Result.FAILURE;
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_UNSTABLE_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastUnstableBuild();
        }

        @Override
        public String getId() {
            return "lastUnstableBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult() == Result.UNSTABLE;
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_UNSUCCESSFUL_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastUnsuccessfulBuild();
        }

        @Override
        public String getId() {
            return "lastUnsuccessfulBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding() && run.getResult() != Result.SUCCESS;
        }
    };
    public static final PermalinkProjectAction.Permalink LAST_COMPLETED_BUILD = new PeepholePermalink(){

        @Override
        public String getDisplayName() {
            return Messages.Permalink_LastCompletedBuild();
        }

        @Override
        public String getId() {
            return "lastCompletedBuild";
        }

        @Override
        public boolean apply(Run<?, ?> run) {
            return !run.isBuilding();
        }
    };
    private static final int RESOLVES_TO_NONE = -1;
    private static final Logger LOGGER;

    public abstract boolean apply(Run<?, ?> var1);

    @Override
    public boolean test(Run<?, ?> run) {
        return this.apply(run);
    }

    @Deprecated
    protected File getPermalinkFile(Job<?, ?> job) {
        return new File(job.getBuildDir(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Run<?, ?> resolve(Job<?, ?> job) {
        Run<?, ?> b;
        int n;
        Map<String, Integer> cache;
        Map<String, Integer> map = cache = PeepholePermalink.cacheFor(job.getBuildDir());
        synchronized (map) {
            n = cache.getOrDefault(this.getId(), 0);
        }
        if (n == -1) {
            return null;
        }
        if (n > 0) {
            b = (Run<?, ?>)job.getBuildByNumber(n);
            if (b != null && this.apply(b)) {
                return b;
            }
        } else {
            b = null;
        }
        if (b == null) {
            b = (Run<?, ?>)job.getNearestOldBuild(n);
        }
        if (b == null) {
            b = (Run<?, ?>)job.getLastBuild();
        }
        b = this.find(b);
        this.updateCache(job, b);
        return b;
    }

    private Run<?, ?> find(Run<?, ?> b) {
        while (b != null && !this.apply(b)) {
            b = b.getPreviousBuild();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static Map<String, Integer> cacheFor(@NonNull File buildDir) {
        Map<File, Map<String, Integer>> map = caches;
        synchronized (map) {
            Map<String, Integer> cache = caches.get(buildDir);
            if (cache == null) {
                cache = PeepholePermalink.load(buildDir);
                caches.put(buildDir, cache);
            }
            return cache;
        }
    }

    @NonNull
    private static Map<String, Integer> load(@NonNull File buildDir) {
        TreeMap<String, Integer> cache = new TreeMap<String, Integer>();
        File storage = PeepholePermalink.storageFor(buildDir);
        if (storage.isFile()) {
            try (Stream<String> lines = Files.lines(storage.toPath(), StandardCharsets.UTF_8);){
                lines.forEach(line -> {
                    int idx = line.indexOf(32);
                    if (idx == -1) {
                        return;
                    }
                    try {
                        cache.put(line.substring(0, idx), Integer.parseInt(line.substring(idx + 1)));
                    }
                    catch (NumberFormatException x) {
                        LOGGER.log(Level.WARNING, "failed to read " + storage, x);
                    }
                });
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to read " + storage, x);
            }
            LOGGER.fine(() -> "loading from " + storage + ": " + cache);
        }
        return cache;
    }

    @NonNull
    static File storageFor(@NonNull File buildDir) {
        return new File(buildDir, "permalinks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCache(@NonNull Job<?, ?> job, @CheckForNull Run<?, ?> b) {
        Map<String, Integer> cache;
        File buildDir = job.getBuildDir();
        Map<String, Integer> map = cache = PeepholePermalink.cacheFor(buildDir);
        synchronized (map) {
            cache.put(this.getId(), b == null ? -1 : b.getNumber());
            File storage = PeepholePermalink.storageFor(buildDir);
            LOGGER.fine(() -> "saving to " + storage + ": " + cache);
            try (AtomicFileWriter cw = new AtomicFileWriter(storage);){
                try {
                    for (Map.Entry<String, Integer> entry : cache.entrySet()) {
                        cw.write(entry.getKey());
                        cw.write(32);
                        cw.write(Integer.toString(entry.getValue()));
                        cw.write(10);
                    }
                    cw.commit();
                }
                finally {
                    cw.abort();
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to update " + storage, x);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static void initialized() {
    }

    static {
        BUILTIN.add(LAST_STABLE_BUILD);
        BUILTIN.add(LAST_SUCCESSFUL_BUILD);
        BUILTIN.add(LAST_FAILED_BUILD);
        BUILTIN.add(LAST_UNSTABLE_BUILD);
        BUILTIN.add(LAST_UNSUCCESSFUL_BUILD);
        BUILTIN.add(LAST_COMPLETED_BUILD);
        PermalinkProjectAction.Permalink.LAST_STABLE_BUILD = LAST_STABLE_BUILD;
        PermalinkProjectAction.Permalink.LAST_SUCCESSFUL_BUILD = LAST_SUCCESSFUL_BUILD;
        PermalinkProjectAction.Permalink.LAST_FAILED_BUILD = LAST_FAILED_BUILD;
        PermalinkProjectAction.Permalink.LAST_UNSTABLE_BUILD = LAST_UNSTABLE_BUILD;
        PermalinkProjectAction.Permalink.LAST_UNSUCCESSFUL_BUILD = LAST_UNSUCCESSFUL_BUILD;
        PermalinkProjectAction.Permalink.LAST_COMPLETED_BUILD = LAST_COMPLETED_BUILD;
        LOGGER = Logger.getLogger(PeepholePermalink.class.getName());
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run<?, ?>> {
        @Override
        public void onDeleted(Run run) {
            Object j = run.getParent();
            for (PeepholePermalink pp : Util.filter(((Job)j).getPermalinks(), PeepholePermalink.class)) {
                if (pp.resolve((Job<?, ?>)j) != run) continue;
                Run<?, ?> r = pp.find((Run<?, ?>)run.getPreviousBuild());
                LOGGER.fine(() -> "Updating " + pp.getId() + " permalink from deleted " + run + " to " + (r == null ? -1 : r.getNumber()));
                pp.updateCache((Job<?, ?>)j, r);
            }
        }

        @Override
        public void onCompleted(Run<?, ?> run, @NonNull TaskListener listener) {
            Object j = run.getParent();
            for (PeepholePermalink pp : Util.filter(((Job)j).getPermalinks(), PeepholePermalink.class)) {
                Run<?, ?> cur;
                if (!pp.apply(run) || (cur = pp.resolve((Job<?, ?>)j)) != null && cur.getNumber() >= run.getNumber()) continue;
                LOGGER.fine(() -> "Updating " + pp.getId() + " permalink to completed " + run);
                pp.updateCache((Job<?, ?>)j, run);
            }
        }
    }
}

