/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.stapler;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.event.FilteredDispatchTriggerListener;
import org.kohsuke.stapler.event.FilteredDoActionTriggerListener;
import org.kohsuke.stapler.event.FilteredFieldTriggerListener;
import org.kohsuke.stapler.event.FilteredGetterTriggerListener;
import org.kohsuke.stapler.lang.FieldRef;

@Restricted(value={NoExternalUse.class})
public class StaplerFilteredActionListener
implements FilteredDoActionTriggerListener,
FilteredGetterTriggerListener,
FilteredFieldTriggerListener,
FilteredDispatchTriggerListener {
    private static final Logger LOGGER = Logger.getLogger(StaplerFilteredActionListener.class.getName());
    private static final String LOG_MESSAGE = "New Stapler routing rules result in the URL \"{0}\" no longer being allowed. If you consider it safe to use, add the following to the whitelist: \"{1}\". Learn more: https://www.jenkins.io/redirect/stapler-routing";

    public boolean onDoActionTrigger(Function f, StaplerRequest2 req, StaplerResponse2 rsp, Object node) {
        LOGGER.log(Level.FINER, LOG_MESSAGE, new Object[]{req.getPathInfo(), f.getSignature()});
        return false;
    }

    public boolean onGetterTrigger(Function f, StaplerRequest2 req, StaplerResponse2 rsp, Object node, String expression) {
        LOGGER.log(Level.FINER, LOG_MESSAGE, new Object[]{req.getPathInfo(), f.getSignature()});
        return false;
    }

    public boolean onFieldTrigger(FieldRef f, StaplerRequest2 req, StaplerResponse2 staplerResponse, Object node, String expression) {
        LOGGER.log(Level.FINER, LOG_MESSAGE, new Object[]{req.getPathInfo(), f.getSignature()});
        return false;
    }

    public boolean onDispatchTrigger(StaplerRequest2 req, StaplerResponse2 rsp, Object node, String viewName) {
        LOGGER.finer(() -> "New Stapler dispatch rules result in the URL \"" + req.getPathInfo() + "\" no longer being allowed. If you consider it safe to use, add the following to the whitelist: \"" + node.getClass().getName() + " " + viewName + "\". Learn more: https://www.jenkins.io/redirect/stapler-facet-restrictions");
        return false;
    }
}

