/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.stapler;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.stapler.RoutingDecisionProvider;
import jenkins.security.stapler.StaplerAccessibleType;
import jenkins.security.stapler.StaplerDispatchable;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.security.stapler.WebMethodConstants;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;
import org.kohsuke.stapler.lang.FieldRef;

@Restricted(value={NoExternalUse.class})
public class TypedFilter
implements FieldRef.Filter,
FunctionList.Filter {
    private static final Logger LOGGER = Logger.getLogger(TypedFilter.class.getName());
    private static final Map<Class<?>, Boolean> staplerCache = new HashMap();
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_TYPE_CHECK = SystemProperties.getBoolean(TypedFilter.class.getName() + ".skipTypeCheck");
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean PROHIBIT_STATIC_ACCESS = SystemProperties.getBoolean(TypedFilter.class.getName() + ".prohibitStaticAccess", true);

    private boolean isClassAcceptable(Class<?> clazz) {
        if (clazz.isArray()) {
            Class<?> elementClazz = clazz.getComponentType();
            if (this.isClassAcceptable(elementClazz)) {
                LOGGER.log(Level.FINE, "Class {0} is acceptable because it is an Array of acceptable elements {1}", new Object[]{clazz.getName(), elementClazz.getName()});
                return true;
            }
            LOGGER.log(Level.FINE, "Class {0} is not acceptable because it is an Array of non-acceptable elements {1}", new Object[]{clazz.getName(), elementClazz.getName()});
            return false;
        }
        return SKIP_TYPE_CHECK || TypedFilter.isStaplerRelevantCached(clazz);
    }

    private static boolean isStaplerRelevantCached(@NonNull Class<?> clazz) {
        if (staplerCache.containsKey(clazz)) {
            return staplerCache.get(clazz);
        }
        boolean ret = TypedFilter.isStaplerRelevant(clazz);
        staplerCache.put(clazz, ret);
        return ret;
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isStaplerRelevant(@NonNull Class<?> clazz) {
        return TypedFilter.isSpecificClassStaplerRelevant(clazz) || TypedFilter.isSuperTypesStaplerRelevant(clazz);
    }

    private static boolean isSuperTypesStaplerRelevant(@NonNull Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && TypedFilter.isStaplerRelevantCached(superclass)) {
            return true;
        }
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            if (!TypedFilter.isStaplerRelevantCached(interfaceClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpecificClassStaplerRelevant(@NonNull Class<?> clazz) {
        if (clazz.isAnnotationPresent(StaplerAccessibleType.class)) {
            return true;
        }
        if (StaplerProxy.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (StaplerFallback.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (StaplerOverridable.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Method m : clazz.getMethods()) {
            if (!TypedFilter.isRoutableMethod(m)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRoutableMethod(@NonNull Method m) {
        for (Annotation a : m.getDeclaredAnnotations()) {
            if (WebMethodConstants.WEB_METHOD_ANNOTATION_NAMES.contains(a.annotationType().getName())) {
                return true;
            }
            if (!a.annotationType().isAnnotationPresent(InterceptorAnnotation.class)) continue;
            return true;
        }
        Object[] objectArray = m.getParameterAnnotations();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation set;
            for (Annotation a : set = objectArray[i]) {
                if (!WebMethodConstants.WEB_METHOD_PARAMETER_ANNOTATION_NAMES.contains(a.annotationType().getName())) continue;
                return true;
            }
        }
        for (Class<?> parameterType : m.getParameterTypes()) {
            if (!WebMethodConstants.WEB_METHOD_PARAMETERS_NAMES.contains(parameterType.getName())) continue;
            return true;
        }
        return WebApp.getCurrent().getFilterForDoActions().keep((Function)new Function.InstanceFunction(m));
    }

    public boolean keep(@NonNull FieldRef fieldRef) {
        if (fieldRef.getAnnotation(StaplerNotDispatchable.class) != null) {
            return false;
        }
        if (fieldRef.getAnnotation(StaplerDispatchable.class) != null) {
            return true;
        }
        String signature = fieldRef.getSignature();
        ExtensionList<RoutingDecisionProvider> decisionProviders = ExtensionList.lookup(RoutingDecisionProvider.class);
        if (!decisionProviders.isEmpty()) {
            for (RoutingDecisionProvider provider : decisionProviders) {
                RoutingDecisionProvider.Decision fieldDecision = provider.decide(signature);
                if (fieldDecision == RoutingDecisionProvider.Decision.ACCEPTED) {
                    LOGGER.log(Level.CONFIG, "Field {0} is acceptable because it is whitelisted by {1}", new Object[]{signature, provider});
                    return true;
                }
                if (fieldDecision == RoutingDecisionProvider.Decision.REJECTED) {
                    LOGGER.log(Level.CONFIG, "Field {0} is not acceptable because it is blacklisted by {1}", new Object[]{signature, provider});
                    return false;
                }
                Class type = fieldRef.getReturnType();
                if (type == null) continue;
                String typeSignature = "class " + type.getCanonicalName();
                RoutingDecisionProvider.Decision fieldTypeDecision = provider.decide(typeSignature);
                if (fieldTypeDecision == RoutingDecisionProvider.Decision.ACCEPTED) {
                    LOGGER.log(Level.CONFIG, "Field {0} is acceptable because its type is whitelisted by {1}", new Object[]{signature, provider});
                    return true;
                }
                if (fieldTypeDecision != RoutingDecisionProvider.Decision.REJECTED) continue;
                LOGGER.log(Level.CONFIG, "Field {0} is not acceptable because its type is blacklisted by {1}", new Object[]{signature, provider});
                return false;
            }
        }
        if (PROHIBIT_STATIC_ACCESS && fieldRef.isStatic()) {
            return false;
        }
        Class returnType = fieldRef.getReturnType();
        boolean isOk = this.isClassAcceptable(returnType);
        LOGGER.log(Level.FINE, "Field analyzed: {0} => {1}", new Object[]{fieldRef.getName(), isOk});
        return isOk;
    }

    public boolean keep(@NonNull Function function) {
        Class[] parameterTypes;
        if (function.getAnnotation(StaplerNotDispatchable.class) != null) {
            return false;
        }
        if (function.getAnnotation(StaplerDispatchable.class) != null) {
            return true;
        }
        String signature = function.getSignature();
        ExtensionList<RoutingDecisionProvider> decision = ExtensionList.lookup(RoutingDecisionProvider.class);
        if (!decision.isEmpty()) {
            for (RoutingDecisionProvider provider : decision) {
                RoutingDecisionProvider.Decision methodDecision = provider.decide(signature);
                if (methodDecision == RoutingDecisionProvider.Decision.ACCEPTED) {
                    LOGGER.log(Level.CONFIG, "Function {0} is acceptable because it is whitelisted by {1}", new Object[]{signature, provider});
                    return true;
                }
                if (methodDecision == RoutingDecisionProvider.Decision.REJECTED) {
                    LOGGER.log(Level.CONFIG, "Function {0} is not acceptable because it is blacklisted by {1}", new Object[]{signature, provider});
                    return false;
                }
                Class type = function.getReturnType();
                if (type == null) continue;
                String typeSignature = "class " + type.getCanonicalName();
                RoutingDecisionProvider.Decision returnTypeDecision = provider.decide(typeSignature);
                if (returnTypeDecision == RoutingDecisionProvider.Decision.ACCEPTED) {
                    LOGGER.log(Level.CONFIG, "Function {0} is acceptable because its type is whitelisted by {1}", new Object[]{signature, provider});
                    return true;
                }
                if (returnTypeDecision != RoutingDecisionProvider.Decision.REJECTED) continue;
                LOGGER.log(Level.CONFIG, "Function {0} is not acceptable because its type is blacklisted by {1}", new Object[]{signature, provider});
                return false;
            }
        }
        if (PROHIBIT_STATIC_ACCESS && function.isStatic()) {
            return false;
        }
        if (function.getName().equals("getDynamic") && (parameterTypes = function.getParameterTypes()).length > 0 && parameterTypes[0] == String.class) {
            return false;
        }
        if (function.getName().equals("getStaplerFallback") && function.getParameterTypes().length == 0) {
            return false;
        }
        if (function.getName().equals("getTarget") && function.getParameterTypes().length == 0) {
            return false;
        }
        Class returnType = function.getReturnType();
        boolean isOk = this.isClassAcceptable(returnType);
        LOGGER.log(Level.FINE, "Function analyzed: {0} => {1}", new Object[]{signature, isOk});
        return isOk;
    }
}

