/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import java.security.SecureRandom;
import jenkins.security.HMACConfidentialKey;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;

public abstract class JnlpAgentReceiver
extends JnlpConnectionStateListener
implements ExtensionPoint {
    public static final HMACConfidentialKey SLAVE_SECRET = new HMACConfidentialKey(JnlpSlaveAgentProtocol.class, "secret");
    private static final SecureRandom secureRandom = new SecureRandom();
    public static final JnlpClientDatabase DATABASE = new JnlpAgentDatabase();

    public static ExtensionList<JnlpAgentReceiver> all() {
        return ExtensionList.lookup(JnlpAgentReceiver.class);
    }

    public static boolean exists(String clientName) {
        for (JnlpAgentReceiver receiver : JnlpAgentReceiver.all()) {
            if (!receiver.owns(clientName)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean owns(String var1);

    public static String generateCookie() {
        byte[] cookie = new byte[32];
        secureRandom.nextBytes(cookie);
        return Util.toHexString(cookie);
    }

    private static class JnlpAgentDatabase
    extends JnlpClientDatabase {
        private JnlpAgentDatabase() {
        }

        public boolean exists(String clientName) {
            return JnlpAgentReceiver.exists(clientName);
        }

        public String getSecretOf(@NonNull String clientName) {
            return SLAVE_SECRET.mac(clientName);
        }
    }
}

