/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.remoting.Capability;
import hudson.remoting.Command;
import hudson.remoting.FlightRecorderInputStream;
import hudson.remoting.SynchronousCommandTransport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;

final class ClassicCommandTransport
extends SynchronousCommandTransport {
    private final ObjectInputStream ois;
    private final ObjectOutputStream oos;
    private final Capability remoteCapability;
    @Nullable
    private final FlightRecorderInputStream rawIn;
    private final OutputStream rawOut;

    ClassicCommandTransport(ObjectInputStream ois, ObjectOutputStream oos, @CheckForNull FlightRecorderInputStream rawIn, OutputStream rawOut, Capability remoteCapability) {
        this.ois = ois;
        this.oos = oos;
        this.rawIn = rawIn;
        this.rawOut = rawOut;
        this.remoteCapability = remoteCapability;
    }

    @Override
    public Capability getRemoteCapability() throws IOException {
        return this.remoteCapability;
    }

    @Override
    public final void write(Command cmd, boolean last) throws IOException {
        cmd.writeTo(this.channel, this.oos);
        this.oos.flush();
        if (!last) {
            this.oos.reset();
        }
    }

    @Override
    public void closeWrite() throws IOException {
        this.oos.close();
    }

    @Override
    public final Command read() throws IOException, ClassNotFoundException {
        try {
            Command cmd = Command.readFromObjectStream(this.channel, this.ois);
            if (this.rawIn != null) {
                this.rawIn.clear();
            }
            return cmd;
        }
        catch (StreamCorruptedException | RuntimeException e) {
            throw this.diagnoseStreamCorruption(e);
        }
    }

    private StreamCorruptedException diagnoseStreamCorruption(Exception e) {
        if (this.rawIn == null) {
            if (e instanceof StreamCorruptedException) {
                return (StreamCorruptedException)e;
            }
            return (StreamCorruptedException)new StreamCorruptedException().initCause(e);
        }
        return this.rawIn.analyzeCrash(e, (this.channel != null ? this.channel : this).toString());
    }

    @Override
    public void closeRead() throws IOException {
        this.ois.close();
    }

    @Override
    OutputStream getUnderlyingStream() {
        return this.rawOut;
    }
}

