/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.localizer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jvnet.localizer.LocaleProvider;
import org.jvnet.localizer.ResourceProvider;

public final class ResourceBundleHolder
implements Serializable {
    private static final Map<Class<?>, WeakReference<ResourceBundleHolder>> cache = new WeakHashMap();
    private final transient Map<Locale, ResourceBundle> bundles = new ConcurrentHashMap<Locale, ResourceBundle>();
    public final Class<?> owner;
    private static final Locale ROOT = new Locale("");

    public static synchronized ResourceBundleHolder get(Class<?> clazz) {
        ResourceBundleHolder rbh;
        WeakReference<ResourceBundleHolder> entry = cache.get(clazz);
        if (entry != null && (rbh = (ResourceBundleHolder)entry.get()) != null) {
            return rbh;
        }
        rbh = new ResourceBundleHolder(clazz);
        cache.put(clazz, new WeakReference<ResourceBundleHolder>(rbh));
        return rbh;
    }

    public ResourceBundleHolder(Class<?> owner) {
        this.owner = owner;
    }

    private Object readResolve() throws ObjectStreamException {
        return ResourceBundleHolder.get(this.owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle get(Locale locale) {
        ResourceBundle rb = this.bundles.get(locale);
        if (rb != null) {
            return rb;
        }
        ResourceBundleHolder resourceBundleHolder = this;
        synchronized (resourceBundleHolder) {
            rb = this.bundles.get(locale);
            if (rb != null) {
                return rb;
            }
            Locale next = this.getBaseLocale(locale);
            String s = locale.toString();
            ResourceBundleImpl bundle = null;
            String basename = this.owner.getSimpleName() + (s.length() > 0 ? '_' + s : "");
            bundle = this.getFromProperties(basename);
            if (bundle == null) {
                bundle = this.getFromXml(basename);
            }
            if (bundle != null) {
                rb = bundle;
                if (next != null) {
                    bundle.setParent(this.get(next));
                }
                this.bundles.put(locale, bundle);
            } else if (next != null) {
                rb = this.get(next);
                this.bundles.put(locale, rb);
            } else {
                throw new MissingResourceException("No resource was found for " + this.owner.getName(), this.owner.getName(), null);
            }
        }
        return rb;
    }

    protected ResourceBundleImpl getFromProperties(String basename) {
        URL res = ResourceProvider.findResource(basename + ".properties", this.owner);
        if (res == null) {
            return null;
        }
        try {
            URLConnection uc = res.openConnection();
            uc.setUseCaches(false);
            InputStream is = uc.getInputStream();
            ResourceBundleImpl bundle = new ResourceBundleImpl(is);
            is.close();
            return bundle;
        }
        catch (IOException e) {
            MissingResourceException x = new MissingResourceException("Unable to load resource " + res, this.owner.getName(), null);
            x.initCause(e);
            throw x;
        }
    }

    protected ResourceBundleImpl getFromXml(String basename) {
        URL res = ResourceProvider.findResource(basename + ".properties.xml", this.owner);
        if (res == null) {
            return null;
        }
        try {
            URLConnection uc = res.openConnection();
            uc.setUseCaches(false);
            InputStream is = uc.getInputStream();
            Properties props = new Properties();
            props.loadFromXML(is);
            is.close();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            props.store(bout, "");
            bout.close();
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ResourceBundleImpl bundle = new ResourceBundleImpl(bin);
            bin.close();
            return bundle;
        }
        catch (IOException e) {
            MissingResourceException x = new MissingResourceException("Unable to load resource " + res, this.owner.getName(), null);
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.owner.getName() + "]";
    }

    private Locale getBaseLocale(Locale l) {
        if (l.getVariant().length() > 0) {
            return new Locale(l.getLanguage(), l.getCountry());
        }
        if (l.getCountry().length() > 0) {
            return new Locale(l.getLanguage());
        }
        if (l.getLanguage().length() > 0) {
            return ROOT;
        }
        return null;
    }

    public String format(String key, Object ... args) {
        return MessageFormat.format(this.get(LocaleProvider.getLocale()).getString(key), args);
    }

    public static synchronized void clearCache() {
        cache.clear();
    }

    static class ResourceBundleImpl
    extends PropertyResourceBundle {
        ResourceBundleImpl(InputStream stream) throws IOException {
            super(stream);
        }

        @Override
        protected void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }
    }
}

