/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.DomainSpecificationDescriptor;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.cloudbees.plugins.credentials.domains.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.kohsuke.stapler.DataBoundConstructor;

public class HostnamePortSpecification
extends DomainSpecification {
    @CheckForNull
    private final String includes;
    @CheckForNull
    private final String excludes;

    @DataBoundConstructor
    public HostnamePortSpecification(@CheckForNull String includes, @CheckForNull String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    @CheckForNull
    public String getIncludes() {
        return this.includes;
    }

    @CheckForNull
    public String getExcludes() {
        return this.excludes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NonNull
    public DomainSpecification.Result test(@NonNull DomainRequirement requirement) {
        if (requirement instanceof HostnamePortRequirement) {
            String hostPort = ((HostnamePortRequirement)requirement).getHostname() + ":" + ((HostnamePortRequirement)requirement).getPort();
            if (this.includes != null) {
                boolean isInclude = false;
                for (String string : this.includes.split("[,\\n ]")) {
                    void var7_12;
                    String string2 = Util.fixEmptyAndTrim((String)string);
                    if (string2 == null) continue;
                    if (string2.indexOf(58) == -1) {
                        String string3 = string2 + ":*";
                    }
                    if (!FilenameUtils.wildcardMatch((String)hostPort, (String)var7_12, (IOCase)IOCase.INSENSITIVE)) continue;
                    isInclude = true;
                    break;
                }
                if (!isInclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            if (this.excludes != null) {
                boolean isExclude = false;
                for (String string : this.excludes.split("[,\\n ]")) {
                    void var7_20;
                    String string4 = Util.fixEmptyAndTrim((String)string);
                    if (string4 == null) continue;
                    if (string4.indexOf(58) == -1) {
                        String string5 = string4 + ":*";
                    }
                    if (!FilenameUtils.wildcardMatch((String)hostPort, (String)var7_20, (IOCase)IOCase.INSENSITIVE)) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
        } else if (requirement instanceof HostnameRequirement) {
            int index;
            String hostname = ((HostnameRequirement)requirement).getHostname();
            if (this.includes != null) {
                boolean isInclude = false;
                for (String string : this.includes.split("[,\\n ]")) {
                    void var7_21;
                    String string6 = Util.fixEmptyAndTrim((String)string);
                    if (string6 == null) continue;
                    index = string6.indexOf(":");
                    if (index != -1) {
                        String string7 = string6.substring(0, index);
                    }
                    if (!FilenameUtils.wildcardMatch((String)hostname, (String)var7_21, (IOCase)IOCase.INSENSITIVE)) continue;
                    isInclude = true;
                    break;
                }
                if (!isInclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            if (this.excludes != null) {
                boolean isExclude = false;
                for (String string : this.excludes.split("[,\\n ]")) {
                    void var7_29;
                    String string8 = Util.fixEmptyAndTrim((String)string);
                    if (string8 == null) continue;
                    index = string8.indexOf(":");
                    if (index != -1) {
                        String string9 = string8.substring(0, index);
                    }
                    if (!FilenameUtils.wildcardMatch((String)hostname, (String)var7_29, (IOCase)IOCase.INSENSITIVE)) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
        }
        return DomainSpecification.Result.UNKNOWN;
    }

    @Extension
    public static class DescriptorImpl
    extends DomainSpecificationDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.HostnamePortSpecification_DisplayName();
        }
    }
}

