/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.DomainSpecificationDescriptor;
import com.cloudbees.plugins.credentials.domains.Messages;
import com.cloudbees.plugins.credentials.domains.PathRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.util.AntPathMatcher;

public class PathSpecification
extends DomainSpecification {
    @CheckForNull
    private final String includes;
    @CheckForNull
    private final String excludes;
    private final boolean caseSensitive;

    @DataBoundConstructor
    public PathSpecification(@CheckForNull String includes, @CheckForNull String excludes, boolean caseSensitive) {
        this.includes = includes;
        this.excludes = excludes;
        this.caseSensitive = caseSensitive;
    }

    @CheckForNull
    public String getIncludes() {
        return this.includes;
    }

    @CheckForNull
    public String getExcludes() {
        return this.excludes;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    @NonNull
    public DomainSpecification.Result test(@NonNull DomainRequirement requirement) {
        if (requirement instanceof PathRequirement) {
            AntPathMatcher matcher = new AntPathMatcher();
            String path = ((PathRequirement)requirement).getPath();
            if (!this.caseSensitive) {
                path = path.toLowerCase();
            }
            if (this.includes != null) {
                boolean isInclude = false;
                for (String include : this.includes.split(",")) {
                    if ((include = Util.fixEmptyAndTrim((String)include)) == null) continue;
                    if (!this.caseSensitive) {
                        include = include.toLowerCase();
                    }
                    if (!(matcher.isPattern(include) ? matcher.match(include, path) : StringUtils.equals((String)include, (String)path))) continue;
                    isInclude = true;
                    break;
                }
                if (!isInclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            if (this.excludes != null) {
                boolean isExclude = false;
                for (String exclude : this.excludes.split(",")) {
                    if ((exclude = Util.fixEmptyAndTrim((String)exclude)) == null) continue;
                    if (!this.caseSensitive) {
                        exclude = exclude.toLowerCase();
                    }
                    if (!(matcher.isPattern(exclude) ? matcher.match(exclude, path) : StringUtils.equals((String)exclude, (String)path))) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            return DomainSpecification.Result.PARTIAL;
        }
        return DomainSpecification.Result.UNKNOWN;
    }

    @Extension
    public static class DescriptorImpl
    extends DomainSpecificationDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.PathSpecification_DisplayName();
        }
    }
}

