/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordEntry;
import org.jenkinsci.plugins.envinject.Messages;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributorDescriptor;
import org.jenkinsci.plugins.envinject.service.EnvInjectContributorManagement;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class EnvInjectJobProperty<T extends Job<?, ?>>
extends JobProperty<T> {
    @CheckForNull
    private EnvInjectJobPropertyInfo info = new EnvInjectJobPropertyInfo();
    private boolean on;
    private boolean keepJenkinsSystemVariables;
    private boolean keepBuildVariables;
    private boolean overrideBuildParameters;
    @GuardedBy(value="this")
    @CheckForNull
    private EnvInjectJobPropertyContributor[] contributors;
    @GuardedBy(value="this")
    @CheckForNull
    private transient EnvInjectJobPropertyContributor[] contributorsComputed;
    @Deprecated
    private transient boolean injectGlobalPasswords;
    @Deprecated
    private transient EnvInjectPasswordEntry[] passwordEntries;
    @Deprecated
    private transient boolean keepSystemVariables;

    @DataBoundConstructor
    public EnvInjectJobProperty(EnvInjectJobPropertyInfo info) {
        this.info = info;
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public EnvInjectJobProperty() {
    }

    @CheckForNull
    public EnvInjectJobPropertyInfo getInfo() {
        return this.info;
    }

    public boolean isOn() {
        return this.on;
    }

    public boolean isKeepJenkinsSystemVariables() {
        return this.keepJenkinsSystemVariables;
    }

    public boolean isKeepBuildVariables() {
        return this.keepBuildVariables;
    }

    public boolean isOverrideBuildParameters() {
        return this.overrideBuildParameters;
    }

    @NonNull
    public synchronized EnvInjectJobPropertyContributor[] getContributors() {
        if (this.contributorsComputed == null) {
            try {
                this.contributorsComputed = this.computeEnvInjectContributors();
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
            }
            this.contributors = this.contributorsComputed;
        }
        return this.contributors != null ? Arrays.copyOf(this.contributors, this.contributors.length) : new EnvInjectJobPropertyContributor[]{};
    }

    @NonNull
    private synchronized EnvInjectJobPropertyContributor[] computeEnvInjectContributors() throws EnvInjectException {
        DescriptorExtensionList<EnvInjectJobPropertyContributor, EnvInjectJobPropertyContributorDescriptor> descriptors = EnvInjectJobPropertyContributor.all();
        if (this.contributors != null && this.contributors.length == descriptors.size()) {
            return this.contributors;
        }
        EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
        EnvInjectJobPropertyContributor[] contributorsInstance = envInjectContributorManagement.getNewContributorsInstance();
        if (this.contributors == null || this.contributors.length == 0) {
            return contributorsInstance;
        }
        ArrayList<EnvInjectJobPropertyContributor> result = new ArrayList<EnvInjectJobPropertyContributor>();
        for (EnvInjectJobPropertyContributor contributor1 : contributorsInstance) {
            for (EnvInjectJobPropertyContributor contributor2 : this.contributors) {
                if (contributor1.getDescriptor().getClass() == contributor2.getDescriptor().getClass()) {
                    result.add(contributor2);
                    continue;
                }
                result.add(contributor1);
            }
        }
        return result.toArray(new EnvInjectJobPropertyContributor[result.size()]);
    }

    @Deprecated
    public void setInfo(@CheckForNull EnvInjectJobPropertyInfo info) {
        this.info = info;
    }

    @DataBoundSetter
    public void setOn(boolean on) {
        this.on = on;
    }

    @DataBoundSetter
    public void setKeepJenkinsSystemVariables(boolean keepJenkinsSystemVariables) {
        this.keepJenkinsSystemVariables = keepJenkinsSystemVariables;
    }

    @DataBoundSetter
    public void setKeepBuildVariables(boolean keepBuildVariables) {
        this.keepBuildVariables = keepBuildVariables;
    }

    @DataBoundSetter
    public void setOverrideBuildParameters(boolean overrideBuildParameters) {
        this.overrideBuildParameters = overrideBuildParameters;
    }

    @DataBoundSetter
    public synchronized void setContributors(EnvInjectJobPropertyContributor[] jobPropertyContributors) {
        this.contributors = jobPropertyContributors;
    }

    @Deprecated
    public boolean isInjectGlobalPasswords() {
        return this.injectGlobalPasswords;
    }

    @Deprecated
    @CheckForNull
    public EnvInjectPasswordEntry[] getPasswordEntries() {
        return this.passwordEntries;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "[Environment Inject] -" + Messages.envinject_set_displayName();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/envinject/help.html";
        }

        public EnvInjectJobProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.optBoolean("on")) {
                return (EnvInjectJobProperty)super.newInstance(req, formData);
            }
            return null;
        }

        @NonNull
        public DescriptorExtensionList<EnvInjectJobPropertyContributor, EnvInjectJobPropertyContributorDescriptor> getEnvInjectContributors() {
            return EnvInjectJobPropertyContributor.all();
        }

        @CheckForNull
        public EnvInjectJobPropertyContributor[] getContributorsInstance() {
            EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
            try {
                return envInjectContributorManagement.getNewContributorsInstance();
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean isEnvInjectContributionActivated() {
            EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
            return envInjectContributorManagement.isEnvInjectContributionActivated();
        }
    }
}

