/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Run;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.envinjectapi.util.EnvVarsResolver;

public class BuildCauseRetriever {
    private static final int MAX_UPSTREAM_DEPTH = 10;
    public static final String ENV_CAUSE = "BUILD_CAUSE";
    public static final String ENV_ROOT_CAUSE = "ROOT_BUILD_CAUSE";

    @Deprecated
    @NonNull
    public Map<String, String> getTriggeredCause(@NonNull AbstractBuild<?, ?> build) {
        return EnvVarsResolver.getCauseEnvVars(build);
    }

    @NonNull
    public Map<String, String> getTriggeredCause(@NonNull Run<?, ?> run) {
        CauseAction causeAction = (CauseAction)run.getAction(CauseAction.class);
        HashMap<String, String> env = new HashMap<String, String>();
        ArrayList<String> directCauseNames = new ArrayList<String>();
        LinkedHashSet<String> rootCauseNames = new LinkedHashSet<String>();
        if (causeAction != null) {
            List buildCauses = causeAction.getCauses();
            for (Cause cause : buildCauses) {
                directCauseNames.add(BuildCauseRetriever.getTriggerName(cause));
                BuildCauseRetriever.insertRootCauseNames(rootCauseNames, cause, 0);
            }
        } else {
            directCauseNames.add("UNKNOWN");
            rootCauseNames.add("UNKNOWN");
        }
        env.putAll(BuildCauseRetriever.buildCauseEnvironmentVariables(ENV_CAUSE, directCauseNames));
        env.putAll(BuildCauseRetriever.buildCauseEnvironmentVariables(ENV_ROOT_CAUSE, rootCauseNames));
        return env;
    }

    private static void insertRootCauseNames(@NonNull Set<String> causeNamesTarget, @CheckForNull Cause cause, int depth) {
        if (cause instanceof Cause.UpstreamCause) {
            if (depth == 10) {
                causeNamesTarget.add("DEEPLYNESTEDCAUSES");
            } else {
                Cause.UpstreamCause c = (Cause.UpstreamCause)cause;
                List upstreamCauses = c.getUpstreamCauses();
                for (Cause upstreamCause : upstreamCauses) {
                    BuildCauseRetriever.insertRootCauseNames(causeNamesTarget, upstreamCause, depth + 1);
                }
            }
        } else {
            causeNamesTarget.add(BuildCauseRetriever.getTriggerName(cause));
        }
    }

    private static Map<String, String> buildCauseEnvironmentVariables(String envBase, Collection<String> causeNames) {
        HashMap<String, String> triggerVars = new HashMap<String, String>();
        ArrayList<String> nonEmptyNames = new ArrayList<String>();
        for (String name : causeNames) {
            if (!StringUtils.isNotBlank((String)name)) continue;
            triggerVars.put(Joiner.on((String)"_").join((Object)envBase, (Object)name, new Object[0]), "true");
            nonEmptyNames.add(name);
        }
        triggerVars.put(envBase, Joiner.on((String)",").join(nonEmptyNames));
        return triggerVars;
    }

    @CheckForNull
    private static String getTriggerName(Cause cause) {
        if (SCMTrigger.SCMTriggerCause.class.isInstance(cause)) {
            return "SCMTRIGGER";
        }
        if (TimerTrigger.TimerTriggerCause.class.isInstance(cause)) {
            return "TIMERTRIGGER";
        }
        if (Cause.UserIdCause.class.isInstance(cause)) {
            return "MANUALTRIGGER";
        }
        if (Cause.UserCause.class.isInstance(cause)) {
            return "MANUALTRIGGER";
        }
        if (Cause.UpstreamCause.class.isInstance(cause)) {
            return "UPSTREAMTRIGGER";
        }
        if (cause != null) {
            return cause.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
        }
        return null;
    }
}

