/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import groovy.lang.Binding;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectPluginConfiguration;
import org.jenkinsci.plugins.envinject.service.EnvInjectScriptExecutor;
import org.jenkinsci.plugins.envinject.service.PropertiesVariablesRetriever;
import org.jenkinsci.plugins.envinject.util.EnvInjectExceptionFormatter;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class EnvInjectEnvVars
implements Serializable {
    EnvInjectLogger logger;

    public EnvInjectEnvVars(@NonNull EnvInjectLogger logger) {
        this.logger = logger;
    }

    public Map<String, String> getEnvVarsPropertiesJobProperty(@NonNull FilePath rootPath, @NonNull EnvInjectLogger logger, boolean loadFilesFromMaster, @CheckForNull String propertiesFilePath, @CheckForNull Map<String, String> propertiesContent, @NonNull Map<String, String> infraEnvVarsMaster, @NonNull Map<String, String> infraEnvVarsNode) throws EnvInjectException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        try {
            if (loadFilesFromMaster) {
                if (!EnvInjectPluginConfiguration.getOrFail().isEnableLoadingFromMaster()) {
                    throw EnvInjectExceptionFormatter.forProhibitedLoadFromMaster(propertiesFilePath);
                }
                resultMap.putAll((Map)Jenkins.get().getRootPath().act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, infraEnvVarsMaster, logger)));
            } else {
                resultMap.putAll((Map)rootPath.act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, infraEnvVarsNode, logger)));
            }
        }
        catch (IOException e) {
            throw new EnvInjectException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new EnvInjectException((Throwable)e);
        }
        return resultMap;
    }

    @NonNull
    public Map<String, String> getEnvVarsFileProperty(@NonNull FilePath rootPath, @NonNull EnvInjectLogger logger, @CheckForNull String propertiesFilePath, @CheckForNull Map<String, String> propertiesContent, @NonNull Map<String, String> currentEnvVars) throws EnvInjectException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        try {
            resultMap.putAll((Map)rootPath.act((FilePath.FileCallable)new PropertiesVariablesRetriever(propertiesFilePath, propertiesContent, currentEnvVars, logger)));
        }
        catch (IOException e) {
            throw new EnvInjectException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new EnvInjectException((Throwable)e);
        }
        return resultMap;
    }

    public int executeScript(boolean loadFromMaster, @CheckForNull String scriptContent, @CheckForNull FilePath scriptExecutionRoot, @CheckForNull String scriptFilePath, @NonNull Map<String, String> infraEnvVarsMaster, @NonNull Map<String, String> infraEnvVarsNode, @NonNull Launcher launcher, @NonNull BuildListener listener) throws EnvInjectException {
        if (scriptContent == null && scriptFilePath == null) {
            return 0;
        }
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        EnvInjectScriptExecutor scriptExecutor = new EnvInjectScriptExecutor(launcher, logger);
        HashMap<String, String> scriptExecutionEnvVars = new HashMap<String, String>();
        scriptExecutionEnvVars.putAll(infraEnvVarsNode);
        if (loadFromMaster) {
            if (!EnvInjectPluginConfiguration.getOrFail().isEnableLoadingFromMaster()) {
                throw EnvInjectExceptionFormatter.forProhibitedLoadFromMaster(scriptFilePath);
            }
            HashMap<String, String> scriptPathExecutionEnvVars = new HashMap<String, String>();
            scriptPathExecutionEnvVars.putAll(infraEnvVarsMaster);
            if (scriptFilePath != null) {
                String scriptFilePathResolved = Util.replaceMacro((String)scriptFilePath, scriptPathExecutionEnvVars);
                String content = null;
                try {
                    content = FileUtils.readFileToString((File)new File(scriptFilePathResolved));
                }
                catch (IOException e) {
                    throw new EnvInjectException("Failed to load script from controller", (Throwable)e);
                }
                return scriptExecutor.executeScriptSection(scriptExecutionRoot, null, content, scriptPathExecutionEnvVars, scriptExecutionEnvVars);
            }
            return scriptExecutor.executeScriptSection(scriptExecutionRoot, null, scriptContent, scriptPathExecutionEnvVars, scriptExecutionEnvVars);
        }
        return scriptExecutor.executeScriptSection(scriptExecutionRoot, scriptFilePath, scriptContent, scriptExecutionEnvVars, scriptExecutionEnvVars);
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.0")
    public Map<String, String> executeAndGetMapGroovyScript(@NonNull EnvInjectLogger logger, @CheckForNull String scriptContent, @NonNull Map<String, String> envVars) throws EnvInjectException, AbortException {
        if (scriptContent == null) {
            return new HashMap<String, String>();
        }
        if (scriptContent.trim().length() == 0) {
            return new HashMap<String, String>();
        }
        logger.info("Using the deprecated API (EnvInjectEnvVars#executeAndGetMapGroovyScript()). Starting from EnvInject 2.0 the call may require the script approval for a non-admin user.");
        SecureGroovyScript script = new SecureGroovyScript(scriptContent, false, null);
        return this.executeGroovyScript(logger, script, envVars);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public Map<String, String> executeGroovyScript(@NonNull EnvInjectLogger logger, @CheckForNull SecureGroovyScript script, @NonNull Map<String, String> envVars) throws EnvInjectException, AbortException {
        Object groovyResult;
        Jenkins jenkins = Jenkins.get();
        if (script == null) {
            return new HashMap<String, String>();
        }
        if (script.getScript().trim().length() == 0) {
            return new HashMap<String, String>();
        }
        logger.info("Evaluating the Groovy script content");
        Binding binding = new Binding();
        String jobName = envVars.get("JOB_NAME");
        if (jobName != null) {
            Item job = jenkins.getItemByFullName(jobName);
            binding.setProperty("currentJob", (Object)job);
            String string = envVars.get("BUILD_NUMBER");
            if (string != null && job instanceof AbstractProject) {
                AbstractBuild r = ((AbstractProject)job).getBuild(string);
                binding.setProperty("currentBuild", (Object)r);
            }
        }
        for (Map.Entry entry : envVars.entrySet()) {
            binding.setVariable((String)entry.getKey(), entry.getValue());
        }
        binding.setVariable("out", (Object)logger.getListener().getLogger());
        binding.setVariable("currentListener", (Object)logger.getListener());
        try {
            groovyResult = script.evaluate(jenkins.getPluginManager().uberClassLoader, binding);
        }
        catch (Exception exception) {
            throw new EnvInjectException("Failed to evaluate the script", (Throwable)exception);
        }
        if (groovyResult != null && !(groovyResult instanceof Map)) {
            throw new AbortException("The evaluated Groovy script must return a Map object.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (groovyResult == null) {
            return hashMap;
        }
        Map mapResult = (Map)groovyResult;
        for (Map.Entry entry : mapResult.entrySet()) {
            hashMap.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return hashMap;
    }

    public int executeScript(@CheckForNull String scriptContent, @CheckForNull FilePath scriptExecutionRoot, @CheckForNull String scriptFilePath, @NonNull Map<String, String> envVars, @NonNull Launcher launcher, @NonNull BuildListener listener) throws EnvInjectException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        EnvInjectScriptExecutor scriptExecutor = new EnvInjectScriptExecutor(launcher, logger);
        return scriptExecutor.executeScriptSection(scriptExecutionRoot, scriptFilePath, scriptContent, envVars, envVars);
    }

    @NonNull
    public Map<String, String> getMergedVariables(@NonNull Map<String, String> infraEnvVars, @NonNull Map<String, String> propertiesEnvVars) {
        return this.getMergedVariables(infraEnvVars, propertiesEnvVars, new HashMap<String, String>(), new HashMap<String, String>());
    }

    @NonNull
    public Map<String, String> getMergedVariables(@NonNull Map<String, String> infraEnvVars, @NonNull Map<String, String> propertiesEnvVars, @NonNull Map<String, String> groovyMapEnvVars, @NonNull Map<String, String> contribEnvVars) {
        this.resolveVars(infraEnvVars, infraEnvVars);
        this.resolveVars(propertiesEnvVars, infraEnvVars);
        this.resolveVars(propertiesEnvVars, groovyMapEnvVars);
        this.resolveVars(propertiesEnvVars, contribEnvVars);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>(infraEnvVars);
        variables.putAll(groovyMapEnvVars);
        variables.putAll(contribEnvVars);
        variables.putAll(propertiesEnvVars);
        return variables;
    }

    public void resolveVars(@NonNull Map<String, String> variables, @NonNull Map<String, String> env) {
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String value = Util.replaceMacro((String)entry.getValue(), env);
            entry.setValue(value);
        }
        boolean stopToResolveVars = false;
        int nbUnresolvedVar = 0;
        while (!stopToResolveVars) {
            int previousNbUnresolvedVar = nbUnresolvedVar;
            nbUnresolvedVar = 0;
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                HashMap<String, String> resolveVariables = new HashMap<String, String>(variables);
                resolveVariables.remove(entry.getKey());
                String value = Util.replaceMacro((String)entry.getValue(), resolveVariables);
                entry.setValue(value);
                if (!this.isUnresolvedVar(value)) continue;
                ++nbUnresolvedVar;
            }
            if (previousNbUnresolvedVar != nbUnresolvedVar) continue;
            stopToResolveVars = true;
        }
    }

    @NonNull
    public Map<String, String> removeUnsetVars(@NonNull Map<String, String> envVars) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            String value = entry.getValue();
            if (!this.isUnresolvedVar(value = this.removeUnsetVars(value))) {
                result.put(entry.getKey(), this.removeEscapeDollar(value));
                continue;
            }
            this.logger.info(String.format("Unset unresolved '%s' variable.", entry.getKey()));
        }
        return result;
    }

    @Nullable
    private String removeUnsetVars(@CheckForNull String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        if (!value.contains("$") || value.contains("\\$")) {
            return value;
        }
        return Util.replaceMacro((String)value, (VariableResolver)new VariableResolver<String>(){

            public String resolve(String name) {
                return "";
            }
        });
    }

    private boolean isUnresolvedVar(@CheckForNull String value) {
        if (value == null) {
            return true;
        }
        if (value.trim().length() == 0) {
            return false;
        }
        return value.contains("$") && !value.contains("\\$");
    }

    private String removeEscapeDollar(@CheckForNull String value) {
        if (value == null) {
            return null;
        }
        if ('/' == File.separatorChar) {
            return value.replace("\\$", "$");
        }
        return value;
    }
}

