/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionComponent;
import hudson.ExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.Publisher;
import hudson.util.AdaptedIterator;
import hudson.util.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ExtensionComponentSet;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.Stapler;

public class DescriptorExtensionList<T extends Describable<T>, D extends Descriptor<T>>
extends ExtensionList<D> {
    private final Class<T> describableType;
    private static final Map<Class, CopyOnWriteArrayList<ExtensionComponent<Descriptor>>> legacyDescriptors = new ConcurrentHashMap<Class, CopyOnWriteArrayList<ExtensionComponent<Descriptor>>>();
    private static final Logger LOGGER = Logger.getLogger(DescriptorExtensionList.class.getName());

    public static <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> createDescriptorList(Jenkins jenkins, Class<T> describableType) {
        if (describableType == Publisher.class) {
            return new Publisher.DescriptorExtensionListImpl(jenkins);
        }
        return new DescriptorExtensionList<T, D>(jenkins, describableType);
    }

    @Deprecated
    public static <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> createDescriptorList(Hudson hudson, Class<T> describableType) {
        return DescriptorExtensionList.createDescriptorList((Jenkins)hudson, describableType);
    }

    @Deprecated
    protected DescriptorExtensionList(Hudson hudson, Class<T> describableType) {
        this((Jenkins)hudson, describableType);
    }

    protected DescriptorExtensionList(Jenkins jenkins, Class<T> describableType) {
        super(jenkins, Descriptor.class, DescriptorExtensionList.getLegacyDescriptors(describableType));
        this.describableType = describableType;
    }

    @Deprecated
    public D find(String fqcn) {
        return (D)Descriptor.find(this, fqcn);
    }

    public D find(Class<? extends T> type) {
        for (Descriptor d : this) {
            if (d.clazz != type) continue;
            return (D)d;
        }
        return null;
    }

    @CheckForNull
    public T newInstanceFromRadioList(JSONObject config) throws Descriptor.FormException {
        if (config.isNullObject()) {
            return null;
        }
        int idx = config.getInt("value");
        return ((Descriptor)this.get(idx)).newInstance(Stapler.getCurrentRequest2(), config);
    }

    @CheckForNull
    public T newInstanceFromRadioList(@NonNull JSONObject parent, @NonNull String name) throws Descriptor.FormException {
        try {
            return this.newInstanceFromRadioList(parent.getJSONObject(name));
        }
        catch (JSONException ex) {
            throw new Descriptor.FormException(ex, name);
        }
    }

    @CheckForNull
    public D findByName(String id) {
        for (Descriptor d : this) {
            if (!d.getId().equals(id)) continue;
            return (D)d;
        }
        return null;
    }

    @Override
    public boolean add(D d) {
        boolean r = super.add(d);
        this.getDescriptorExtensionList().add((Descriptor)d);
        return r;
    }

    @Override
    public boolean remove(Object o) {
        this.getDescriptorExtensionList().remove(o);
        return super.remove(o);
    }

    @Override
    protected Object getLoadLock() {
        return this.getDescriptorExtensionList().getLoadLock();
    }

    @Override
    protected List<ExtensionComponent<D>> load() {
        if (this.jenkins == null) {
            LOGGER.log(Level.WARNING, "Cannot load extension components, because Jenkins instance has not been assigned yet");
            return Collections.emptyList();
        }
        return this._load(this.getDescriptorExtensionList().getComponents());
    }

    @Override
    protected Collection<ExtensionComponent<D>> load(ExtensionComponentSet delta) {
        return this._load(delta.find(Descriptor.class));
    }

    private List<ExtensionComponent<D>> _load(Iterable<ExtensionComponent<Descriptor>> set) {
        ArrayList<ExtensionComponent<D>> r = new ArrayList<ExtensionComponent<D>>();
        for (ExtensionComponent<Descriptor> c : set) {
            Descriptor d = c.getInstance();
            try {
                if (d.getT() != this.describableType) continue;
                r.add(c);
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.SEVERE, d.getClass() + " doesn't extend Descriptor with a type parameter", e);
            }
        }
        return r;
    }

    private ExtensionList<Descriptor> getDescriptorExtensionList() {
        return ExtensionList.lookup(Descriptor.class);
    }

    private static <T extends Describable<T>> CopyOnWriteArrayList<ExtensionComponent<Descriptor>> getLegacyDescriptors(Class<T> type) {
        return legacyDescriptors.computeIfAbsent(type, key -> new CopyOnWriteArrayList());
    }

    public static Iterable<Descriptor> listLegacyInstances() {
        return new Iterable<Descriptor>(){

            @Override
            public Iterator<Descriptor> iterator() {
                return new AdaptedIterator<ExtensionComponent<Descriptor>, Descriptor>((Iterator)new Iterators.FlattenIterator<ExtensionComponent<Descriptor>, CopyOnWriteArrayList<ExtensionComponent<Descriptor>>>(legacyDescriptors.values()){

                    @Override
                    protected Iterator<ExtensionComponent<Descriptor>> expand(CopyOnWriteArrayList<ExtensionComponent<Descriptor>> v) {
                        return v.iterator();
                    }
                }){

                    @Override
                    protected Descriptor adapt(ExtensionComponent<Descriptor> item) {
                        return item.getInstance();
                    }
                };
            }
        };
    }

    public static void clearLegacyInstances() {
        legacyDescriptors.clear();
    }
}

