/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.PlainCLIProtocol;
import hudson.model.UnprotectedRootAction;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.FullDuplexHttpService;
import jenkins.util.SystemProperties;
import jenkins.websocket.WebSocketSession;
import jenkins.websocket.WebSockets;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.springframework.security.core.Authentication;

@Extension
@Symbol(value={"cli"})
@Restricted(value={NoExternalUse.class})
public class CLIAction
implements UnprotectedRootAction,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(CLIAction.class.getName());
    static Boolean ALLOW_WEBSOCKET = SystemProperties.optBoolean(CLIAction.class.getName() + ".ALLOW_WEBSOCKET");
    private final transient Map<UUID, FullDuplexHttpService> duplexServices = new HashMap<UUID, FullDuplexHttpService>();

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Jenkins CLI";
    }

    @Override
    public String getUrlName() {
        return "cli";
    }

    public void doCommand(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.READ);
        String commandName = req.getRestOfPath().substring(1);
        CLICommand command = CLICommand.clone(commandName);
        if (command == null) {
            rsp.sendError(404, "No such command");
            return;
        }
        req.setAttribute("command", (Object)command);
        req.getView((Object)this, "command.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public boolean isWebSocketSupported() {
        return WebSockets.isSupported();
    }

    public HttpResponse doWs(StaplerRequest2 req) {
        if (!WebSockets.isSupported()) {
            return HttpResponses.notFound();
        }
        if (ALLOW_WEBSOCKET == null) {
            String removeSuffix2;
            String removeSuffix1;
            String actualOrigin = req.getHeader("Origin");
            String o = Jenkins.get().getRootUrlFromRequest();
            if (o.endsWith(removeSuffix1 = "/")) {
                o = o.substring(0, o.length() - removeSuffix1.length());
            }
            if (o.endsWith(removeSuffix2 = req.getContextPath())) {
                o = o.substring(0, o.length() - removeSuffix2.length());
            }
            String expectedOrigin = o;
            if (actualOrigin == null || !actualOrigin.equals(expectedOrigin)) {
                LOGGER.log(Level.FINE, () -> "Rejecting origin: " + actualOrigin + "; expected was from request: " + expectedOrigin);
                return HttpResponses.forbidden();
            }
        } else if (!ALLOW_WEBSOCKET.booleanValue()) {
            return HttpResponses.forbidden();
        }
        final Authentication authentication = Jenkins.getAuthentication2();
        return WebSockets.upgrade(new WebSocketSession(){
            ServerSideImpl connection;
            long sentBytes;
            long sentCount;
            long receivedBytes;
            long receivedCount;

            private void doClose() throws IOException {
                this.close();
            }

            @Override
            protected void opened() {
                try {
                    this.connection = new ServerSideImpl(new OutputImpl(), authentication);
                }
                catch (IOException x) {
                    this.error(x);
                    return;
                }
                new Thread(() -> {
                    try {
                        try {
                            this.connection.run();
                        }
                        finally {
                            this.connection.close();
                        }
                    }
                    catch (Exception x) {
                        this.error(x);
                    }
                }, "CLI handler for " + authentication.getName()).start();
            }

            @Override
            protected void binary(byte[] payload, int offset, int len) {
                try {
                    this.connection.handle(new DataInputStream(new ByteArrayInputStream(payload, offset, len)));
                    this.receivedBytes += (long)len;
                    ++this.receivedCount;
                }
                catch (IOException x) {
                    this.error(x);
                }
            }

            @Override
            protected void error(Throwable cause) {
                LOGGER.log(Level.WARNING, null, cause);
            }

            @Override
            protected void closed(int statusCode, String reason) {
                LOGGER.fine(() -> "closed: " + statusCode + ": " + reason);
                LOGGER.fine(() -> "received " + this.receivedCount + " packets of " + this.receivedBytes + " bytes; sent " + this.sentCount + " packets of " + this.sentBytes + " bytes");
                this.connection.handleClose();
            }

            class OutputImpl
            implements PlainCLIProtocol.Output {
                OutputImpl() {
                }

                public void send(byte[] data) throws IOException {
                    this.sendBinary(ByteBuffer.wrap(data));
                    sentBytes += (long)data.length;
                    ++sentCount;
                }

                public void close() throws IOException {
                    this.doClose();
                }
            }
        });
    }

    public Object getTarget() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req.getRestOfPath().isEmpty() && "POST".equals(req.getMethod())) {
            if ("false".equals(req.getParameter("remoting"))) {
                throw new PlainCliEndpointResponse();
            }
            throw HttpResponses.forbidden();
        }
        return this;
    }

    private class PlainCliEndpointResponse
    extends FullDuplexHttpService.Response {
        PlainCliEndpointResponse() {
            super(CLIAction.this.duplexServices);
        }

        @Override
        protected FullDuplexHttpService createService(StaplerRequest2 req, UUID uuid) throws IOException {
            return new FullDuplexHttpService(uuid){

                @Override
                protected void run(InputStream upload, OutputStream download) throws IOException, InterruptedException {
                    try (ServerSideImpl connection = new ServerSideImpl((PlainCLIProtocol.Output)new PlainCLIProtocol.FramedOutput(download), Jenkins.getAuthentication2());){
                        new PlainCLIProtocol.FramedReader((PlainCLIProtocol.EitherSide)connection, upload).start();
                        connection.run();
                    }
                }
            };
        }
    }

    static class ServerSideImpl
    extends PlainCLIProtocol.ServerSide {
        private Thread runningThread;
        private boolean ready;
        private final List<String> args = new ArrayList<String>();
        private Locale locale = Locale.getDefault();
        private Charset encoding = Charset.defaultCharset();
        private final PipedInputStream stdin = new PipedInputStream();
        private final PipedOutputStream stdinMatch = new PipedOutputStream();
        private final Authentication authentication;

        ServerSideImpl(PlainCLIProtocol.Output out, Authentication authentication) throws IOException {
            super(out);
            this.stdinMatch.connect(this.stdin);
            this.authentication = authentication;
        }

        protected void onArg(String text) {
            this.args.add(text);
        }

        protected void onLocale(String text) {
            for (Locale _locale : Locale.getAvailableLocales()) {
                if (!_locale.toString().equals(text)) continue;
                this.locale = _locale;
                return;
            }
            LOGGER.log(Level.WARNING, "unknown client locale {0}", text);
        }

        protected void onEncoding(String text) {
            try {
                this.encoding = Charset.forName(text);
            }
            catch (UnsupportedCharsetException x) {
                LOGGER.log(Level.WARNING, "unknown client charset {0}", text);
            }
        }

        protected void onStart() {
            this.ready();
        }

        protected void onStdin(byte[] chunk) throws IOException {
            this.stdinMatch.write(chunk);
        }

        protected void onEndStdin() throws IOException {
            this.stdinMatch.close();
        }

        protected void handleClose() {
            this.ready();
            if (this.runningThread != null) {
                this.runningThread.interrupt();
            }
        }

        private synchronized void ready() {
            this.ready = true;
            ((Object)((Object)this)).notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() throws IOException, InterruptedException {
            ServerSideImpl serverSideImpl = this;
            synchronized (serverSideImpl) {
                while (!this.ready) {
                    ((Object)((Object)this)).wait();
                }
            }
            PrintStream stdout = new PrintStream(this.streamStdout(), false, this.encoding);
            PrintStream stderr = new PrintStream(this.streamStderr(), true, this.encoding);
            if (this.args.isEmpty()) {
                stderr.println("Connection closed before arguments received");
                this.sendExit(2);
                return;
            }
            String commandName = this.args.get(0);
            CLICommand command = CLICommand.clone(commandName);
            if (command == null) {
                stderr.println("No such command " + commandName);
                this.sendExit(2);
                return;
            }
            command.setTransportAuth2(this.authentication);
            command.setClientCharset(this.encoding);
            CLICommand orig = CLICommand.setCurrent(command);
            try {
                this.runningThread = Thread.currentThread();
                int exit = command.main(this.args.subList(1, this.args.size()), this.locale, this.stdin, stdout, stderr);
                stdout.flush();
                this.sendExit(exit);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                CLICommand.setCurrent(orig);
                this.runningThread = null;
            }
        }
    }
}

