/*
 * Decompiled with CFR 0.152.
 */
package hudson.scheduler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public abstract class Hash {
    private static final Hash ZERO = new Hash(){

        @Override
        public int next(int n) {
            return 0;
        }
    };

    Hash() {
    }

    public abstract int next(int var1);

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="The random is just used for load distribution.")
    public static Hash from(String seed) {
        try {
            MessageDigest md5 = Hash.getMd5();
            md5.update(seed.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md5.digest();
            for (int i = 8; i < digest.length; ++i) {
                int n = i % 8;
                digest[n] = (byte)(digest[n] ^ digest[i]);
            }
            long l = 0L;
            for (int i = 0; i < 8; ++i) {
                l = (l << 8) + (long)(digest[i] & 0xFF);
            }
            final Random rnd = new Random(l);
            return new Hash(){

                @Override
                public int next(int n) {
                    return rnd.nextInt(n);
                }
            };
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="Should not be used for security.")
    private static MessageDigest getMd5() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("MD5");
    }

    public static Hash zero() {
        return ZERO;
    }
}

