/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.ACL;
import hudson.security.Permission;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.springframework.security.access.AccessDeniedException;

public interface AccessControlled {
    @NonNull
    public ACL getACL();

    default public void checkPermission(@NonNull Permission permission) throws AccessDeniedException {
        if (Jenkins.getAuthentication2().equals(ACL.SYSTEM2)) {
            return;
        }
        this.getACL().checkPermission(permission);
    }

    default public void checkAnyPermission(Permission ... permission) throws AccessDeniedException {
        this.getACL().checkAnyPermission(permission);
    }

    default public boolean hasPermission(@NonNull Permission permission) {
        if (Jenkins.getAuthentication2().equals(ACL.SYSTEM2)) {
            return true;
        }
        return this.getACL().hasPermission(permission);
    }

    default public boolean hasAnyPermission(Permission ... permission) {
        return this.getACL().hasAnyPermission(permission);
    }

    default public boolean hasPermission2(@NonNull org.springframework.security.core.Authentication a, @NonNull Permission permission) {
        if (a.equals(ACL.SYSTEM2)) {
            return true;
        }
        return this.getACL().hasPermission2(a, permission);
    }

    @Deprecated
    default public boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission) {
        return this.hasPermission2(a.toSpring(), permission);
    }
}

