/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.Messages;
import hudson.slaves.SlaveComputer;
import jenkins.model.Jenkins;
import jenkins.model.identity.InstanceIdentityProvider;
import jenkins.slaves.RemotingWorkDirSettings;
import jenkins.util.SystemProperties;
import jenkins.websocket.WebSockets;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JNLPLauncher
extends ComputerLauncher {
    @CheckForNull
    public String tunnel;
    @Deprecated
    public final transient String vmargs;
    @NonNull
    private RemotingWorkDirSettings workDirSettings = RemotingWorkDirSettings.getEnabledDefaults();
    private boolean webSocket;
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static final String CUSTOM_INBOUND_URL_PROPERTY = "jenkins.agent.inboundUrl";
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static Descriptor<ComputerLauncher> DESCRIPTOR;

    @Deprecated
    public JNLPLauncher(@CheckForNull String tunnel, @CheckForNull String vmargs, @CheckForNull RemotingWorkDirSettings workDirSettings) {
        this(tunnel, vmargs);
        if (workDirSettings != null) {
            this.setWorkDirSettings(workDirSettings);
        }
    }

    @Deprecated
    public JNLPLauncher(@CheckForNull String tunnel) {
        this.vmargs = null;
        this.tunnel = Util.fixEmptyAndTrim(tunnel);
    }

    @Deprecated
    public JNLPLauncher(@CheckForNull String tunnel, @CheckForNull String vmargs) {
        this.vmargs = null;
        this.tunnel = Util.fixEmptyAndTrim(tunnel);
    }

    @DataBoundConstructor
    public JNLPLauncher() {
        this.vmargs = null;
    }

    @Deprecated
    public JNLPLauncher(boolean enableWorkDir) {
        this(null, null, enableWorkDir ? RemotingWorkDirSettings.getEnabledDefaults() : RemotingWorkDirSettings.getDisabledDefaults());
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="workDirSettings in readResolve is needed for data migration.")
    protected Object readResolve() {
        if (this.workDirSettings == null) {
            this.workDirSettings = RemotingWorkDirSettings.getDisabledDefaults();
        }
        return this;
    }

    public RemotingWorkDirSettings getWorkDirSettings() {
        return this.workDirSettings;
    }

    @DataBoundSetter
    public final void setWorkDirSettings(@NonNull RemotingWorkDirSettings workDirSettings) {
        this.workDirSettings = workDirSettings;
    }

    @Override
    public boolean isLaunchSupported() {
        return false;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    @DataBoundSetter
    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }

    public String getTunnel() {
        return this.tunnel;
    }

    @DataBoundSetter
    public void setTunnel(String tunnel) {
        this.tunnel = Util.fixEmptyAndTrim(tunnel);
    }

    @Override
    public void launch(SlaveComputer computer, TaskListener listener) {
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getRemotingOptionsUnix(@NonNull Computer computer) {
        return this.getRemotingOptions(JNLPLauncher.escapeUnix(computer.getName()));
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getRemotingOptionsWindows(@NonNull Computer computer) {
        return this.getRemotingOptions(JNLPLauncher.escapeWindows(computer.getName()));
    }

    @Restricted(value={DoNotUse.class})
    public boolean isConfigured() {
        return this.webSocket || this.tunnel != null || this.workDirSettings.isConfigured();
    }

    private String getRemotingOptions(String computerName) {
        StringBuilder sb = new StringBuilder();
        sb.append("-name ");
        sb.append(computerName);
        sb.append(' ');
        sb.append("-webSocket ");
        if (this.tunnel != null) {
            sb.append(" -tunnel ");
            sb.append(this.tunnel);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String escapeUnix(@NonNull String input) {
        if (!input.isEmpty() && input.chars().allMatch(Character::isLetterOrDigit)) {
            return input;
        }
        Escaper escaper = Escapers.builder().addEscape('\"', "\\\"").addEscape('`', "\\`").build();
        return "\"" + escaper.escape(input) + "\"";
    }

    private static String escapeWindows(@NonNull String input) {
        if (!input.isEmpty() && input.chars().allMatch(Character::isLetterOrDigit)) {
            return input;
        }
        Escaper escaper = Escapers.builder().addEscape('\"', "\\\"").build();
        return "\"" + escaper.escape(input) + "\"";
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getWorkDirOptions(@NonNull Computer computer) {
        if (!(computer instanceof SlaveComputer)) {
            return "";
        }
        return this.workDirSettings.toCommandLineString((SlaveComputer)computer);
    }

    @Restricted(value={NoExternalUse.class})
    public static String getInboundAgentUrl() {
        String url = SystemProperties.getString(CUSTOM_INBOUND_URL_PROPERTY);
        if (url == null || url.isEmpty()) {
            return Jenkins.get().getRootUrl();
        }
        return url;
    }

    @Extension
    @Symbol(value={"inbound", "jnlp"})
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.JNLPLauncher_displayName();
        }

        public boolean isWorkDirSupported() {
            return DescriptorImpl.class.equals(this.getClass());
        }

        @Restricted(value={DoNotUse.class})
        public boolean isTcpSupported() {
            return Jenkins.get().getTcpSlaveAgentListener() != null;
        }

        @Restricted(value={DoNotUse.class})
        public boolean isInstanceIdentityInstalled() {
            return InstanceIdentityProvider.RSA.getCertificate() != null && InstanceIdentityProvider.RSA.getPrivateKey() != null;
        }

        @Restricted(value={DoNotUse.class})
        public boolean isWebSocketSupported() {
            return WebSockets.isSupported();
        }
    }
}

