/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.tools.Messages;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolLocationTranslator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class ToolLocationNodeProperty
extends NodeProperty<Node> {
    private final List<ToolLocation> locations;

    @DataBoundConstructor
    public ToolLocationNodeProperty(List<ToolLocation> locations) {
        if (locations == null) {
            locations = new ArrayList<ToolLocation>();
        }
        this.locations = locations;
    }

    public ToolLocationNodeProperty(ToolLocation ... locations) {
        this(Arrays.asList(locations));
    }

    public List<ToolLocation> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public String getHome(ToolInstallation installation) {
        for (ToolLocation location : this.locations) {
            if (!location.getName().equals(installation.getName()) || location.getType() != installation.getDescriptor()) continue;
            return location.getHome();
        }
        return null;
    }

    @Deprecated
    public static String getToolHome(Node node, ToolInstallation installation, TaskListener log) throws IOException, InterruptedException {
        String result = null;
        ToolLocationNodeProperty property = (ToolLocationNodeProperty)node.getNodeProperties().get(ToolLocationNodeProperty.class);
        if (property != null) {
            result = property.getHome(installation);
        }
        if (result != null) {
            return result;
        }
        for (ToolLocationTranslator t : ToolLocationTranslator.all()) {
            result = t.getToolHome(node, installation, log);
            if (result == null) continue;
            return result;
        }
        return installation.getHome();
    }

    public static final class ToolLocation {
        private final String type;
        private final String name;
        private final String home;
        private volatile transient ToolDescriptor descriptor;

        public ToolLocation(ToolDescriptor type, String name, String home) {
            this.descriptor = type;
            this.type = type.getClass().getName();
            this.name = name;
            this.home = home;
        }

        @DataBoundConstructor
        public ToolLocation(String key, String home) {
            this.type = key.substring(0, key.indexOf(64));
            this.name = key.substring(key.indexOf(64) + 1);
            this.home = home;
        }

        public String getName() {
            return this.name;
        }

        public String getHome() {
            return this.home;
        }

        public ToolDescriptor getType() {
            if (this.descriptor == null) {
                this.descriptor = (ToolDescriptor)Descriptor.find(this.type);
            }
            return this.descriptor;
        }

        public String getKey() {
            return this.type + "@" + this.name;
        }
    }

    @Extension
    @Symbol(value={"toolLocation"})
    public static class DescriptorImpl
    extends NodePropertyDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ToolLocationNodeProperty_displayName();
        }

        public DescriptorExtensionList<ToolInstallation, ToolDescriptor<?>> getToolDescriptors() {
            return ToolInstallation.all();
        }

        public String getKey(ToolInstallation installation) {
            return installation.getDescriptor().getClass().getName() + "@" + installation.getName();
        }

        @Override
        public boolean isApplicable(Class<? extends Node> nodeType) {
            return nodeType != Jenkins.class;
        }
    }
}

