/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class CopyOnWriteMap<K, V>
implements Map<K, V> {
    protected volatile Map<K, V> core;
    private volatile Map<K, V> view;

    protected CopyOnWriteMap(Map<K, V> core) {
        this.update(core);
    }

    protected CopyOnWriteMap() {
        this.update(Collections.emptyMap());
    }

    protected void update(Map<K, V> m) {
        this.core = m;
        this.view = Collections.unmodifiableMap(this.core);
    }

    public void replaceBy(Map<? extends K, ? extends V> data) {
        Map<? extends K, ? extends V> d = this.copy();
        d.clear();
        d.putAll(data);
        this.update(d);
    }

    @Override
    public int size() {
        return this.core.size();
    }

    @Override
    public boolean isEmpty() {
        return this.core.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.core.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.core.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.core.get(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        Map<K, V> m = this.copy();
        V r = m.put(key, value);
        this.update(m);
        return r;
    }

    @Override
    public synchronized V remove(Object key) {
        Map<K, V> m = this.copy();
        V r = m.remove(key);
        this.update(m);
        return r;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        Map<? extends K, ? extends V> m = this.copy();
        m.putAll(t);
        this.update(m);
    }

    protected abstract Map<K, V> copy();

    @Override
    public synchronized void clear() {
        this.update(Collections.emptyMap());
    }

    @Override
    public Set<K> keySet() {
        return this.view.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.view.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.view.entrySet();
    }

    @Override
    public int hashCode() {
        return this.copy().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.copy().equals(obj);
    }

    public String toString() {
        return this.copy().toString();
    }

    public static final class Tree<K, V>
    extends CopyOnWriteMap<K, V> {
        private final Comparator<K> comparator;

        public Tree(Map<K, V> core, Comparator<K> comparator) {
            this(comparator);
            this.putAll(core);
        }

        public Tree(Comparator<K> comparator) {
            super(new TreeMap(comparator));
            this.comparator = comparator;
        }

        public Tree() {
            this((Comparator<K>)null);
        }

        @Override
        protected Map<K, V> copy() {
            TreeMap m = new TreeMap(this.comparator);
            m.putAll(this.core);
            return m;
        }

        @Override
        public synchronized void clear() {
            this.update(new TreeMap(this.comparator));
        }

        public static class ConverterImpl
        extends TreeMapConverter {
            public ConverterImpl(Mapper mapper) {
                super(mapper);
            }

            public boolean canConvert(Class type) {
                return type == Tree.class;
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                TreeMap tm = (TreeMap)super.unmarshal(reader, context);
                return new Tree(tm, tm.comparator());
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                super.marshal((Object)((Tree)source).core, writer, context);
            }
        }
    }

    public static final class Hash<K, V>
    extends CopyOnWriteMap<K, V> {
        public Hash(Map<K, V> core) {
            super(new LinkedHashMap<K, V>(core));
        }

        public Hash() {
        }

        @Override
        protected Map<K, V> copy() {
            return new LinkedHashMap(this.core);
        }

        public static class ConverterImpl
        extends MapConverter {
            public ConverterImpl(Mapper mapper) {
                super(mapper);
            }

            public boolean canConvert(Class type) {
                return type == Hash.class;
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                return new Hash((Map)super.unmarshal(reader, context));
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                super.marshal((Object)((Hash)source).core, writer, context);
            }
        }
    }
}

