/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import jakarta.servlet.ServletOutputStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import javax.imageio.ImageIO;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.SystemProperties;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class Graph {
    @Restricted(value={NoExternalUse.class})
    static int MAX_AREA = SystemProperties.getInteger(Graph.class.getName() + ".maxArea", 10000000);
    private final long timestamp;
    private final int defaultWidth;
    private final int defaultHeight;
    private final int defaultScale = 1;
    private volatile JFreeChart graph;

    protected Graph(long timestamp, int defaultWidth, int defaultHeight) {
        this.timestamp = timestamp;
        this.defaultWidth = defaultWidth;
        this.defaultHeight = defaultHeight;
    }

    protected Graph(Calendar timestamp, int defaultWidth, int defaultHeight) {
        this(timestamp.getTimeInMillis(), defaultWidth, defaultHeight);
    }

    protected abstract JFreeChart createGraph();

    private BufferedImage render(StaplerRequest2 req, ChartRenderingInfo info) {
        String s;
        String h;
        String w = req.getParameter("width");
        if (w == null) {
            w = String.valueOf(this.defaultWidth);
        }
        if ((h = req.getParameter("height")) == null) {
            h = String.valueOf(this.defaultHeight);
        }
        if ((s = req.getParameter("scale")) == null) {
            s = String.valueOf(1);
        }
        Color graphBg = Graph.stringToColor(req.getParameter("graphBg"));
        Color plotBg = Graph.stringToColor(req.getParameter("plotBg"));
        if (this.graph == null) {
            this.graph = this.createGraph();
        }
        this.graph.setBackgroundPaint((Paint)graphBg);
        Plot p = this.graph.getPlot();
        p.setBackgroundPaint((Paint)plotBg);
        int width = Math.min(Integer.parseInt(w), 2560);
        int height = Math.min(Integer.parseInt(h), 1440);
        int scale = Math.min(Integer.parseInt(s), 3);
        Dimension safeDimension = Graph.safeDimension(width, height, this.defaultWidth, this.defaultHeight);
        return this.graph.createBufferedImage(safeDimension.width * scale, safeDimension.height * scale, (double)safeDimension.width, (double)safeDimension.height, info);
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    public static Dimension safeDimension(int width, int height, int defaultWidth, int defaultHeight) {
        if (width <= 0 || height <= 0 || width > MAX_AREA / height) {
            width = defaultWidth;
            height = defaultHeight;
        }
        return new Dimension(width, height);
    }

    @NonNull
    private static Color stringToColor(@CheckForNull String s) {
        if (s != null) {
            try {
                return Color.decode("0x" + s);
            }
            catch (NumberFormatException e) {
                return Color.WHITE;
            }
        }
        return Color.WHITE;
    }

    public void doPng(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (Util.isOverridden(Graph.class, this.getClass(), "doPng", StaplerRequest.class, StaplerResponse.class)) {
            this.doPng(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
        } else {
            this.doPngImpl(req, rsp);
        }
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doPng(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doPngImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
    }

    private void doPngImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (req.checkIfModified(this.timestamp, rsp)) {
            return;
        }
        try {
            BufferedImage image = this.render(req, null);
            rsp.setContentType("image/png");
            ServletOutputStream os = rsp.getOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", (OutputStream)os);
            os.close();
        }
        catch (Error e) {
            if (e.getMessage().contains("Probable fatal error:No fonts found")) {
                rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
                return;
            }
            throw e;
        }
        catch (HeadlessException e) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
        }
    }

    public void doMap(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (Util.isOverridden(Graph.class, this.getClass(), "doMap", StaplerRequest.class, StaplerResponse.class)) {
            this.doMap(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
        } else {
            this.doMapImpl(req, rsp);
        }
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doMapImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
    }

    private void doMapImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (req.checkIfModified(this.timestamp, rsp)) {
            return;
        }
        ChartRenderingInfo info = new ChartRenderingInfo();
        this.render(req, info);
        rsp.setContentType("text/plain;charset=UTF-8");
        rsp.getWriter().println(ChartUtilities.getImageMap((String)"map", (ChartRenderingInfo)info));
    }
}

