/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import hudson.Functions;
import hudson.Util;
import hudson.util.IOUtils;
import hudson.util.io.Archiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

final class TarArchiver
extends Archiver {
    private final byte[] buf = new byte[8192];
    private final TarOutputStream tar;

    TarArchiver(OutputStream out, Charset filenamesEncoding) {
        this.tar = new TarOutputStream(out, filenamesEncoding.name());
        this.tar.setBigNumberMode(1);
        this.tar.setLongFileMode(2);
    }

    @Override
    public void visitSymlink(File link, String target, String relativePath) throws IOException {
        TarEntry e = new TarEntry(relativePath, 50);
        try {
            int mode = IOUtils.mode(link);
            if (mode != -1) {
                e.setMode(mode);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        e.setLinkName(target);
        this.tar.putNextEntry(e);
        this.tar.closeEntry();
        ++this.entriesWritten;
    }

    @Override
    public boolean understandsSymlink() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(File file, String relativePath) throws IOException {
        block21: {
            BasicFileAttributes basicFileAttributes;
            if (Functions.isWindows()) {
                relativePath = ((String)relativePath).replace('\\', '/');
            }
            if ((basicFileAttributes = Files.readAttributes(Util.fileToPath(file), BasicFileAttributes.class, new LinkOption[0])).isDirectory()) {
                relativePath = (String)relativePath + "/";
            }
            TarEntry te = new TarEntry((String)relativePath);
            int mode = IOUtils.mode(file);
            if (mode != -1) {
                te.setMode(mode);
            }
            te.setModTime(basicFileAttributes.lastModifiedTime().toMillis());
            long size = 0L;
            if (!basicFileAttributes.isDirectory()) {
                size = basicFileAttributes.size();
                te.setSize(size);
            }
            this.tar.putNextEntry(te);
            try {
                if (basicFileAttributes.isDirectory()) break block21;
                try (InputStream fin = Files.newInputStream(file.toPath(), new OpenOption[0]);
                     BoundedInputStream in = new BoundedInputStream(fin, size);){
                    try {
                        int len;
                        while ((len = in.read(this.buf)) >= 0) {
                            this.tar.write(this.buf, 0, len);
                        }
                    }
                    catch (IOException | InvalidPathException e) {
                        throw new IOException("Error writing to tar file from: " + file, e);
                    }
                }
            }
            finally {
                this.tar.closeEntry();
            }
        }
        ++this.entriesWritten;
    }

    @Override
    public void close() throws IOException {
        this.tar.close();
    }
}

