/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import jakarta.servlet.http.HttpSessionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.HttpSessionListener;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class JenkinsHttpSessionListener
implements jakarta.servlet.http.HttpSessionListener {
    private static final Logger LOGGER = Logger.getLogger(JenkinsHttpSessionListener.class.getName());

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        for (HttpSessionListener listener : HttpSessionListener.all()) {
            try {
                listener.sessionCreated(httpSessionEvent);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Error calling HttpSessionListener ExtensionPoint sessionCreated().", e);
            }
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        for (HttpSessionListener listener : HttpSessionListener.all()) {
            try {
                listener.sessionDestroyed(httpSessionEvent);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Error calling HttpSessionListener ExtensionPoint sessionDestroyed().", e);
            }
        }
    }
}

