/*
 * Decompiled with CFR 0.152.
 */
package jenkins.management;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Restricted(value={NoExternalUse.class})
public class AdministrativeMonitorsConfiguration
extends GlobalConfiguration {
    private static Logger LOGGER = Logger.getLogger(AdministrativeMonitorsConfiguration.class.getName());

    @Override
    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        JSONArray monitors = json.optJSONArray("administrativeMonitor");
        for (AdministrativeMonitor am : AdministrativeMonitor.all()) {
            try {
                boolean disable = monitors != null ? !monitors.contains((Object)am.id) : !am.id.equals(json.optString("administrativeMonitor"));
                am.disable(disable);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to process form submission for " + am.id, e);
            }
        }
        return true;
    }
}

