/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.identity;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class InstanceIdentityProvider<PUB extends PublicKey, PRIV extends PrivateKey>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(InstanceIdentityProvider.class.getName());
    @Restricted(value={NoExternalUse.class})
    public static final KeyTypes<RSAPublicKey, RSAPrivateKey> RSA = new KeyTypes<RSAPublicKey, RSAPrivateKey>(RSAPublicKey.class, RSAPrivateKey.class);
    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public static final KeyTypes<DSAPublicKey, DSAPrivateKey> DSA = new KeyTypes<DSAPublicKey, DSAPrivateKey>(DSAPublicKey.class, DSAPrivateKey.class);
    @Restricted(value={NoExternalUse.class})
    @Deprecated
    public static final KeyTypes<ECPublicKey, ECPrivateKey> EC = new KeyTypes<ECPublicKey, ECPrivateKey>(ECPublicKey.class, ECPrivateKey.class);

    @CheckForNull
    protected abstract KeyPair getKeyPair();

    @CheckForNull
    protected PUB getPublicKey() {
        KeyPair keyPair = this.getKeyPair();
        return (PUB)(keyPair == null ? null : keyPair.getPublic());
    }

    @CheckForNull
    protected PRIV getPrivateKey() {
        KeyPair keyPair = this.getKeyPair();
        return (PRIV)(keyPair == null ? null : keyPair.getPrivate());
    }

    @CheckForNull
    protected abstract X509Certificate getCertificate();

    @Restricted(value={NoExternalUse.class})
    public static final class KeyTypes<PUB extends PublicKey, PRIV extends PrivateKey> {
        private final Class<PUB> pubKeyType;
        private final Class<PRIV> privKeyType;

        private KeyTypes(Class<PUB> pubKeyType, Class<PRIV> privKeyType) {
            this.pubKeyType = pubKeyType;
            this.privKeyType = privKeyType;
        }

        @CheckForNull
        private static <PUB extends PublicKey, PRIV extends PrivateKey> InstanceIdentityProvider<PUB, PRIV> get(@NonNull KeyTypes<PUB, PRIV> type) {
            for (InstanceIdentityProvider provider : ExtensionList.lookup(InstanceIdentityProvider.class)) {
                LOGGER.fine(() -> "loaded " + provider + " from " + provider.getClass().getProtectionDomain().getCodeSource().getLocation());
                try {
                    KeyPair keyPair = provider.getKeyPair();
                    if (keyPair == null || !type.pubKeyType.isInstance(keyPair.getPublic()) || !type.privKeyType.isInstance(keyPair.getPrivate())) continue;
                    return provider;
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Instance identity provider " + provider + " propagated a runtime exception", e);
                }
                catch (Error e) {
                    LOGGER.log(Level.INFO, "Encountered an error while consulting instance identity provider " + provider, e);
                    throw e;
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Instance identity provider " + provider + " propagated an uncaught exception", e);
                }
            }
            LOGGER.fine("no providers");
            return null;
        }

        public Class<PUB> getPublicKeyClass() {
            return this.pubKeyType;
        }

        public Class<PRIV> getPrivateKeyClass() {
            return this.privKeyType;
        }

        @CheckForNull
        public KeyPair getKeyPair() {
            InstanceIdentityProvider<PUB, PRIV> provider = KeyTypes.get(this);
            try {
                return provider == null ? null : provider.getKeyPair();
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Instance identity provider " + provider + " propagated a runtime exception", e);
                return null;
            }
            catch (Error e) {
                LOGGER.log(Level.INFO, "Encountered an error while consulting instance identity provider " + provider, e);
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Instance identity provider " + provider + " propagated an uncaught exception", e);
                return null;
            }
        }

        @CheckForNull
        public PUB getPublicKey() {
            InstanceIdentityProvider<PUB, PRIV> provider = KeyTypes.get(this);
            try {
                return provider == null ? null : (PUB)provider.getPublicKey();
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Instance identity provider " + provider + " propagated a runtime exception", e);
                return null;
            }
            catch (Error e) {
                LOGGER.log(Level.INFO, "Encountered an error while consulting instance identity provider " + provider, e);
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Instance identity provider " + provider + " propagated an uncaught exception", e);
                return null;
            }
        }

        @CheckForNull
        public PRIV getPrivateKey() {
            InstanceIdentityProvider<PUB, PRIV> provider = KeyTypes.get(this);
            try {
                return provider == null ? null : (PRIV)provider.getPrivateKey();
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Instance identity provider " + provider + " propagated a runtime exception", e);
                return null;
            }
            catch (Error e) {
                LOGGER.log(Level.INFO, "Encountered an error while consulting instance identity provider " + provider, e);
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Instance identity provider " + provider + " propagated an uncaught exception", e);
                return null;
            }
        }

        @CheckForNull
        public X509Certificate getCertificate() {
            InstanceIdentityProvider<PUB, PRIV> provider = KeyTypes.get(this);
            try {
                return provider == null ? null : provider.getCertificate();
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Instance identity provider " + provider + " propagated a runtime exception", e);
                return null;
            }
            catch (Error e) {
                LOGGER.log(Level.INFO, "Encountered an error while consulting instance identity provider " + provider, e);
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Instance identity provider " + provider + " propagated an uncaught exception", e);
                return null;
            }
        }
    }
}

