/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Executor;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class AsynchronousExecution
extends RuntimeException {
    @GuardedBy(value="this")
    private Executor executor;
    @GuardedBy(value="this")
    @CheckForNull
    private Throwable result;
    private static final Throwable NULL = new Throwable("NULL");

    protected AsynchronousExecution() {
    }

    public abstract void interrupt(boolean var1);

    public abstract boolean blocksRestart();

    public abstract boolean displayCell();

    @CheckForNull
    public final synchronized Executor getExecutor() {
        return this.executor;
    }

    @Restricted(value={NoExternalUse.class})
    public final synchronized void setExecutorWithoutCompleting(@NonNull Executor executor) {
        assert (this.executor == null);
        this.executor = executor;
    }

    @Restricted(value={NoExternalUse.class})
    public final synchronized void maybeComplete() {
        assert (this.executor != null);
        if (this.result != null) {
            this.executor.completedAsynchronous(this.result != NULL ? this.result : null);
            this.result = null;
        }
    }

    public final synchronized void completed(@CheckForNull Throwable error) {
        if (this.executor != null) {
            this.executor.completedAsynchronous(error);
        } else {
            this.result = error == null ? NULL : error;
        }
    }
}

