/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItemHeadersProvider;

public interface FileItem {
    public InputStream getInputStream() throws IOException;

    public String getContentType();

    public String getName();

    public boolean isInMemory();

    public long getSize();

    public byte[] get();

    public String getString(String var1) throws UnsupportedEncodingException;

    public String getString();

    public void write(File var1) throws Exception;

    public void delete();

    public String getFieldName();

    public void setFieldName(String var1);

    public boolean isFormField();

    public void setFormField(boolean var1);

    public OutputStream getOutputStream() throws IOException;

    public FileItemHeaders getHeaders();

    public void setHeaders(FileItemHeaders var1);

    default public org.apache.commons.fileupload2.core.FileItem toFileUpload2FileItem() {
        return new org.apache.commons.fileupload2.core.FileItem(){

            public org.apache.commons.fileupload2.core.FileItemHeaders getHeaders() {
                return FileItem.this.getHeaders().toFileUpload2FileItemHeaders();
            }

            public FileItemHeadersProvider setHeaders(org.apache.commons.fileupload2.core.FileItemHeaders headers) {
                FileItem.this.setHeaders(FileItemHeaders.fromFileUpload2FileItemHeaders(headers));
                return this;
            }

            public org.apache.commons.fileupload2.core.FileItem delete() throws IOException {
                try {
                    FileItem.this.delete();
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
                return this;
            }

            public byte[] get() {
                return FileItem.this.get();
            }

            public String getContentType() {
                return FileItem.this.getContentType();
            }

            public String getFieldName() {
                return FileItem.this.getFieldName();
            }

            public InputStream getInputStream() throws IOException {
                return FileItem.this.getInputStream();
            }

            @SuppressFBWarnings(value={"FILE_UPLOAD_FILENAME"}, justification="for compatibility")
            public String getName() {
                return FileItem.this.getName();
            }

            public OutputStream getOutputStream() throws IOException {
                return FileItem.this.getOutputStream();
            }

            public long getSize() {
                return FileItem.this.getSize();
            }

            public String getString() {
                return FileItem.this.getString();
            }

            public String getString(Charset toCharset) throws IOException {
                return FileItem.this.getString(toCharset.name());
            }

            public boolean isFormField() {
                return FileItem.this.isFormField();
            }

            public boolean isInMemory() {
                return FileItem.this.isInMemory();
            }

            public org.apache.commons.fileupload2.core.FileItem setFieldName(String name) {
                FileItem.this.setFieldName(name);
                return this;
            }

            public org.apache.commons.fileupload2.core.FileItem setFormField(boolean state) {
                FileItem.this.setFormField(state);
                return this;
            }

            public org.apache.commons.fileupload2.core.FileItem write(Path file) throws IOException {
                try {
                    FileItem.this.write(file.toFile());
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return this;
            }
        };
    }

    public static FileItem fromFileUpload2FileItem(final org.apache.commons.fileupload2.core.FileItem from) {
        return new FileItem(){

            @Override
            public InputStream getInputStream() throws IOException {
                return from.getInputStream();
            }

            @Override
            public String getContentType() {
                return from.getContentType();
            }

            @Override
            public String getName() {
                return from.getName();
            }

            @Override
            public boolean isInMemory() {
                return from.isInMemory();
            }

            @Override
            public long getSize() {
                return from.getSize();
            }

            @Override
            public byte[] get() {
                return from.get();
            }

            @Override
            public String getString(String encoding) throws UnsupportedEncodingException {
                try {
                    return from.getString(Charset.forName(encoding));
                }
                catch (UnsupportedEncodingException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public String getString() {
                return from.getString();
            }

            @Override
            public void write(File file) throws Exception {
                from.write(file.toPath());
            }

            @Override
            public void delete() {
                try {
                    from.delete();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public String getFieldName() {
                return from.getFieldName();
            }

            @Override
            @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="for compatibility")
            public void setFieldName(String name) {
                from.setFieldName(name);
            }

            @Override
            public boolean isFormField() {
                return from.isFormField();
            }

            @Override
            @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="for compatibility")
            public void setFormField(boolean state) {
                from.setFormField(state);
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return from.getOutputStream();
            }

            @Override
            public FileItemHeaders getHeaders() {
                return FileItemHeaders.fromFileUpload2FileItemHeaders(from.getHeaders());
            }

            @Override
            public void setHeaders(FileItemHeaders headers) {
                from.setHeaders(headers.toFileUpload2FileItemHeaders());
            }

            @Override
            public org.apache.commons.fileupload2.core.FileItem toFileUpload2FileItem() {
                return from;
            }
        };
    }
}

