/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.List;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

class AncestorImpl
implements Ancestor {
    private final List<AncestorImpl> owner;
    private final int listIndex;
    private final Object object;
    private final String[] tokens;
    private final int index;
    private final String contextPath;
    private final boolean endsWithSlash;

    AncestorImpl(RequestImpl req, Object object) {
        this.owner = req.ancestors;
        this.listIndex = this.owner.size();
        this.object = object;
        this.tokens = req.tokens.rawTokens;
        this.index = req.tokens.idx;
        this.endsWithSlash = req.tokens.endsWithSlash;
        this.contextPath = req.getContextPath();
    }

    void addToOwner() {
        this.owner.add(this);
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(this.contextPath);
        for (int i = 0; i < this.index; ++i) {
            buf.append('/');
            buf.append(this.tokens[i]);
        }
        return buf.toString();
    }

    @Override
    public String getRestOfUrl() {
        StringBuilder buf = new StringBuilder();
        for (int i = this.index; i < this.tokens.length; ++i) {
            if (!buf.isEmpty()) {
                buf.append('/');
            }
            buf.append(this.tokens[i]);
        }
        return buf.toString();
    }

    @Override
    public String getFullUrl() {
        StringBuilder buf = new StringBuilder();
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        buf.append(req.getScheme());
        buf.append("://");
        buf.append(req.getServerName());
        if (req.getServerPort() != 80) {
            buf.append(':').append(req.getServerPort());
        }
        buf.append(this.getUrl());
        return buf.toString();
    }

    @Override
    public String getRelativePath() {
        StringBuilder buf = new StringBuilder();
        for (int i = this.index + (this.endsWithSlash ? 0 : 1); i < this.tokens.length; ++i) {
            if (!buf.isEmpty()) {
                buf.append('/');
            }
            buf.append("..");
        }
        if (buf.isEmpty()) {
            buf.append('.');
        }
        return buf.toString();
    }

    @Override
    public String getNextToken(int n) {
        return this.tokens[this.index + n];
    }

    @Override
    public Ancestor getPrev() {
        if (this.listIndex == 0) {
            return null;
        }
        return this.owner.get(this.listIndex - 1);
    }

    @Override
    public Ancestor getNext() {
        if (this.listIndex == this.owner.size() - 1) {
            return null;
        }
        return this.owner.get(this.listIndex + 1);
    }

    public String toString() {
        return this.object.toString();
    }
}

