/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.UUID;
import org.kohsuke.stapler.Stapler;

public abstract class AttributeKey<T> {
    protected final String name;

    public AttributeKey() {
        this.name = UUID.randomUUID().toString();
    }

    public AttributeKey(String name) {
        this.name = name;
    }

    public abstract T get(HttpServletRequest var1);

    public abstract void set(HttpServletRequest var1, T var2);

    public abstract void remove(HttpServletRequest var1);

    public final T get() {
        return this.get(Stapler.getCurrentRequest2());
    }

    public final void set(T value) {
        this.set(Stapler.getCurrentRequest2(), value);
    }

    public final void remove() {
        this.remove(Stapler.getCurrentRequest2());
    }

    public static <T> AttributeKey<T> requestScoped() {
        return new AttributeKey<T>(){

            @Override
            public T get(HttpServletRequest req) {
                return req.getAttribute(this.name);
            }

            @Override
            public void set(HttpServletRequest req, T value) {
                req.setAttribute(this.name, value);
            }

            @Override
            public void remove(HttpServletRequest req) {
                req.removeAttribute(this.name);
            }
        };
    }

    public static <T> AttributeKey<T> sessionScoped() {
        return new AttributeKey<T>(){

            @Override
            public T get(HttpServletRequest req) {
                HttpSession s = req.getSession(false);
                if (s == null) {
                    return null;
                }
                return s.getAttribute(this.name);
            }

            @Override
            public void set(HttpServletRequest req, T value) {
                req.getSession().setAttribute(this.name, value);
            }

            @Override
            public void remove(HttpServletRequest req) {
                HttpSession s = req.getSession(false);
                if (s != null) {
                    s.removeAttribute(this.name);
                }
            }
        };
    }

    public static <T> AttributeKey<T> appScoped() {
        return new AttributeKey<T>(){

            @Override
            public T get(HttpServletRequest req) {
                return this.getContext(req).getAttribute(this.name);
            }

            @Override
            public void set(HttpServletRequest req, T value) {
                this.getContext(req).setAttribute(this.name, value);
            }

            @Override
            public void remove(HttpServletRequest req) {
                this.getContext(req).removeAttribute(this.name);
            }

            private ServletContext getContext(HttpServletRequest req) {
                return req.getServletContext();
            }
        };
    }
}

