/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.kohsuke.stapler.CapturedParameterNames;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.InjectedParameter;

@GroovyASTTransformation
public class CaptureParameterNameTransformation
implements ASTTransformation {
    private static final Set<String> CONSTRUCTOR_ANN = Set.of(DataBoundConstructor.class.getName());
    private static final Set<String> INJECTED_PARAMETER_ANN = Set.of(InjectedParameter.class.getName());

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.handleClasses(source.getAST().getClasses());
    }

    private void handleClasses(List<ClassNode> classNodes) {
        for (ClassNode c : classNodes) {
            this.handleMethods(c.getMethods());
        }
    }

    private void handleMethods(List<MethodNode> methods) {
        for (MethodNode m : methods) {
            if (!this.hasAnnotation((AnnotatedNode)m, CONSTRUCTOR_ANN) && !this.hasInjectionAnnotation(m)) continue;
            this.write(m);
        }
    }

    private boolean hasInjectionAnnotation(MethodNode m) {
        for (Parameter p : m.getParameters()) {
            if (!this.hasInjectedParameterAnnotation(p)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnnotation(AnnotatedNode target, Set<String> annotationTypeNames) {
        for (AnnotationNode a : target.getAnnotations()) {
            if (!annotationTypeNames.contains(a.getClassNode().getName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasInjectedParameterAnnotation(Parameter p) {
        for (AnnotationNode a : p.getAnnotations()) {
            if (!this.hasAnnotation((AnnotatedNode)a.getClassNode(), INJECTED_PARAMETER_ANN)) continue;
            return true;
        }
        return false;
    }

    private void write(MethodNode c) {
        ListExpression v = new ListExpression();
        for (Parameter p : c.getParameters()) {
            v.addExpression((Expression)new ConstantExpression((Object)p.getName()));
        }
        AnnotationNode a = new AnnotationNode(new ClassNode(CapturedParameterNames.class));
        a.addMember("value", (Expression)v);
        c.addAnnotation(a);
    }
}

