/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class EvaluationTrace {
    private final List<String> traces = new ArrayList<String>();
    private static final Logger LOGGER = Logger.getLogger(EvaluationTrace.class.getName());
    private static final String KEY = EvaluationTrace.class.getName();

    public void trace(StaplerResponse2 rsp, String msg) {
        this.traces.add(msg);
        rsp.addHeader(String.format("Stapler-Trace-%03d", this.traces.size()), msg.replace("\n", "\\n").replace("\r", "\\r"));
    }

    public void printHtml(PrintWriter w) {
        for (String trace : this.traces) {
            w.println(Stapler.escape(trace));
        }
    }

    public static EvaluationTrace get(StaplerRequest2 req) {
        EvaluationTrace et = (EvaluationTrace)req.getAttribute(KEY);
        if (et == null) {
            et = new EvaluationTrace();
            req.setAttribute(KEY, et);
        }
        return et;
    }

    public static abstract class ApplicationTracer {
        private static volatile List<ApplicationTracer> tracers;

        protected abstract void record(StaplerRequest2 var1, String var2);

        public static void trace(StaplerRequest2 req, String message) {
            List<ApplicationTracer> tracers = ApplicationTracer.getTracers();
            for (ApplicationTracer tracer : tracers) {
                tracer.record(req, message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private static List<ApplicationTracer> getTracers() {
            Class<ApplicationTracer> clazz = ApplicationTracer.class;
            synchronized (ApplicationTracer.class) {
                if (tracers == null) {
                    ArrayList<ApplicationTracer> t = new ArrayList<ApplicationTracer>();
                    for (ApplicationTracer tracer : ServiceLoader.load(ApplicationTracer.class, Stapler.getCurrent().getWebApp().getClassLoader())) {
                        try {
                            t.add(tracer);
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, "Exception thrown when notifying tracer", e);
                        }
                    }
                    tracers = t;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return tracers;
            }
        }
    }
}

