/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jsr269;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.AbstractProcessor;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

abstract class AbstractProcessorImpl
extends AbstractProcessor {
    AbstractProcessorImpl() {
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="Jenkins handles this issue differently or doesn't care about it")
    protected String toString(Throwable t) {
        StringWriter w = new StringWriter();
        t.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    protected void error(Throwable t) {
        this.error(this.toString(t));
    }

    protected void error(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }

    protected String getJavadoc(Element md) {
        return this.processingEnv.getElementUtils().getDocComment(md);
    }

    protected void notice(String msg, Element location) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg, location);
    }

    protected void writePropertyFile(Properties p, String name) throws IOException {
        FileObject f = this.createResource(name);
        try (Writer w = f.openWriter();
             CommentStrippingBufferedWriter bw = new CommentStrippingBufferedWriter(w);){
            p.store(bw, null);
        }
    }

    protected FileObject getResource(String name) throws IOException {
        return this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", name);
    }

    protected FileObject createResource(String name) throws IOException {
        return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", name, new Element[0]);
    }

    private static class CommentStrippingBufferedWriter
    extends BufferedWriter {
        private final AtomicInteger count = new AtomicInteger(0);

        CommentStrippingBufferedWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(String str) throws IOException {
            if (this.count.getAndIncrement() > 0 || !str.startsWith("#")) {
                super.write(str);
            }
        }
    }
}

