/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.builds;

import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import com.cloudbees.plugins.credentials.builds.CredentialsParameterBinding;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.InvisibleAction;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class CredentialsParameterBinder
extends InvisibleAction {
    private final Map<String, CredentialsParameterBinding> boundCredentials = new ConcurrentHashMap<String, CredentialsParameterBinding>();

    @NonNull
    public static CredentialsParameterBinder getOrCreate(@NonNull Run<?, ?> run) {
        CredentialsParameterBinder resolver = (CredentialsParameterBinder)run.getAction(CredentialsParameterBinder.class);
        if (resolver == null) {
            resolver = new CredentialsParameterBinder();
            ParametersAction action = (ParametersAction)run.getAction(ParametersAction.class);
            if (action != null) {
                Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
                String userId = cause == null ? null : cause.getUserId();
                for (ParameterValue parameterValue : action) {
                    if (!(parameterValue instanceof CredentialsParameterValue)) continue;
                    resolver.bindCredentialsParameter(userId, (CredentialsParameterValue)parameterValue);
                }
            }
            run.addAction((Action)resolver);
        }
        return resolver;
    }

    public void bindCredentialsParameter(@CheckForNull String userId, @NonNull CredentialsParameterValue parameterValue) {
        this.boundCredentials.put(parameterValue.getName(), CredentialsParameterBinding.fromParameter(userId, parameterValue));
    }

    public void unbindCredentialsParameter(@NonNull String parameterName) {
        this.boundCredentials.remove(parameterName);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public CredentialsParameterBinding forParameterName(@NonNull String parameterName) {
        return this.boundCredentials.get(parameterName);
    }

    boolean isEmpty() {
        return this.boundCredentials.isEmpty();
    }
}

