/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.verifier;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.jenkinsci.plugins.gitclient.verifier.AbstractCliGitHostKeyVerifier;
import org.jenkinsci.plugins.gitclient.verifier.AbstractJGitHostKeyVerifier;
import org.jenkinsci.plugins.gitclient.verifier.HostKeyVerifierFactory;

public class ManuallyProvidedKeyVerifier
extends HostKeyVerifierFactory {
    private static final Logger LOGGER = Logger.getLogger(ManuallyProvidedKeyVerifier.class.getName());
    private final String approvedHostKeys;

    public ManuallyProvidedKeyVerifier(String approvedHostKeys) {
        this.approvedHostKeys = approvedHostKeys;
    }

    @Override
    public AbstractCliGitHostKeyVerifier forCliGit(TaskListener listener) {
        return (AbstractCliGitHostKeyVerifier & Serializable)tempKnownHosts -> {
            Files.write(tempKnownHosts, (this.approvedHostKeys + System.lineSeparator()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            listener.getLogger().println("Verifying host key using manually-configured host key entries");
            LOGGER.log(Level.FINEST, "Verifying manually-configured host keys entry in {0} with host keys {1}", new Object[]{tempKnownHosts.toAbsolutePath(), this.approvedHostKeys});
            String userKnownHostsFileFlag = File.pathSeparatorChar == ';' ? String.format(" -o UserKnownHostsFile=%s", ManuallyProvidedKeyVerifier.escapePath(tempKnownHosts)) : String.format(" -o UserKnownHostsFile=\\\"\"\"%s\\\"\"\"", ManuallyProvidedKeyVerifier.escapePath(tempKnownHosts));
            return "-o StrictHostKeyChecking=yes " + userKnownHostsFileFlag;
        };
    }

    private static String escapePath(Path path) {
        if (File.pathSeparatorChar == ';') {
            return path.toAbsolutePath().toString();
        }
        return path.toAbsolutePath().toString().replace(" ", "\\ ");
    }

    @Override
    @NonNull
    public File getKnownHostsFile() {
        try {
            Path tempKnownHosts = Files.createTempFile("known_hosts", "", new FileAttribute[0]);
            Files.write(tempKnownHosts, (this.approvedHostKeys + System.lineSeparator()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return tempKnownHosts.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AbstractJGitHostKeyVerifier forJGit(TaskListener listener) {
        return new ManuallyProvidedKeyJGitHostKeyVerifier(listener, this);
    }

    public static class ManuallyProvidedKeyJGitHostKeyVerifier
    extends AbstractJGitHostKeyVerifier {
        private File knownHostsFile;

        public ManuallyProvidedKeyJGitHostKeyVerifier(TaskListener listener, HostKeyVerifierFactory hostKeyVerifierFactory) {
            super(listener, hostKeyVerifierFactory);
        }

        @Override
        public ServerKeyDatabase.Configuration getServerKeyDatabaseConfiguration() {
            return new AbstractJGitHostKeyVerifier.DefaultConfiguration(this.getHostKeyVerifierFactory(), () -> ServerKeyDatabase.Configuration.StrictHostKeyChecking.REQUIRE_MATCH);
        }
    }
}

