/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.listeners;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.security.ACL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.Listeners;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ItemListener
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(ItemListener.class.getName());

    public void onCreated(Item item) {
    }

    public void onCheckCopy(Item src, ItemGroup parent) throws Failure {
    }

    public void onCopied(Item src, Item item) {
        this.onCreated(item);
    }

    public void onLoaded() {
    }

    public void onCheckDelete(Item item) throws Failure, InterruptedException {
    }

    public void onDeleted(Item item) {
    }

    public void onRenamed(Item item, String oldName, String newName) {
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
    }

    public void onUpdated(Item item) {
    }

    public void onBeforeShutdown() {
    }

    @Deprecated
    public void register() {
        ItemListener.all().add(this);
    }

    public static ExtensionList<ItemListener> all() {
        return ExtensionList.lookup(ItemListener.class);
    }

    public static void fireOnCopied(Item src, Item result) {
        Listeners.notify(ItemListener.class, false, l -> l.onCopied(src, result));
    }

    public static void checkBeforeCopy(Item src, ItemGroup parent) throws Failure {
        for (ItemListener l : ItemListener.all()) {
            try {
                l.onCheckCopy(src, parent);
            }
            catch (Failure e) {
                throw e;
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.WARNING, "failed to send event to listener of " + l.getClass(), x);
            }
        }
    }

    public static void fireOnCreated(Item item) {
        Listeners.notify(ItemListener.class, false, l -> l.onCreated(item));
    }

    public static void fireOnUpdated(Item item) {
        Listeners.notify(ItemListener.class, false, l -> l.onUpdated(item));
    }

    @Restricted(value={NoExternalUse.class})
    public static void checkBeforeDelete(Item item) throws Failure, InterruptedException {
        for (ItemListener l : ItemListener.all()) {
            try {
                l.onCheckDelete(item);
            }
            catch (Failure e) {
                throw e;
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.WARNING, "failed to send event to listener of " + l.getClass(), x);
            }
        }
    }

    public static void fireOnDeleted(Item item) {
        Listeners.notify(ItemListener.class, false, l -> l.onDeleted(item));
    }

    public static void fireLocationChange(Item rootItem, String oldFullName) {
        Object prefix = rootItem.getParent().getFullName();
        if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + "/";
        }
        String newFullName = rootItem.getFullName();
        assert (newFullName.startsWith((String)prefix));
        int prefixS = ((String)prefix).length();
        if (oldFullName.startsWith((String)prefix) && oldFullName.indexOf(47, prefixS) == -1) {
            String oldName = oldFullName.substring(prefixS);
            String newName = rootItem.getName();
            assert (newName.equals(newFullName.substring(prefixS)));
            Listeners.notify(ItemListener.class, false, l -> l.onRenamed(rootItem, oldName, newName));
        }
        Listeners.notify(ItemListener.class, false, l -> l.onLocationChanged(rootItem, oldFullName, newFullName));
        if (rootItem instanceof ItemGroup) {
            for (Item child : Items.allItems2(ACL.SYSTEM2, (ItemGroup)((Object)rootItem), Item.class)) {
                String childNew = child.getFullName();
                assert (childNew.startsWith(newFullName));
                assert (childNew.charAt(newFullName.length()) == '/');
                String childOld = oldFullName + childNew.substring(newFullName.length());
                Listeners.notify(ItemListener.class, false, l -> l.onLocationChanged(child, childOld, childNew));
            }
        }
    }
}

