/*
 * Decompiled with CFR 0.152.
 */
package hudson.scheduler;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.scheduler.BaseParser;
import hudson.scheduler.CrontabLexer;
import hudson.scheduler.CrontabParser;
import hudson.scheduler.Hash;
import hudson.scheduler.Messages;
import hudson.scheduler.RareOrImpossibleDateException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.util.antlr.JenkinsANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class CronTab {
    final long[] bits = new long[4];
    int dayOfWeek;
    private String spec;
    @CheckForNull
    private String specTimezone;

    public CronTab(String format) {
        this(format, null);
    }

    public CronTab(String format, Hash hash) {
        this(format, 1, hash);
    }

    @Deprecated(since="1.448")
    public CronTab(String format, int line) {
        this.set(format, line, null);
    }

    public CronTab(String format, int line, Hash hash) {
        this(format, line, hash, null);
    }

    public CronTab(String format, int line, Hash hash, @CheckForNull String timezone) {
        this.set(format, line, hash, timezone);
    }

    private void set(String format, int line, Hash hash) {
        this.set(format, line, hash, null);
    }

    private void set(String format, int line, Hash hash, String timezone) {
        CrontabLexer lexer = new CrontabLexer((CharStream)CharStreams.fromString((String)format));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new JenkinsANTLRErrorListener());
        lexer.setLine(line);
        CrontabParser parser = new CrontabParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new JenkinsANTLRErrorListener(parser::getErrorMessage));
        parser.setHash(hash);
        this.spec = format;
        this.specTimezone = timezone;
        parser.startRule(this);
        if ((this.dayOfWeek & 0x80) != 0) {
            this.dayOfWeek |= 1;
            this.dayOfWeek &= 0xFFFFFF7F;
        }
    }

    boolean check(Calendar cal) {
        Calendar checkCal = cal;
        if (this.specTimezone != null && !this.specTimezone.isEmpty()) {
            Calendar tzCal = Calendar.getInstance(TimeZone.getTimeZone(this.specTimezone));
            tzCal.setTime(cal.getTime());
            checkCal = tzCal;
        }
        if (!this.checkBits(this.bits[0], checkCal.get(12))) {
            return false;
        }
        if (!this.checkBits(this.bits[1], checkCal.get(11))) {
            return false;
        }
        if (!this.checkBits(this.bits[2], checkCal.get(5))) {
            return false;
        }
        if (!this.checkBits(this.bits[3], checkCal.get(2) + 1)) {
            return false;
        }
        return this.checkBits(this.dayOfWeek, checkCal.get(7) - 1);
    }

    public Calendar ceil(long t) {
        GregorianCalendar cal = new GregorianCalendar(Locale.US);
        cal.setTimeInMillis(t);
        return this.ceil(cal);
    }

    public Calendar ceil(Calendar cal) {
        Calendar twoYearsFuture = (Calendar)cal.clone();
        twoYearsFuture.add(1, 2);
        block0: while (true) {
            if (cal.compareTo(twoYearsFuture) > 0) {
                throw new RareOrImpossibleDateException();
            }
            for (CalendarField f : CalendarField.ADJUST_ORDER) {
                int next;
                int cur = f.valueOf(cal);
                if (cur == (next = f.ceil(this, cur))) continue;
                CalendarField l = f.lowerField;
                while (l != null) {
                    l.clear(cal);
                    l = l.lowerField;
                }
                if (next < 0) {
                    f.rollUp(cal, 1);
                    f.setTo(cal, f.first(this));
                    continue block0;
                }
                f.setTo(cal, next);
                if (f.valueOf(cal) != next) {
                    f.rollUp(cal, 1);
                    f.setTo(cal, f.first(this));
                    continue block0;
                }
                if (!f.redoAdjustmentIfModified) continue;
                continue block0;
            }
            break;
        }
        return cal;
    }

    public Calendar floor(long t) {
        GregorianCalendar cal = new GregorianCalendar(Locale.US);
        cal.setTimeInMillis(t);
        return this.floor(cal);
    }

    public Calendar floor(Calendar cal) {
        Calendar twoYearsAgo = (Calendar)cal.clone();
        twoYearsAgo.add(1, -2);
        block0: while (true) {
            if (cal.compareTo(twoYearsAgo) < 0) {
                throw new RareOrImpossibleDateException();
            }
            for (CalendarField f : CalendarField.ADJUST_ORDER) {
                int next;
                int cur = f.valueOf(cal);
                if (cur == (next = f.floor(this, cur))) continue;
                CalendarField l = f.lowerField;
                while (l != null) {
                    l.clear(cal);
                    l = l.lowerField;
                }
                if (next < 0) {
                    f.rollUp(cal, -1);
                    f.setTo(cal, f.last(this));
                    f.addTo(cal, 1);
                    CalendarField.MINUTE.addTo(cal, -1);
                    continue block0;
                }
                f.setTo(cal, next);
                f.addTo(cal, 1);
                CalendarField.MINUTE.addTo(cal, -1);
                if (!f.redoAdjustmentIfModified) continue;
                continue block0;
            }
            break;
        }
        return cal;
    }

    void set(String format, Hash hash) {
        this.set(format, 1, hash);
    }

    private boolean checkBits(long bitMask, int n) {
        return (bitMask | 1L << n) == bitMask;
    }

    public String toString() {
        return super.toString() + "[" + this.toString("minute", this.bits[0]) + "," + this.toString("hour", this.bits[1]) + "," + this.toString("dayOfMonth", this.bits[2]) + "," + this.toString("month", this.bits[3]) + "," + this.toString("dayOfWeek", this.dayOfWeek) + "]";
    }

    private String toString(String key, long bit) {
        return key + "=" + Long.toHexString(bit);
    }

    @CheckForNull
    public String checkSanity() {
        block0: for (int i = 0; i < 5; ++i) {
            long bitMask = i < 4 ? this.bits[i] : (long)this.dayOfWeek;
            for (int j = BaseParser.LOWER_BOUNDS[i]; j <= BaseParser.UPPER_BOUNDS[i]; ++j) {
                if (this.checkBits(bitMask, j)) continue;
                if (i <= 0) break block0;
                return Messages.CronTab_do_you_really_mean_every_minute_when_you(this.spec, "H " + this.spec.substring(this.spec.indexOf(32) + 1));
            }
        }
        int daysOfMonth = 0;
        for (int i = 1; i < 31; ++i) {
            if (!this.checkBits(this.bits[2], i)) continue;
            ++daysOfMonth;
        }
        if (daysOfMonth > 5 && daysOfMonth < 28) {
            return Messages.CronTab_short_cycles_in_the_day_of_month_field_w();
        }
        String hashified = CronTab.hashify(this.spec);
        if (hashified != null) {
            return Messages.CronTab_spread_load_evenly_by_using_rather_than_(hashified, this.spec);
        }
        return null;
    }

    @CheckForNull
    public static String hashify(String spec) {
        int period;
        if (spec.contains("H")) {
            return null;
        }
        if (spec.startsWith("*/")) {
            return "H" + spec.substring(1);
        }
        if (spec.matches("\\d+ .+")) {
            return "H " + spec.substring(spec.indexOf(32) + 1);
        }
        Matcher m = Pattern.compile("0(,(\\d+)(,\\d+)*)( .+)").matcher(spec);
        if (m.matches() && (period = Integer.parseInt(m.group(2))) > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = period; i < 60; i += period) {
                b.append(',').append(i);
            }
            if (b.toString().equals(m.group(1))) {
                return "H/" + period + m.group(4);
            }
        }
        return null;
    }

    @CheckForNull
    public TimeZone getTimeZone() {
        if (this.specTimezone == null) {
            return null;
        }
        return TimeZone.getTimeZone(this.specTimezone);
    }

    private static abstract class CalendarField {
        final int field;
        final CalendarField lowerField;
        final int offset;
        final int min;
        final boolean redoAdjustmentIfModified;
        private final String displayName;
        private static final CalendarField MINUTE = new CalendarField("minute", 12, 0, 0, false, null){

            @Override
            long bits(CronTab c) {
                return c.bits[0];
            }

            @Override
            void rollUp(Calendar cal, int i) {
                cal.add(11, i);
            }
        };
        private static final CalendarField HOUR = new CalendarField("hour", 11, 0, 0, false, MINUTE){

            @Override
            long bits(CronTab c) {
                return c.bits[1];
            }

            @Override
            void rollUp(Calendar cal, int i) {
                cal.add(5, i);
            }
        };
        private static final CalendarField DAY_OF_MONTH = new CalendarField("day", 5, 1, 0, true, HOUR){

            @Override
            long bits(CronTab c) {
                return c.bits[2];
            }

            @Override
            void rollUp(Calendar cal, int i) {
                cal.add(2, i);
            }
        };
        private static final CalendarField MONTH = new CalendarField("month", 2, 1, 1, false, DAY_OF_MONTH){

            @Override
            long bits(CronTab c) {
                return c.bits[3];
            }

            @Override
            void rollUp(Calendar cal, int i) {
                cal.add(1, i);
            }
        };
        private static final CalendarField DAY_OF_WEEK = new CalendarField("dow", 7, 1, -1, true, HOUR){

            @Override
            long bits(CronTab c) {
                return c.dayOfWeek;
            }

            @Override
            void rollUp(Calendar cal, int i) {
                cal.add(7, 7 * i);
            }

            @Override
            void setTo(Calendar c, int i) {
                int v = i - this.offset;
                int was = c.get(this.field);
                c.set(this.field, v);
                int firstDayOfWeek = c.getFirstDayOfWeek();
                if (v < firstDayOfWeek && was >= firstDayOfWeek) {
                    this.addTo(c, -7);
                } else if (was < firstDayOfWeek && firstDayOfWeek <= v) {
                    this.addTo(c, 7);
                }
            }
        };
        private static final CalendarField[] ADJUST_ORDER = new CalendarField[]{MONTH, DAY_OF_MONTH, DAY_OF_WEEK, HOUR, MINUTE};

        private CalendarField(String displayName, int field, int min, int offset, boolean redoAdjustmentIfModified, CalendarField lowerField) {
            this.displayName = displayName;
            this.field = field;
            this.min = min;
            this.redoAdjustmentIfModified = redoAdjustmentIfModified;
            this.lowerField = lowerField;
            this.offset = offset;
        }

        int valueOf(Calendar c) {
            return c.get(this.field) + this.offset;
        }

        void addTo(Calendar c, int i) {
            c.add(this.field, i);
        }

        void setTo(Calendar c, int i) {
            c.set(this.field, Math.min(i - this.offset, c.getActualMaximum(this.field)));
        }

        void clear(Calendar c) {
            this.setTo(c, this.min);
        }

        private int ceil(CronTab c, int n) {
            long bits = this.bits(c);
            while ((bits | 1L << n) != bits) {
                if (n > 60) {
                    return -1;
                }
                ++n;
            }
            return n;
        }

        private int first(CronTab c) {
            return this.ceil(c, 0);
        }

        private int floor(CronTab c, int n) {
            long bits = this.bits(c);
            while ((bits | 1L << n) != bits) {
                if (n == 0) {
                    return -1;
                }
                --n;
            }
            return n;
        }

        private int last(CronTab c) {
            return this.floor(c, 63);
        }

        abstract long bits(CronTab var1);

        abstract void rollUp(Calendar var1, int var2);
    }
}

