/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Util;
import java.io.File;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class DOSToUnixPathHelper {
    DOSToUnixPathHelper() {
    }

    private static boolean checkPrefix(String prefix, Helper helper) {
        File f = DOSToUnixPathHelper.constructFile(prefix);
        if (f.exists()) {
            helper.checkExecutable(f);
            return true;
        }
        File fexe = DOSToUnixPathHelper.constructFile(prefix + ".exe");
        if (fexe.exists()) {
            helper.checkExecutable(fexe);
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Limited use for locating shell executable by administrator.")
    private static File constructFile(String prefix) {
        return new File(prefix);
    }

    static void iteratePath(String exe, Helper helper) {
        if ((exe = Util.fixEmpty(exe)) == null) {
            helper.ok();
            return;
        }
        if (exe.indexOf(File.separatorChar) >= 0) {
            if (DOSToUnixPathHelper.checkPrefix(exe, helper)) {
                return;
            }
            helper.error("There's no such file: " + exe);
        } else {
            String tokenizedPath;
            String path = EnvVars.masterEnvVars.get("PATH");
            String delimiter = null;
            if (path != null) {
                StringBuilder tokenizedPathBuilder = new StringBuilder();
                for (String _dir : Util.tokenize(path.replace("\\", "\\\\"), File.pathSeparator)) {
                    if (delimiter == null) {
                        delimiter = ", ";
                    } else {
                        tokenizedPathBuilder.append(delimiter);
                    }
                    tokenizedPathBuilder.append(_dir.replace('\\', '/'));
                    if (!DOSToUnixPathHelper.checkPrefix(_dir + File.separator + exe, helper)) continue;
                    return;
                }
                tokenizedPathBuilder.append('.');
                tokenizedPath = tokenizedPathBuilder.toString();
            } else {
                tokenizedPath = "unavailable.";
            }
            helper.error("There's no such executable " + exe + " in PATH: " + tokenizedPath);
        }
    }

    static interface Helper {
        public void ok();

        public void checkExecutable(File var1);

        public void error(String var1);

        public void validate(File var1);
    }
}

