/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.Permission;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.ProjectNamingStrategy;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;

@Extension(ordinal=250.0)
@Symbol(value={"projectNamingStrategy"})
public class GlobalProjectNamingStrategyConfiguration
extends GlobalConfiguration {
    @Override
    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        Jenkins j = Jenkins.get();
        JSONObject optJSONObject = json.optJSONObject("useProjectNamingStrategy");
        if (optJSONObject != null) {
            JSONObject strategyObject = optJSONObject.getJSONObject("namingStrategy");
            String className = strategyObject.getString("$class");
            try {
                Class<?> clazz = Class.forName(className, true, j.getPluginManager().uberClassLoader);
                ProjectNamingStrategy strategy = (ProjectNamingStrategy)req.bindJSON(clazz, strategyObject);
                j.setProjectNamingStrategy(strategy);
            }
            catch (ClassNotFoundException e) {
                throw new Descriptor.FormException(e, "namingStrategy");
            }
        }
        if (j.getProjectNamingStrategy() == null) {
            j.setProjectNamingStrategy(ProjectNamingStrategy.DEFAULT_NAMING_STRATEGY);
        }
        return true;
    }

    @Override
    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }
}

